unit SpriteEditUnit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Spin, ComCtrls, Buttons, Gauges;

   //IntPower: Raise base to an integral power.  Fast.  (From Delphi Math)
  function IntPower(Base: Extended; Exponent: Integer): Extended ;

  //Calculate Width in bytes of Iff image (image width must be alligned to WORD boundry)
  function AllignWord(w: Integer): Integer;

  //Calculate Width in bytes of image (image width must be alligned to DWORD boundry)
function AllignDWord(w: Integer): Integer;


type

PPixelArray = ^TPixelArray;
TPixelArray = array [0..1023,0..1023] of TRGBTriple;


TBitmapPixel = byte;
Tbitmaparray = array[0..31,0..31] of TBitMapPixel;
TPixelline = class
           Value:array[0..4000]of byte;
end;

TImageExtension = class
       Pixels:array[0 .. 4095] of byte;
       Next:integer;
end;


//Image Bank Colour
  TImgLibColor = record
        Red: Byte;
        Green: Byte;
        Blue: Byte;
        Used: Boolean;
  end;

  //Image Bank Palette
  TImgLibPalette = array[0..255] of TImgLibColor;

//Image Library Header Structure
  TImgLibHeader = record
       IDent: array[0..3] of Char;
       ImageCount: Integer;
       TransparentColor: Integer;
       Palette: TImgLibPalette;
  end;
 //Image Structure
  TImgLibImage = record
       Width: Integer;
       Height: Integer;
       Name: String[8];
       Bits: TBitmapArray;
       //Bits: Tlist;
   end;



  
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    ListBox1: TListBox;
    Panel3: TPanel;
    Panel4: TPanel;
    ScrollBox1: TScrollBox;
    Label1: TLabel;
    Shape1: TShape;
    Panel5: TPanel;
    Image1: TImage;
    TrackBar1: TTrackBar;
    StatusBar1: TStatusBar;
    SourceImage: TImage;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    OpenDialog1: TOpenDialog;
    BTNAddImage: TButton;
    BTNRemoveImage: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Panel6: TPanel;
    Label4: TLabel;
    Gauge1: TGauge;
    Image2: TImage;
    Paintbox1: TPaintBox;
    Image3: TImage;
    Timer1: TTimer;
    OpenDialog2: TOpenDialog;
    procedure LoadLib(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TrackBar1Change(Sender: TObject);
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TrackBar1Enter(Sender: TObject);
    procedure TrackBar1Exit(Sender: TObject);
    procedure PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SpriteRefresh(Sender: TObject);
    procedure SaveLib(Sender: TObject);
    procedure PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImportBmp(Sender: TObject);
    procedure BTNAddImageClick(Sender: TObject);
    procedure RemapImage;
    procedure Button1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
     { IntPower: Raise base to an integral power.  Fast. }
     //function IntPower(Base: Extended; Exponent: Integer): Extended;

  private
    { Private declarations }
  public
    { Public declarations }
    ImgLibHdr:TImgLibHeader;
    LibColor:TImgLibColor;
    ImgLibImg:array[0..255] of TImgLibImage;
    color:array[0..255]of Tcolor;
    Importcolor:array[0..255]of Tcolor;
    ColorUsed:array[0..255]of Boolean;
    ActiveColor,BackGroundColor:integer;
    BackBitmap:Tbitmap;
    Zoomfactor:integer;
    Setupdone,zoom:Boolean;
    Mousex,Mousey:integer;
    Drawing,Imagechanged:Boolean;
    CurrentImage:integer;
    NewBmp:Tbitmap;
    PixelPtr: PPixelArray;  // ptr to pixel memory
    DIB: THandle;
    teller:longint;
    Palette:TlogPalette;
  end;

var
  Form1: TForm1;

implementation

Uses bmpUtil;

{$R *.DFM}

procedure TForm1.LoadLib(Sender: TObject);
var
   f:file;
   i,j,X,y:integer;
   p:pointer;
   ExtensionList:Tlist;
   b:byte;
   offset:Longint;

   BI: TBitmapInfo;
   DC: HDC;
begin
if opendialog2.execute then
begin
   Palette.palVersion := $300;
   Palette.palNumEntries := 256;
   for x := 0 to 255 do
   begin
       // Palette.palPalEntry[x].peRed := 0;
       // Palette.palPalEntry[x].peGreen := 0;
       // Palette.palPalEntry[x].peBlue := 255;
       // Palette.palPalEntry[x].peFlags := 0;
   end;


 FillChar(BI, sizeof(BI), 0);
   with BI.bmiHeader do
   begin
     biSize := sizeof(BI.bmiHeader);
     biWidth := 1024;  // multiple of 4 simplifies dword alignment
     biHeight := -1024;  // negative = top-down bitmap
     biPlanes := 1;  // must be 1 for DIBs
     biBitCount := 24;
   end;
  DC := GetDC(0);
  DIB := CreateDIBSection(DC, BI, DIB_RGB_COLORS, Pointer(PixelPtr),nil, 0);
  ReleaseDC(0, DC);


  Backbitmap:=Tbitmap.create;
  Image2.picture.Bitmap.Handle := DIB;


     ExtensionList:=Tlist.create;
     offset:=0;
    //ImExtend:=TImageExtenion.Create;
     assignfile(f,opendialog2.filename);
     reset(f,1);
     blockread(f,ImgLibHdr,sizeof(ImgLibHdr));

     offset:=offset+sizeof(ImgLibHdr);
     //load DIB
     for i:=0 to ImglibHdr.imagecount-5 do
     begin
          seek(f,offset);
          blockread(f,ImgLibImg[i],sizeof(ImgLibImg[i]));
          listbox1.items.add(ImgLibImg[i].name);
          offset:=offset+sizeof(ImgLibImg[i])-sizeof(ImgLibImg[i].bits)+(AllignDword(ImgLibImg[i].width)*ImgLibImg[i].height);
     end;
     closefile(f);
     label1.caption:=inttostr(ImgLibHdr.imagecount);

     // set color table
     for x:=0 to 255 do
     begin
          LibColor:=ImglibHdr.Palette[x];
          color[x]:=(libcolor.Blue * 256 *256)+(libcolor.Green * 256)+Libcolor.red;
          colorUsed[x]:=libcolor.Used;
     end;

     // draw Palette
     x:=0;
     y:=0;
     for i:=0 to 255 do
     begin
         Image1.canvas.brush.Color := color[i];
         Image1.canvas.Brush.Style := bsSolid;
         image1.Canvas.fillrect(Rect(X*12, Y*8, (X+1)*12,(Y+1)*8));
         inc(y);
         if y>31 then
         begin
              y:=0;
              inc(x);
         end;
     end;




     setupdone:=true;
     
    listbox1.itemindex:=0;
    currentimage:=0;
    zoom:=true;
    listbox1click(sender);
    zoom:=false;
end;
end;

procedure TForm1.ListBox1Click(Sender: TObject);
var
   i,x,y:integer;
   b:byte;
begin
if setupdone then
begin
  {   if Imagechanged and (Listbox1.itemindex <> CurrentImage) then // eerst tekening opslaan (op BackBitmap);
     begin
          //sprite[currentImage].canvas.Copyrect(rect(0,0,sprite[CurrentImage].width,Sprite[CurrentImage].height),SourceImage.canvas,rect(0,0,SourceImage.height,SourceImage.width));
          ImageChanged:=False;
          Statusbar1.panels[1].text:='Not Modified';
     end;
    //if zoom or (sender=listbox1) then Sourceimage.canvas.copyrect(rect(0,0,SourceImage.width,SourceImage.height),sprite[listbox1.itemindex].canvas,rect(0,0,sprite[listbox1.itemindex].width,sprite[listbox1.itemindex].height));
    if zoom or (sender=listbox1) then Sourceimage.canvas.copyrect(rect(0,0,32,32),sprite[listbox1.itemindex].canvas,rect(0,0,32,32));
    CurrentImage:=Listbox1.itemindex;
    paintbox1.refresh;  }
  GDIFlush; // force NT to finish any pending GDI ops on bitmap
  for x:=0 to 31 do
  begin
      for y:=0 to 31 do
      begin
           with PixelPtr^[x,y] do
           begin  // fill with the sprite data
              b:=ImgLibImg[listbox1.itemindex].bits[x,y+4];
              LibColor:=ImglibHdr.Palette[b];
              rgbtRed := libcolor.red;
              rgbtGreen := libcolor.Green;
              rgbtBlue := libcolor.Blue;
              end;
      end;
  end;
  image2.Invalidate;
 Sourceimage.canvas.Copyrect(rect(0,0,32,32),image2.canvas,rect(0,0,32,32));
 paintbox1.canvas.Copyrect(rect(0,0,paintbox1.width,paintbox1.height),image2.canvas,rect(0,0,32,32));


end;
end;

procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
ActiveColor:=(y div 8)+((x div 12)*32);
shape1.brush.color:=color[activecolor];
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
     paintbox1.width:=32*(trackbar1.position+1);
     paintbox1.height:=paintbox1.width;
end;

procedure TForm1.PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
     Drawing:=true;
     ImageChanged:=true;
     Statusbar1.panels[1].text:='Modified';
     Paintbox1.canvas.brush.color:=color[activecolor];
     Paintbox1.canvas.fillrect(rect((Mousex*(trackbar1.position+1)),Mousey*(trackbar1.position+1),((Mousex+1)*(trackbar1.position+1)),(Mousey+1)*(trackbar1.position+1)));

end;

procedure TForm1.TrackBar1Enter(Sender: TObject);
begin
Zoom:=true;
end;

procedure TForm1.TrackBar1Exit(Sender: TObject);
begin
Zoom:=false;
end;

procedure TForm1.PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
MouseX:=x div (paintbox1.width div 32);
Mousey:=y div (paintbox1.height div 32);
Statusbar1.panels[0].text:='Co '+inttostr(Mousex)+','+inttostr(Mousey);

if drawing then
begin
   Paintbox1.canvas.brush.color:=color[activecolor];
   Paintbox1.canvas.fillrect(rect((Mousex*(trackbar1.position+1)),Mousey*(trackbar1.position+1),((Mousex+1)*(trackbar1.position+1)),(Mousey+1)*(trackbar1.position+1)));

end;

end;

procedure TForm1.SpriteRefresh(Sender: TObject);
begin
if setupdone then  paintbox1.canvas.Copyrect(rect(0,0,paintbox1.width,paintbox1.height),image2.canvas,rect(0,0,image2.width,image2.height));
end;

procedure TForm1.SaveLib(Sender: TObject);
var
   f:file;
   x,y:integer;
begin
     ImgLibHdr.imagecount:=listbox1.items.count;

     // Palette Zetten
     for x:=0 to 255 do
     begin
          libcolor.Red:=Color[x] mod 256;
          libcolor.Green:=(Color[x] div 256) mod 256;
          libcolor.Blue:=(Color[x] div (256*256));
          libcolor.Used:=ColorUsed[x];
          LibColor:=ImglibHdr.Palette[x];
          ImgLibHdr.Palette[x]:=libcolor;

     end;
     assignfile(f,'f:\programming\projects\project Boulder\MagicP2.iml');
     rewrite(f,1);
     blockwrite(f,ImgLibHdr,sizeof(ImgLibHdr));
     for x:=0 to ImgLibHdr.Imagecount-1 do
     begin
          blockwrite(f,ImgLibImg[x],sizeof(ImgLibImg[x]));
     end;
     closefile(f);

end;

procedure TForm1.PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
drawing:=false;
end;

procedure TForm1.ImportBmp(Sender: TObject);
var
   f,f2:file;
   b1,b2,b3,b4,bitplanes,bitmask:byte;
   wrd:word;
   W,H,i,j,k,l,x,y,compressedLenght:integer;
   offset,offset2:longint;
   line:TPixelline;
   IffPalette:array[0..255,0..2]of byte;
   ChunkId:array[0..3]of char;
   compressed:Boolean;
   Bitline:array[1..8] of Tpixelline;
   Bytebit:array[1..8] of byte;
begin
if opendialog1.execute then
begin
     if extractfileExt(Opendialog1.filename)='.bmp' then
     begin
          image3.picture.bitmap.loadfromfile(opendialog1.filename);
          Sourceimage.canvas.copyrect(rect(0,0,32,32),image3.canvas,rect(0,0,image3.width,image3.height));
          paintbox1.canvas.copyrect(rect(0,0,paintbox1.width,paintbox1.height),image3.canvas,rect(0,0,image3.width,image3.height));
         // paintbox1.refresh;
          BtnAddImage.enabled:=true;
     end ;
     if extractfileExt(Opendialog1.filename)='.iff' then
     begin
          panel6.visible:=True;
          gauge1.progress:=0;

          assignfile(f,Opendialog1.filename);
          reset(f,1);
          // eigenlijk eerst nog controle op FORM ILBM)
          // BitmapHeader lezen
          seek (f,20);
          blockread(f,B1,1);
          blockread(f,B2,1);
          image2.width:=(b1*256)+b2;
          W:=image2.width;
          label2.caption:= 'width: '+inttostr(w);
          //blockread(f,wrd,2);
          blockread(f,B1,1);
          blockread(f,B2,1);
          image2.height:=(b1*256)+b2;
          H:=image2.Height;
          label3.caption:= 'Height: '+inttostr(H);

          //Sprite[CurrentImage].height:=32;
          //H:=Sprite[CurrentImage].Height;

          // aantal bitplanes lezen
          blockread(f,B1,1);
          blockread(f,B1,1); // word: Image x offset
          blockread(f,B1,1);
          blockread(f,B1,1); // word: Image Y offset
          blockread(f,Bitplanes,1); // bitplanes
          label1.caption:=inttostr(bitplanes);
          blockread(f,B1,1); // mask (0=no, 1=impl., 2=transparent, 3=lasso)
          blockread(f,B1,1);
          if B1=1 then compressed:=true
          else
          compressed:=false;

          // read ColorMap (CMAP)
          offset:=48;
          seek(f,offset);
          blockread(f,Iffpalette,trunc(intpower(2,bitplanes))*3);
          // pallete zetten:
          for i:=0 to trunc(intpower(2,bitplanes))-1 do
          begin
               importcolor[i]:=(Iffpalette[i,2]*256*256)+(Iffpalette[i,1]*256)+Iffpalette[i,0]
          end;


          // draw Palette
     x:=0;
     y:=0;
     for i:=0 to trunc(intpower(2,bitplanes))-1 do
     begin
         Image1.canvas.brush.Color := importcolor[i];
         Image1.canvas.Brush.Style := bsSolid;
         image1.Canvas.fillrect(Rect(X*(image1.width div bitplanes), Y*(image1.height div (bitplanes * 2)), (X+1)*(image1.width div bitplanes),(Y+1)*(image1.height div (bitplanes * 2))));
         inc(y);
         if y>=(image1.height div (bitplanes * 2)) then
         begin
              y:=0;
              inc(x);
         end;
     end;


          // Decode BODY
          // first find body ...
          i:=0;
          offset:=offset+(trunc(intpower(2,bitplanes))*3);
          repeat
                Blockread(f,ChunkId,4);
                if ChunkId='BODY' then
                   //exit
                else    // andere Chunk ID tegengekomen (bv Colorcycling, CAMG, ...)
                begin
                seek(f,offset);
                blockread(f,B1,1);
                blockread(f,B2,1);
                blockread(f,B3,1);
                blockread(f,B4,1);
                //offset:=offset+(B1*256*256*256)+(B2*256*256)+(B3*256)+B4;
                offset:=offset+B4;
                end;
                inc(i);
          until (ChunkId = 'BODY') or (i=2);
          if compressed then
          begin
               // decompress Bitepack-compression
               seek(f,offset+4);
               offset2:=0;
               blockread(f,B1,1);
               blockread(f,B2,1);
               blockread(f,B3,1);
               blockread(f,B4,1);
               CompressedLenght:=(B1*256*256*256)+(B2*256*256)+(B3*256)+B4;
               label1.caption:=inttostr(CompressedLenght);
               assignfile(f2,'f:\work\iff.tmp');
               rewrite(f2,1);
               while not EOF(f) do // dit klopt eigenlijk wel niet: er kan nog iets acher BODY komen
               begin
                    //seek(f,offset2);
                    blockread(f,B1,1);
                    // wat als byte 128 is ?? (wordt volgens mij niet gebruikt)
                    if b1>128 then
                    begin
                         blockread(f,B2,1);
                         for j:= 1 to 257-b1 do
                         begin
                              blockwrite(f2,B2,1);
                         end;
                    end;
                    if b1<128 then
                    begin
                         for j:= 1 to b1+1 do
                         begin
                              blockread(f,B2,1);
                              blockwrite(f2,B2,1);
                         end;

                    end;
               end;
               closefile(f);
               closefile(f2);
               assignfile(f,'f:\work\iff.tmp');
               reset(f,1);
               offset:=-8;
          end;
        //  if not compressed then
        //  begin
        teller:=0;
        Timer1.enabled:=true;
          offset:=offset+8;
          seek(f,offset);
          x:=0;
          y:=0;

         for i:= 0 to H-1 do // per Horizontale lijn
          begin
            {   line:=TPixelline.create;
               for j:=1 to bitplanes do
               begin
                    bitline[j]:=Tpixelline.create;
                    blockread(f,bitline[j].value,4);
               end;
               for j:= 1 to (w div 4) do  // w div 4
               begin
                    bitmask:=128;
                    for k:=1 to 8 do  // 8 bits per byte
                    begin
                         x:=0;
                         for l:=1 to bitplanes do bytebit[l]:=bitline[l].value[j] and bitmask;
                        //for l:=1 to bitplanes do bytebit[l]:=15 and bitmask;
                         for l:=1 to bitplanes do
                         begin
                              bytebit[l]:= bytebit[l] shr (8-l);
                              inc(x,bytebit[l]);
                         end;
                         line.value[((j-1)*8)+k]:=byte(x);
                         for l:=1 to bitplanes do bitline[l].value[j] := bitline[l].value[j] shl 1;
                    end;
               end;  }
               line:=TPixelline.create;

               for j:=1 to bitplanes do // aantal bitplanes
               begin
                    // nieuw bitplane: terug beginnen aan het begin van de Horizontale lijn
                    y:=0;
                    for K:=1 to AllignWord(w) do // 8 pixels per byte, word alligned
                    begin
                         blockread(f,B1,1);
                        // for l:=1 to 8 do
                        // begin
                        //      if b1>=trunc(intpower(2,8-l)) then  // nagaan welke bit 1 is
                        //      begin
                        //           // bitplane staat aan: kleur verhogen (kan ook gewoon j moeten zijn)
                        //           line.value[y]:=line.value[y]+trunc(intpower(2,j-1));
                        //           dec(b1,trunc(intpower(2,8-l)));
                        //      end;
                        //      inc(y);
                        // end;
                         bitmask:=128; // bits: 10000000
                         b2:=b1 and bitmask;
                         if b2>0 then line.value[y]:=line.value[y]+trunc(intpower(2,j-1));
                         inc(y);
                         bitmask:=64; // bits: 10000000
                         b2:=b1 and bitmask;
                         if b2>0 then line.value[y]:=line.value[y]+trunc(intpower(2,j-1));
                         inc(y);
                         bitmask:=32; // bits: 01000000
                         b2:=b1 and bitmask;
                         if b2>0 then line.value[y]:=line.value[y]+trunc(intpower(2,j-1));
                         inc(y);
                         bitmask:=16; // bits: 10000000
                         b2:=b1 and bitmask;
                         if b2>0 then line.value[y]:=line.value[y]+trunc(intpower(2,j-1));
                         inc(y);
                         bitmask:=8; // bits: 10000000
                         b2:=b1 and bitmask;
                         if b2>0 then line.value[y]:=line.value[y]+trunc(intpower(2,j-1));
                         inc(y);
                         bitmask:=4; // bits: 10000000
                         b2:=b1 and bitmask;
                         if b2>0 then line.value[y]:=line.value[y]+trunc(intpower(2,j-1));
                         inc(y);
                         bitmask:=2; // bits: 10000000
                         b2:=b1 and bitmask;
                         if b2>0 then line.value[y]:=line.value[y]+trunc(intpower(2,j-1));
                         inc(y);
                         bitmask:=1; // bits: 00000000
                         b2:=b1 and bitmask;
                         if b2>0 then line.value[y]:=line.value[y]+trunc(intpower(2,j-1));
                         inc(y);

                    end; 
               end;
               // lijn tekenen
               gauge1.progress:=round(i*(100 / h));
               for y:=0 to W-1 do
               begin
                   //image2.canvas.pixels[y,i]:=importcolor[line.value[y]];
                   with PixelPtr^[i,y] do
                   begin  // fill with the sprite data
                     rgbtRed := Iffpalette[line.value[y],0];
                     rgbtGreen := Iffpalette[line.value[y],1];
                     rgbtBlue := Iffpalette[line.value[y],2];
                   end;
               end;
               line.destroy;
          end;
          // Sprite is volledig opgebouwd.
          panel6.visible:=false;
          closefile(f);
          Sourceimage.canvas.copyrect(rect(0,0,32,32),image2.canvas,rect(0,0,image2.width,image2.height));
          paintbox1.refresh;
          BtnAddImage.enabled:=true;
          timer1.enabled:=false;
          label1.caption:=inttostr(teller);
        // end
        // else
        //  MessageDlg('Compressed Iff are not yet implemented', mtInformation,[mbOk], 0);


     end;
end;

end;

procedure TForm1.BTNAddImageClick(Sender: TObject);
begin
     RemapImage
end;

procedure TForm1.RemapImage;
var
    x,y,i,j:integer;
    colorS:Tcolor;
    ColorBlue,ColorRed,ColorGreen:integer;
    Distance,NewDistance:integer;
    ClosestMatch:integer;
begin
     Panel6.visible:=true;
     gauge1.progress:=0;
     // Without Adding Colors: Remap to other Palette
     y:=0;
     for x:=0 to image3.width-1 do
     begin
          for y:=0 to image3.height-1 do
          begin
          // Compare Colors
          colorS:=image3.canvas.pixels[x,y];
          colorRed:=ColorS mod 256;
          colorGreen:=(ColorS div 256) mod 256;
          colorBlue:=(ColorS div (256*256));
          Distance:=abs(Colorred-ImgLibHdr.palette[0].red)+abs(ColorBlue-ImgLibHdr.palette[0].Blue)+abs(ColorGreen-ImgLibHdr.palette[0].Green);
          ClosestMatch:=0;
          for i:=1 to 255 do
          begin
               // check entire palette for closest match
               NewDistance:=abs(Colorred-ImgLibHdr.palette[i].red)+abs(ColorBlue-ImgLibHdr.palette[i].Blue)+abs(ColorGreen-ImgLibHdr.palette[i].Green);
               if NewDistance<Distance then
               begin
                    Distance:=NewDistance;
                    ClosestMatch:=i;
               end;
          end;
          // Change the pixel to the new color
          image3.canvas.pixels[x,y]:=color[ClosestMatch];

        
         end;
         gauge1.progress:=round(x*(100 / image2.width));
     end;
     // Copy to the Backbitmap and to the array;
     panel6.visible:=false;
     CurrentImage:=listbox1.items.count;
     Listbox1.items.add('tuut');

     Sourceimage.canvas.copyrect(rect(0,0,32,32),image2.canvas,rect(0,0,32,32));
   // paintbox1.refresh;

end;

// from Delphi Math
function IntPower(Base: Extended; Exponent: Integer): Extended;
asm
        mov     ecx, eax
        cdq
        fld1                      { Result := 1 }
        xor     eax, edx
        sub     eax, edx          { eax := Abs(Exponent) }
        jz      @@3
        fld     Base
        jmp     @@2
@@1:    fmul    ST, ST            { X := Base * Base }
@@2:    shr     eax,1
        jnc     @@1
        fmul    ST(1),ST          { Result := Result * X }
        jnz     @@1
        fstp    st                { pop X from FPU stack }
        cmp     ecx, 0
        jge     @@3
        fld1
        fdivrp                    { Result := 1 / Result }
@@3:
        fwait
end;

//Calculate Width in bytes of Iff image (image width must be alligned to WORD boundry)
function AllignWord(w: Integer): Integer;
begin
    Result := ((w + 15) div 16)*2;
end;

//Calculate Width in bytes of image (image width must be alligned to DWORD boundry)
function AllignDWord(w: Integer): Integer;
begin
     Result := (((w * 8) + 31) div 32) * 4;
end;



procedure TForm1.Button1Click(Sender: TObject);
var
   myarray:array[0..0]of byte;
   p:pointer;
   b:byte;
   test:array[1..1024]of byte;
   bitm:Tbitmap;
   f:file;
begin

end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
inc(teller);
label1.caption:=inttostr(teller);
end;

end.
