unit FMUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, ExtCtrls;

type


  TForm1 = class(TForm)
    Memo1: TMemo;
    SpinEdit1: TSpinEdit;
    Image1: TImage;
    Image2: TImage;
    Label1: TLabel;
    ScrollBox1: TScrollBox;
    Image3: TImage;
    ECS: TRadioButton;
    AGA: TRadioButton;
    Panel1: TPanel;
    Label2: TLabel;
    Panel2: TPanel;
    Panel3: TPanel;
    Label3: TLabel;
    Label4: TLabel;
    Button3: TButton;
    Button4: TButton;
    Label5: TLabel;
    Button2: TButton;
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    procedure Readgfx(Sender: TObject);
    function inttobin(b:integer):integer;
    function power2(b:integer):integer;
    procedure DrawSprite(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Image2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SaveBitmap(Sender: TObject);
    procedure Image3MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure AGAClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
   


  private
    { Private declarations }
  public
    { Public declarations }
    Spritebits:Array[0..778,0..3,0..31] of byte;
    SpritebitsAGA:Array[0..778,0..5,0..31] of byte;
    Sprites:array[0..100,0..15,0..15] of byte;
    Sprite:array[0..255] of byte;
    Spritenumber:integer;
    Pallete:Array[0..255] of Tcolor;
    Drawall:Boolean;
    isaga:boolean;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Readgfx(Sender: TObject);
var
   f,f2:file;

   b1,b2:integer;
   x,y:integer;
   Sprite:array[0..255] of byte;
   S,s2:String;
begin
if isaga then
begin
 opendialog1.FileName := 'Gfx-AGA';
end else begin
  opendialog1.FileName := 'Gfx-ECS';
end;
if opendialog1.Execute() then
begin
  Assignfile(f,opendialog1.filename);
  reset(f,1);

  if isaga then
    blockread(f2,SpritebitsAGA,sizeof(spritebitsAGA))
  else
    blockread(f,Spritebits,sizeof(spritebits));

    closefile(f);

    Drawsprite(Sender);
  end;
end;

function TForm1.inttobin(b:integer):integer;
begin
     if b=0 then result:=0;
     if b=1 then result:=1;
     if b=2 then result:=10;
     if b=3 then result:=11;
     if b=4 then result:=100;
     if b=5 then result:=101;
     if b=6 then result:=110;
     if b=7 then result:=111;
     if b=8 then result:=1000;
     if b=9 then result:=1001;
     if b=10 then result:=1010;
     if b=11 then result:=1011;
     if b=12 then result:=1100;
     if b=13 then result:=1101;
     if b=14 then result:=1110;
     if b=15 then result:=1111;
end;

function TForm1.power2(b:integer):integer;
begin
     if b=0 then result:=1;
     if b=1 then result:=2;
     if b=2 then result:=4;
     if b=3 then result:=8;
     if b=4 then result:=16;
     if b=5 then result:=32;
     if b=6 then result:=64;
     if b=7 then result:=128;
end;

procedure TForm1.DrawSprite(Sender: TObject);
var
   b1,b2:integer;
   x,y:integer;

   S,s2:String;
   Bitplanes:integer;
begin

Spritenumber:=SpinEdit1.value;
for x:=0 to 255 do Sprite[x]:=0;
Memo1.lines.clear;
// convert bitplanes to dib

if ECS.Checked then bitplanes:=3;
if AGA.Checked then bitplanes:=5;
for y:=0 to bitplanes do
for x:= 0 to 31 do
begin
   b1:=inttobin(Spritebits[Spritenumber,y,x] div 16);
   b2:=inttobin(spritebits[Spritenumber,y,x] mod 16);

   if AGA.checked then
   begin
        b1:=inttobin(SpritebitsAGA[Spritenumber,y,x] div 16);
        b2:=inttobin(spritebitsAGA[Spritenumber,y,x] mod 16);
   end;

   Sprite[(x*8)]:= Sprite[(x*8)]+((power2(y)*(b1 div 1000)));
   Sprite[(x*8)+1]:=Sprite[(x*8)+1]+(power2(y)*((b1 mod 1000) div 100));
   Sprite[(x*8)+2]:=Sprite[(x*8)+2]+(power2(y)*((b1 mod 100) div 10));
   Sprite[(x*8)+3]:=Sprite[(x*8)+3]+(power2(y)*((b1 mod 10)));
   Sprite[(x*8)+4]:=Sprite[(x*8)+4]+(power2(y)*(b2 div 1000));
   Sprite[(x*8)+5]:=Sprite[(x*8)+5]+(power2(y)*((b2 mod 1000) div 100));
   Sprite[(x*8)+6]:=Sprite[(x*8)+6]+(power2(y)*((b2 mod 100) div 10));
   Sprite[(x*8)+7]:=Sprite[(x*8)+7]+(power2(y)*((b2 mod 10)));

end;
If DrawAll then
for x:=0 to 15 do
begin
     s:='';
     for y:=0 to 15 do
     begin
          s2:= inttostr(Sprite[(x*16)+y]);
          if Sprite[(x*16)+y]< 10 then S2:='0'+S2;
          s:=S+ S2+ '  ';
     end;
     memo1.lines.add(s);
end;

for x:=0 to 15 do
begin
     for y:=0 to 15 do
     begin
          Image1.canvas.pixels[y,x]:=Pallete[(Sprite[(x*16)+y])];
     end;
end;

if drawall then Image2.canvas.Copyrect(rect(0,0,128,128),Image1.canvas,rect(0,0,16,16));

end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
Drawsprite(sender);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   i:integer;
begin
DrawAll:=true;



for i:=0 to 255 do Pallete[i]:=random($ffffff);

Pallete[0]:=0;
Pallete[1]:=$FFFFFF;
Pallete[2]:=$00FF00;
Pallete[3]:=$00CF00;
Pallete[4]:=$9F9F9F;
Pallete[5]:=$0057AF;
Pallete[6]:=$0088DF;
Pallete[7]:=$00CFFF;
Pallete[8]:=$CFCFCF;
Pallete[9]:=$009800;
Pallete[10]:=$646464;
Pallete[11]:=$0000FF;
Pallete[12]:=$0000CF;
Pallete[13]:=$FFF000;
Pallete[14]:=$FF8800;
Pallete[15]:=$CF0000;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
   x,X1,Y1:integer;
begin


for x:=0 to 778 do
begin
     Drawall:=false;
     spinEdit1.value:=x;
     X1:=(x mod 20)*16;
     Y1:=(X div 20)*16;
     Image3.canvas.copyrect(rect(X1,Y1,X1+16,Y1+16),Image1.canvas,rect(0,0,16,16));
     DrawAll:=true;

end;

end;

procedure TForm1.Image2MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
   i:integer;
begin
     Label1.caption:=inttostr(X div 8)+','+inttostr(Y div 8)+': color: '+ inttostr(Sprite[(X div 8)+((Y div 8)*16)]);
end;

procedure TForm1.SaveBitmap(Sender: TObject);
begin
Image3.picture.savetofile('C:\Windows\Desktop\FM.bmp');
end;

procedure TForm1.Image3MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
SpinEdit1.value:=(X div 16)+((Y div 16)*20);
end;

procedure TForm1.AGAClick(Sender: TObject);
var
   x:integer;
   R,G,B:integer;
begin
randomize;
for x:=0 to 255 do Pallete[x]:=random($FFFFFF);

Pallete[0]:=0;
Pallete[1]:=$FFFFFF;
Pallete[6]:=$CCCCCC;


For x:=32 to 63 do
begin
    R:=Pallete[x] mod $FF00;
    G:=(Pallete[x] mod $FF0000) div $FF00;
    B:=Pallete[x] div $FF0000;
end;

end;

procedure TForm1.Button3Click(Sender: TObject);
begin
isaga := false;
readgfx(sender);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
   isaga := true;
readgfx(sender);
end;

end.
