unit Unit1obj;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Spin;

type

  Tbitplane = array[0..3] of byte;
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Image1: TImage;
    Label1: TLabel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    SpinEdit1: TSpinEdit;
    ListBox1: TListBox;
    Image2: TImage;
    Image3: TImage;
    Button5: TButton;
    Button6: TButton;
    OpenDialog1: TOpenDialog;
    Image4: TImage;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure loadbob(bobnr: integer);
    procedure FormCreate(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    function hextobin(b:byte):Tbitplane;
    function macht(b:byte):integer;
    procedure Button5Click(Sender: TObject);
    procedure Loadobj(Filename:string);
    procedure Savebitmap(Sender: TObject);
    procedure Image3MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    IFFSprites:array[0..999,0..127] of byte;
    Sprites:array[0..999,0..255] of byte;
    bob:integer;
    color:array[0..15] of Tcolor;
    colorfellow:array[0..15] of Tcolor;
    Silent:boolean;
    maxbob:integer;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
f:file ;
begin
     if opendialog1.execute then loadobj(Opendialog1.filename);

end;

procedure TForm1.Button2Click(Sender: TObject);
begin
if bob=0 then exit;
loadbob(bob-1);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
if bob=maxbob then exit;
loadbob(bob+1);
end;

procedure TForm1.Loadobj(Filename:string);
var
   i,j:integer;
   f:file;
   b1,b2,b3,b4,b5,b6:byte;
   spr:integer;
begin
     // clear sprites
     for i:=0 to 999 do
     for j:=0 to 255 do
     begin
          Sprites[i,j]:=0;
     end;

     assignfile(f,Filename);
     //assignfile(f,'C:\Emulation\Amiga\Directories\Harddisk\Games\EMeditor\obj');
     reset(f,1);

     Maxbob:=filesize(f) div 128;
     blockread(f,IFFsprites,maxbob * 128);
     closefile(f);
     bob:=0;

     for spr:=0 to maxbob do
     for i:=0 to 15 do
     begin
          for j:=0 to 3 do
          begin
          b1:=IFFSprites[spr,(i*2)+(j*32)];
          b2:=IFFSprites[spr,(i*2)++(j*32)+1];

          b3:=b1 div 16;
          b4:=b1 mod 16;
          b5:=b2 div 16;
          b6:=b2 mod 16;

          Sprites[spr,(i*16)+0]:=Sprites[spr,(i*16)+0]+(hextobin(b3)[0]*macht(j));
          Sprites[spr,(i*16)+1]:=Sprites[spr,(i*16)+1]+(hextobin(b3)[1]*macht(j));
          Sprites[spr,(i*16)+2]:=Sprites[spr,(i*16)+2]+(hextobin(b3)[2]*macht(j));
          Sprites[spr,(i*16)+3]:=Sprites[spr,(i*16)+3]+(hextobin(b3)[3]*macht(j));
          Sprites[spr,(i*16)+4]:=Sprites[spr,(i*16)+4]+(hextobin(b4)[0]*macht(j));
          Sprites[spr,(i*16)+5]:=Sprites[spr,(i*16)+5]+(hextobin(b4)[1]*macht(j));
          Sprites[spr,(i*16)+6]:=Sprites[spr,(i*16)+6]+(hextobin(b4)[2]*macht(j));
          Sprites[spr,(i*16)+7]:=Sprites[spr,(i*16)+7]+(hextobin(b4)[3]*macht(j));
          Sprites[spr,(i*16)+8]:=Sprites[spr,(i*16)+8]+(hextobin(b5)[0]*macht(j));
          Sprites[spr,(i*16)+9]:=Sprites[spr,(i*16)+9]+(hextobin(b5)[1]*macht(j));
          Sprites[spr,(i*16)+10]:=Sprites[spr,(i*16)+10]+(hextobin(b5)[2]*macht(j));
          Sprites[spr,(i*16)+11]:=Sprites[spr,(i*16)+11]+(hextobin(b5)[3]*macht(j));
          Sprites[spr,(i*16)+12]:=Sprites[spr,(i*16)+12]+(hextobin(b6)[0]*macht(j));
          Sprites[spr,(i*16)+13]:=Sprites[spr,(i*16)+13]+(hextobin(b6)[1]*macht(j));
          Sprites[spr,(i*16)+14]:=Sprites[spr,(i*16)+14]+(hextobin(b6)[2]*macht(j));
          Sprites[spr,(i*16)+15]:=Sprites[spr,(i*16)+15]+(hextobin(b6)[3]*macht(j));
          end;



     end;

end;

procedure TForm1.loadbob(bobnr: integer);
var
   i,j:integer;
   s:string;
   b1,b2:byte;
begin
     bob:=bobnr;
     if not silent then
     begin
          label1.caption:='Sprite: '+inttostr(bob)+ ' '+listbox1.items[bob];
          memo1.lines.clear;
          for i:=0 to 15 do
          begin
               S:='';
               for j:=0 to 7 do
               begin
                    S:=S+inttohex(IFFSprites[bob,(i*8)+j],2)+' ';
               end;
               memo1.lines.add(s);
          end;
     end;
     for i:=0 to 15 do
     for j:=0 to 15 do
     begin
          if (((bob>78) and (bob<112))or (bob>523)) then image1.canvas.pixels[j,i]:=colorfellow[Sprites[bob,(i*16)+j]]
          else image1.canvas.pixels[j,i]:=color[Sprites[bob,(i*16)+j]]

     end;
     if not silent then image2.canvas.copyrect(rect(0,0,64,64),image1.canvas,rect(0,0,16,16));

end;

procedure TForm1.FormCreate(Sender: TObject);
var
   i,j:integer;
   f:file;
   b1,b2,b3,b4,b5,b6:byte;
   spr:integer;
begin
     //for i:=0 to 15 do Color[i]:=random($ffffff);

     for i:=0 to 15 do Color[i]:=clwhite;

     color[0]:=0;
     Color[1]:=clwhite;
     Color[2]:=cllime; // licht groen
     Color[3]:=$00aa00;  // donker groen
     Color[4]:=clsilver;  // lichtste grijs
     Color[5]:=$0044CC;   // bruin
     Color[6]:=$44FFFF;   // geel
     Color[7]:=$00CCFF;   // oker
     Color[8]:=clgray; // of licht grijs ?
     Color[9]:= $008800; // d0nker groen
     Color[10]:=$666666; // donker grijs
     Color[11]:=$0000FF;
     Color[12]:=$0000CC;  // donkerrood
     Color[13]:=claqua;
     Color[14]:=clblue;
     Color[15]:=clnavy;

     colorfellow[0]:=0;
     Colorfellow[1]:=$DDDDDD;
     Colorfellow[2]:=$0000FF; // trui rood donker
     Colorfellow[3]:=$0000BF;  // trui rood donker
     Colorfellow[4]:=$DDDDDD;  // lichtste grijs
     Colorfellow[5]:=$0044CC;   // bruin
     Colorfellow[6]:=$FF8800;   // Broek blauw licht
     Colorfellow[7]:=$CF0000;   // Broek blauw donker
     Colorfellow[8]:=clgray; // of licht grijs ?
     Colorfellow[9]:= $008800; // d0nker groen
     Colorfellow[10]:=$FFFFFF; // trui wit
     Colorfellow[11]:=$00FFFF;
     Colorfellow[12]:=$0000CC;  // donkerrood
     Colorfellow[13]:=claqua;
     Colorfellow[14]:=clblue;
     Colorfellow[15]:=$50A0EF; // Huid

     if fileexists('c:\windows\desktop\obj') then loadobj('c:\windows\desktop\obj');


     loadbob(0);

end;

procedure TForm1.Button4Click(Sender: TObject);
begin
loadbob(spinEdit1.value);
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
begin
loadbob(listbox1.itemindex);
end;

function TForm1.hextobin(b:byte):Tbitplane;
begin

    if (b mod 2)=0 then result[3]:=0 else result[3]:=1;
    if (b mod 4)<2 then result[2]:=0 else result[2]:=1;
    if (b mod 8)<4 then result[1]:=0 else result[1]:=1;
    if (b mod 16)<8 then result[0]:=0 else result[0]:=1;

end;

function TForm1.macht(b:byte):integer;
begin
     case b of
     0:result:=1;
     1:result:=2;
     2:result:=4;
     3:result:=8;
     end;
end;

procedure TForm1.Button5Click(Sender: TObject);
var
   i,j,x,y:integer;
begin
     image3.canvas.brush.color:=clblack;
     image3.canvas.fillrect(rect(0,0,320,640));
     Silent:=true;
     for i:=0 to maxbob do
     begin
          y:=i div 20;
          x:=i mod 20;

          loadbob(i);
          image3.canvas.copyrect(rect(x*16,y*16,(X+1)*16,(y+1)*16),image1.canvas,rect(0,0,16,16));
     end;
     Silent:=false;
     image3.canvas.copyrect(rect(0,511,320,640),image4.canvas,rect(0,0,320,129));
end;

procedure TForm1.Savebitmap(Sender: TObject);
begin
image3.picture.savetofile('c:\windows\desktop\obj.bmp');
end;

procedure TForm1.Image3MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
SpinEdit1.value:=((Y div 16)*20)+(x div 16);
loadbob(spinEdit1.value);
end;

end.
