// Part of the DX-Boulder Contruction Kit
// By Stefan Verheyen

unit LevelFormats;

interface

uses Classes, SysUtils, Windows;

const
     Empty_Space_ID     = 0;
     Dirt_ID            = 1;
     Fellow_ID          = 2;
     Rock_ID            = 3;
     Emerald_ID         = 4;
     Bug_Left_ID        = 5;
     Steel_Wall_ID      = 6;
     Exit_Close_ID      = 7;
     Exit_Open_ID       = 8;
     Bomb_ID            = 9;
     Explosion_ID       = 10;
     Amoeba_ID          = 11;
     Nut_ID             = 12;
     Diamond_ID         = 13;
     Yam_ID             = 14;
     Grover_ID          = 15;
     Magic_Wall_ID      = 16;
     Stone_Wall1_ID     = 17;
     Magic_Wall_Rock_ID = 18;
     Terminal_ID        = 19;
     Pattern1_ID        = 20;
     Hidden_Exit_ID     = 30;
     Round_Stone_Wall_ID= 31;
     Stone_Wall2_ID     = 32;
     Slime_ID           = 42;
     Door_Green_cl_ID   = 52;
     Door_Blue_cl_ID    = 53;
     Door_Yellow_cl_ID  = 54;
     Door_Red_cl_ID     = 55;
     Door_Gray_Gr_Cl_ID = 56;
     Key_Green_ID       = 57;
     Key_Blue_ID        = 58;
     Key_Yellow_ID      = 59;
     Key_Red_ID         = 60;
     Robot_ID           = 61;
     Acid_ID            = 62;
     AcidBox_TL_ID      = 63;
     AcidBox_TR_ID      = 64;
     AcidBox_BL_ID      = 65;
     AcidBox_BR_ID      = 66;
     AcidBox_B_ID       = 67;
     Invisible_Wall_ID  = 68;
     Quicksand_Rock_ID  = 69;
     Ship_Left_ID       = 70;
     Dynamite_ID        = 71;
     Wheel_ID           = 72;
     Dynamite_Active_ID = 73;
     Amoeba_Drop_ID     = 74;
     Quicksand_ID       = 77;
     RockBirth_id       = 78;
     Door_Gray_Bl_Cl_ID = 79;
     Door_Gray_Ye_Cl_ID = 80;
     Door_Gray_Re_Cl_ID = 81;
     Bug_Up_ID          = 82;
     Bug_Right_ID       = 83;
     Bug_Down_ID        = 84;
     Ship_Up_ID         = 85;
     Ship_Right_ID      = 86;
     Ship_Down_ID       = 87;
     Yam_Left_ID        = 88;
     Yam_Up_ID          = 89;
     Yam_Right_ID       = 90;
     Yam_Down_ID        = 91;
     Utility_Disk_ID    = 92;
     Electron_Left_ID   = 93;
     Electron_Up_ID     = 94;
     Electron_Right_ID  = 95;
     Electron_Down_ID   = 96;
     Trap_Inactive_ID   = 97;
     Trap_active_ID     = 98;
     SupaBomb_ID        = 99;
     Door_Gray_KK_cl_ID = 146;
     Door_Gray_Pu_cl_ID = 147;
     Door_Gray_Br_cl_ID = 148;
     Door_Gray_Wh_cl_ID = 149;
     SnikSnak_Left_ID   = 150;
     SnikSnak_Up_ID     = 151;
     SnikSnak_Right_ID  = 152;
     SnikSnak_Down_ID   = 153;
     Exp_Wall_ID        = 154;
     Exp_Wall_Hor_ID    = 155;
     Exp_Wall_Ver_ID    = 156;
     Glue_ID            = 157;
     Teleport1_ID       = 158;
     Pearl_ID           = 170;
     Crystal_ID        = 171;
     Diamond_Wall_ID    = 172;
     Emerald_Wall_ID    = 173;
     Pearl_Wall_ID      = 174;
     Crystal_Wall_ID   = 175;
     Door_White_Close_ID= 176;
     Door_White_Open_ID = 177;
     Key_White_ID       = 179;
     Forcefield_ID      = 180;
     Extra_Time_ID      = 181;
     SwitchGate_Open_ID = 182;
     SwitchGate_Closed_ID=183;
     SwitchGate_Switch_ID=184;
     TimeGate_Closed_ID = 185;
     GateWheel_ID       = 186;
     Belt_Green_Left_ID = 187;
     Belt_Green_ID      = 188;
     Belt_Green_Right_ID= 189;
     Switch_Green_ID    = 190;
     Belt_Or_Left_ID    = 191;
     Belt_Or_ID         = 192;
     Belt_Or_Right_ID   = 193;
     Switch_Or_ID      = 194;
     C64Boulder_ID      = 195;
     C64Diamond_ID      = 196;
     LifeInABox_ID      = 197;
     LandMine_ID        = 199;
     Note_ID            = 200;
     Key_Purple_ID      = 212;
     Door_Pur_Close_ID  = 213;
     Door_Pur_Open_ID   = 214;
     Switch_Well_Id     = 215;
     Well_ID            = 216;
     Candy_Trick_ID     = 217;
     Door_Brown_Open_ID = 218;
     Door_Brown_Close_ID= 219;
     TimeGate_Open_ID  = 220;
     SpringBounce_ID    = 221;
     Door_KK_Open_ID    = 222;
     Door_KK_Close_ID   = 223;
     Stitch_ID          = 224;
     Steel_Slanted_ID   = 225;
     Invisible_Dirt_ID  = 226;
     Invisible_Steel_ID = 227;
     Hatch_ID           = 228;
     Firefly_Left_ID    = 229;
     Firefly_Up_ID      = 230;
     Firefly_Right_ID   = 231;
     Firefly_Down_ID    = 232;
     Butterfly_Left_ID  = 233;
     Butterfly_Up_ID    = 234;
     Butterfly_Right_ID = 235;
     Butterfly_Down_ID  = 236;
     Fellow2_ID         = 237;
     Pacman_Left_ID     = 238; 
     Pacman_Up_ID       = 239;
     Pacman_Right_ID    = 240;
     Pacman_Down_ID     = 241;
     Biomaze_ID         = 242;
     Balloon_ID         = 243;
     Wind_Cross_ID      = 244;
     Wind_Left_ID       = 245;
     Wind_Up_ID         = 246;
     Wind_Right_ID      = 247;
     Wind_Down_ID       = 248;
     Wind_Still_ID      = 249;
     Spring_ID          = 250;
     Glasses_ID         = 251;
     Key_KK_ID          = 252;
     Key_Brown_ID       = 253;
     Dirt2_ID           = 254;
     PoisonDirt_ID      = 255;
     Ice_ID             = 256;
     Icecube_ID         = 257;
     Icemonster_ID      = 258;
     Water_ID           = 259;
     IceHole_id         = 260;
     Floortile_blue     = 261;
     Snowblock_id       = 262;
     Snowball_ID        = 263;
     IceCave_ID         = 264;
     

     Static             =0;
     Left               =1;
     Up                 =2;
     Right              =3;
     Down               =4;







type

TrecFileID = record
           ID:Array[1..12]of char;
end;

TRecFileHdr = record
            ID:String[12];
            Seed:Longint;
            LevelMap:String[16];
            Level:Byte;
            Players:Byte;
            checksum:Longint;
end;

TBD4_V1_RecFileHdr = record
            ID:Array[1..12]of char;
            Seed:Longint;
            LevelMap:integer;
            Level:integer;
            Players:integer;
            checksum:Longint;
end;

TAnimHdr = record
             Version:byte;
             Empty:Byte;
             AnimCount:word;
             Description:array[1..10] of string[40];
             Author:string[10];
             UsableC64Boulder:boolean;
             UsableEM:boolean;
             UsableEMV7:boolean;
             UsableBoulderoid:boolean;
             UsableSupaplex:boolean;
             Usablernd:boolean;
             UsableDC:boolean;
             UsableDX:boolean;
             Date:string[12];
end;

TspriteAnimsection=record
              Frames:array[1..8] of word;
              Link:byte;
              Loopcount:byte;
              Speed:byte;
              unused:byte;
end;

TSpriteAnim = record
             Mainimage:word;
             Editorimage:word;
             Startframe:word;
             unused:word;
             Actions:array[0..7] of TspriteAnimsection;

end;


TLevelMapHdr = record
            ID:array[1..12]of char;
            Count:byte;
            Imglibversion:byte;
            Description:array[1..256]of char;
            Players:byte;
            Gametype:byte;
            Author:array[1..16]of char;
            expansion:array[1..110]of byte;
end;

TLevelHdrV0 = record
            Borderx:byte;
            Bordery:byte;
            Fellowx:byte;
            Fellowy:byte;
            DiamondsToCollect:byte;
            YamContent:array [1..8,1..3,1..3] of byte;
            LevelTime:byte;
            MagicWallTime:word;
            WheelTime:word;
            AmoebaRate:word;
            EmeraldScore:byte;
            DiamondScore:byte;
            RedGemScore:byte;
            DynamiteScore:byte;
            NutScore:byte;
            RobotScore:byte;
            ShipScore:byte;
            YamScore:byte;
            TimeScore:byte;
            Bugscore:byte;
            KeyScore:byte;
            LevelName:string[20];
            LevelAuthor:string[20];
            LevelEditPassword:string[10]; // encrypted offcourse
            PearlScore:Byte;
            ChrystalScore:Byte;
            empty:array[1..106] of byte;
end;

TLevelHdrV1 = record
            Borderx:byte;
            Bordery:byte;
            Fellowx:byte;
            Fellowy:byte;
            DiamondsToCollect:byte;
            YamContent:array [1..8,1..3,1..3] of byte;
            LevelTime:byte;
            MagicWallTime:word;
            WheelTime:word;
            AmoebaRate:word;
            EmeraldScore:byte;
            DiamondScore:byte;
            RedGemScore:byte;
            DynamiteScore:byte;
            NutScore:byte;
            RobotScore:byte;
            ShipScore:byte;
            YamScore:byte;
            TimeScore:byte;
            Bugscore:byte;
            KeyScore:byte;
            LevelName:string[20];
            LevelAuthor:string[20];
            LevelCreationDate:string[10]; // encrypted offcourse
            Description:string[100];
            Status:byte;
            PearlScore:Byte;
            ChrystalScore:Byte;
            GateWheelTime:byte;
            Hatchtime:byte;
            AmoebaSpread:byte;
            CheckAmoebapossible:bytebool;
            Amoebabrake:byte;
            SlimePermeability:byte;
            DiamondsToCollect2:byte;
            intermission:bytebool;
            PacmanScore:byte;
            Fellowx2:byte;
            Fellowy2:byte;
            Extratime:Byte;
            ForcefieldTime:Byte;
            WellContent:array [1..3,1..3] of byte;
            WellActiveStart:Boolean;
            empty:array[1..83] of byte;
end;

TLevelHdrV2 = record
            Borderx:byte;
            Bordery:byte;
            Fellowx:byte;
            Fellowy:byte;
            DiamondsToCollect:word;
            YamContent:array [1..8,1..3,1..3] of word;
            LevelTime:byte;
            MagicWallTime:word;
            WheelTime:word;
            AmoebaRate:word;
            EmeraldScore:byte;
            DiamondScore:byte;
            RedGemScore:byte;
            DynamiteScore:byte;
            NutScore:byte;
            RobotScore:byte;
            ShipScore:byte;
            YamScore:byte;
            TimeScore:byte;
            Bugscore:byte;
            KeyScore:byte;
            LevelName:string[20];
            LevelAuthor:string[20];
            LevelCreationDate:string[10];
            Description:string[100];
            Status:byte;
            PearlScore:Byte;
            ChrystalScore:Byte;
            GateWheelTime:byte;
            Hatchtime:byte;
            AmoebaSpread:byte;
            CheckAmoebapossible:bytebool;
            Amoebabrake:byte;
            SlimePermeability:byte;
            DiamondsToCollect2:byte;
            intermission:bytebool;
            PacmanScore:byte;
            Fellowx2:byte;
            Fellowy2:byte;
            Extratime:Byte;
            ForcefieldTime:Byte;
            WellContent:array [1..3,1..3] of word;
            WellActiveStart:Boolean;
            Backgroundlayer:Boolean;
            empty:array[1..99] of byte; // room for axpansion
end;



TBD4V1_Score = record
          EmeraldScore:byte;
          DiamondScore:byte;
          RobotScore:byte;
          ShipScore:byte;
          BugScore:byte;
          YamScore:byte;
          NutScore:byte;
          DynamiteScore:byte;
          KeyScore:byte;
          TimeScore:byte;
          Leveltime:byte;
          DiamondsToCollect:byte;
          Fellow1:word;
          Fellow2:word;
          GameSpeed:byte;
          AmoebaRate:byte;
          MagicWallTime:array[0..1]of byte;
          WheelTime:array[0..1]of byte;
end;

TEMV6_Score = record
          EmeraldScore:byte;
          DiamondScore:byte;
          RobotScore:byte;
          ShipScore:byte;
          BugScore:byte;
          YamScore:byte;
          NutScore:byte;
          DynamiteScore:byte;
          KeyScore:byte;
          TimeScore:byte;
          U1:byte;
          DiamondsToCollect:byte;
          Fellow1:word;
          Fellow2:word;
          GameSpeed:byte;
          AmoebaRate:byte;
          MagicWallTime:array[0..1]of byte;
          U5:word;
          U4:word;
          U3:word;
          Leveltime:Word;
          Extra:array[1..44] of byte;
          MagnifyglassTime:word;
          WellObject:word;
          WellDelay:word;
          WellActiveStart:byte; // ??? gokje
          WellDirection:byte;
          U8:byte;
          U9:byte;
          U10:byte;
          U11:byte;
          U12:byte;
          U13:byte;
          U14:byte;
          U15:byte;
end;

TBD4V1_Level = record
             LevelData:array[0..31,0..63]of byte;
             YamContent:array [1..4,1..3,1..3] of byte;
             Score:TBD4V1_Score ;
end;

TEMV6_Level = record
             LevelData:array[0..31,0..63]of byte;
             YamContent:array [1..4,1..3,1..3] of byte;
             Score:TEMV6_Score ;
end;

TSupa_Level = record
            LevelData:array[0..23,0..59]of byte;
            Empty1:array[1..4]of byte;
            Gravity:byte;
            Speedfix:byte; //not used
            Title:string[22];
            Freeze_Zonk_Start:byte; // ???   not used
            DiamondstoCollect:byte;
            gravityPorts:byte; // not used
            PortsCO:array[1..60]of byte ; // not used (yet)
            Empty2:array[1..4]of byte; // not used
end;

TFranz_Level=record
                   ID:array[1..6]of char;
                   Unknown1:array[1..4]of byte;
                   MagicWallTime:word; //swapped
                   AmoebaRate:byte;
                   U1:byte;
                   LevelTime:word; // byteswapped !!
                   Diamondstocollect:byte;
                   Unknown2:array[1..95] of byte;
                   LevelData:array[0..31,0..63]of byte;
                   YamContent:array [1..4,1..3,1..3] of byte;
                   Unknown3:array[1..108] of byte;
end;

TBDConstructionKit_Level=record
          Unknown1:word;
          Leveldata:array[1..440]of byte;
          Leveldelay:byte;
          Unused1:byte;
          LevelTime:byte;
          Unused2:byte;
          DiamondsNeeded:byte;
          Unused3:byte;
          DiamondScore:byte;
          Unused4:byte;
          BonusDiamondScore:byte;
          Unused5:byte;
          SlimePermeability:byte; // cfr quicksand ??
          Unused6:byte;
          AmoebaLifeTime:byte;
          Unused7:byte;
          MagicWallTime:byte;
          Unused8:byte;
          Unknown2:array[1..12] of byte;
          Color1:word;
          Color2:word;
          Color3:word;
          Color4:word;
          Color5:word;
          Unknown3:array[1..10] of byte;
end;
TBDConstructionKit_Level2=record
          Unknown1:array[1..4] of char;
          LevelName:array[1..11] of char;
          Unknown2:byte;
          Leveldata:array[1..440]of byte;
          Leveldelay:byte;
          Unused1:byte;
          LevelTime:byte;
          Unused2:byte;
          DiamondsNeeded:byte;
          Unused3:byte;
          DiamondScore:byte;
          Unused4:byte;
          BonusDiamondScore:byte;
          Unused5:byte;
          SlimePermeability:byte; // cfr quicksand ??
          Unused6:byte;
          AmoebaLifeTime:byte;
          Unused7:byte;
          MagicWallTime:byte;
          Unused8:byte;
          Unknown3:array[1..12] of byte;
          Color1:word;
          Color2:word;
          Color3:word;
          Color4:word;
          Color5:word;
         // Unknown3:array[1..2] of char;
end;

TAtariCavLevel = record
            Name:array[1..12] of char;
            Leveldata:array[1..220]of byte;
end;

THighScoreEntry = record
                Name: string[10];
                Date: TDateTime;
                Time:integer;
                Points: integer;
end;

TEncryptedHighScoreEntry = record
                Name: string[10];
                Date: TDateTime;
                Time:integer;
                Points: integer;
end;

TPLayerlist = record
            Name: string[10];
            Score:longint;
            Played:integer;
            Won:integer;
            Highest:byte;
end;
TBDC_out=record Bytes:array[1..2] of byte end;

TDC2LevelHdr = record
             DecryptOffset:word;
             Levelnumber:Word;
             Unknown:word;
             Levelwidth:Word;
             Levelheight:Word;
             OffsetX_Player1:word;
             OffsetY_Player1:word;
             OffsetX_Player2:word;
             OffsetY_Player2:word;
             Diamonds_to_Collect:word;
             Score_Emerald:word;
             Score_Diamond:word;
             Score_Pearl:word;
             Score_Chrystal:word;
             Score_Nut:word;
             Score_Robot:word;
             Score_Ship:word;
             Score_Bug:word;
             Score_Yam:word;
             Score_Dynamite:word;
             Score_Key:word;
             Score_Exittime:word;
             Time_Game:word;
             Time_Amoeba:word;
             Time_Light:word;
             Time_Wheel_Timegate :word;
             Time_Wheel:word;
             Time_MagicWall:word;
             Time_Extratime:word;
             Time_ForceField:word;
             Eaters:word;
             Size_NoteHeadLine:byte;
             NoteHeadline:array[1..31]of char;
             Size_NoteBody:byte;
             NoteBody:array[1..156]of char;
             Size_Title:byte;
             Title:array[1..40]of char;
             Size_Author:byte;
             Author:array[1..31]of char;
             Size_Password:byte;
             Password:array[1..19]of char;
end;

TRushGameHeader = record
                Name:array[1..34]of char;
                ID: array[1..8]of char;
                X1:word;  // 00004 ???
                Width:word;
                Height:word;
                X4:word;
                X5:Word;  // slimepermeability ?????????   // magic time ?????
                slimepermeability:Word;  //?????????????????
                Amoebalifetime:Word;  // X6: 006A kan ook magic time zijn: dan is X6: 006E
                LevelTime:Word;
                X8:Word;
                X9:Word;
                DiamondsToCollect:Word;
                X10:Word;
                diamondScore:Word;
                scores:array[1..54]of byte;
                AmigaBDspecs:array[1..136]of char;
                colors:array[1..34]of char;
end;

TRocksnDiamondsHeader = record
                      width:byte;
                      height:byte;
                      Leveltime:word; // non swapped
                      DiamondsToCollect:word; // non swapped
                      Name:array[1..30]of char;
                      x1:byte;
                      X2:byte;
                      Emeraldscore:byte;
                      Diamondscore:byte;
                      Bugscore:byte;
                      Shipscore:byte;
                      YamScore:byte;
                      RobotScore:byte;
                      Pacmanscore:byte;
                      NutScore:byte;
                      Dynamitescore:byte;
                      KeyScore:byte;
                      Timescore:byte;
                      x4:byte;
                      x5:byte;
                      x6:byte;
                      x7:byte;
                      x8:byte;
                      yamcontent:array[1..4,1..3,1..3] of byte;
                      Amoebarate:byte;
                      MagicWallTime:byte;
                      WheelTime:byte;
                      Amoebacontent:byte;
                      x13:array[1..18]of byte; //unused (zeker)
end;


// Function Prototypes
//====================
function Bd4V2toStef(ObjectCode: array of char):byte;
function Boulderoid_To_Stef(ObjectCode:char):byte;
function FranztoStef(ObjectCode:integer):integer;
function BDConstructionKitToStef(ObjectCode:integer):TBDC_out;
function DC2_to_Stef(Objectcode:word):byte;
function Rush_To_Stef(ObjectCode:byte):byte;
function Das_To_Stef(ObjectCode:String):integer;
function Rocksndiamonds_to_Stef(ObjectCode:byte):byte;
function EM_to_Stef(Objectcode:byte):integer;
function MaplevelhdrV1toV2(hdr: TlevelhdrV1): TlevelhdrV2;

function Stef_to_BDCFF(Objectcode:byte):string;


{ IntPower: Raise base to an integral power.  Fast. }
function IntPower(Base: Extended; Exponent: Integer): Extended register;


implementation

//function implementation
//=======================


function IntPower(Base: Extended; Exponent: Integer): Extended;
asm
        mov     ecx, eax
        cdq
        fld1                      { Result := 1 }
        xor     eax, edx
        sub     eax, edx          { eax := Abs(Exponent) }
        jz      @@3
        fld     Base
        jmp     @@2
@@1:    fmul    ST, ST            { X := Base * Base }
@@2:    shr     eax,1
        jnc     @@1
        fmul    ST(1),ST          { Result := Result * X }
        jnz     @@1
        fstp    st                { pop X from FPU stack }
        cmp     ecx, 0
        jge     @@3
        fld1
        fdivrp                    { Result := 1 / Result }
@@3:
        fwait
end;


function Bd4V2toStef(ObjectCode: array of char):byte;
begin

if ObjectCode='WW' then result:=6; // muur
if ObjectCode='..' then result:=1; // Opvulsel
if ObjectCode='.o' then Result:=3; // Rock
if ObjectCode='.O' then Result:=9; // Bom
if ObjectCode='.a' then Result:=61; // Robot
if ObjectCode='bu' then Result:=5; // monster  (Bug nose up)
if ObjectCode='br' then Result:=5; // monster (bug nose right)
if ObjectCode='bl' then Result:=5; // monster (bug nose left)
if ObjectCode='bd' then Result:=5; // monster (bug nose down)
if ObjectCode='Wi' then Result:=68; // Onzichtbare muur
if ObjectCode='$3'then Result:=13; // emerald
if ObjectCode='yu' then Result:=14; // Yam Yam
if ObjectCode='yd' then Result:=14; // Yam Yam
if ObjectCode='yr' then Result:=14; // Yam Yam
if ObjectCode='yl' then Result:=14; // Yam Yam
if  ObjectCode='ee' then Result:=7; // Exit Close
if ObjectCode='ef' then Result:=8; // Exit Open
if ObjectCode='e1' then Result:=8; // Exit Open
if ObjectCode='e2' then Result:=8; // Exit Open
if ObjectCode='e3' then Result:=8; // Exit Open
if ObjectCode='ru' then Result:=70 ;// Ship nose up
if ObjectCode='rr' then Result:=70 ;// Ship nose right
if ObjectCode='rd' then Result:=70 ;// Ship nose down
if ObjectCode='rl' then Result:=70 ;// Ship nose left
if ObjectCode='Wb' then Result:=16; // Magic Wall
if ObjectCode='.w' then Result:=72; // Weel
if ObjectCode='.n' then Result:=12; // Noot
if ObjectCode='""' then Result:=0; // Leeg
//if b>=200 then Result:=8; // zijn letters

if ObjectCode='Ww' then Result:=17; // Brokkelmuur
// laatste 2 blokjes van elke level zijn telkens 116  Waar0m ??  termination Character
//if b=116 then Result:=6; // Wall

if  ObjectCode='$1' then  Result:=4 ; //Diamant (Infotron)


if ObjectCode='fr'then Result:=69; // Drijfzand met steen erin


if ObjectCode='ko' then Result:=60; // Key Red
if ObjectCode='ky' then Result:=59; // Key Yellow
if ObjectCode='kb' then Result:=58; // Key Blue
if ObjectCode='kg' then Result:=57; // Key Green

if ObjectCode='Do' then Result:=55; // Door Red Closed
if ObjectCode='Dy' then Result:=54; // Door Yellow Closed
if ObjectCode='Db' then Result:=53; // Door blue Closed
if ObjectCode='Dg' then Result:=52; // Door Green Closed
if ObjectCode='do' then Result:=56; // Door Gray Closed

//if b=145 then Result:=51; // Door Gray Open ???
//if b=143 then Result:=56; // Door Gray always Closed ????
//if b=144 then Result:=56; // Door Gray always Closed ????
if ObjectCode='s1' then Result:=11; // Amoeba
if ObjectCode='s2' then Result:=11; // Amoeba
if ObjectCode='s3' then Result:=11; // Amoeba
if ObjectCode='s4' then Result:=11; // Amoeba

//if b=123 then Result:=62; // Acid
//if b=149 then Result:=63; // AcidBox TopLeft
//if b=150 then Result:=64; // AcidBox TopRight
//if b=151 then Result:=65; // AcidBox BottomLeft
//if b=152 then Result:=66; // AcidBox BottomRight
//if b=63 then Result:=67; // AcidBox Bottom

if  ObjectCode='g1' then Result:=73; // Dynamite active
if  ObjectCode='g2' then Result:=73; // Dynamite active
if  ObjectCode='g3' then Result:=73; // Dynamite active
if  ObjectCode='g4' then Result:=73; // Dynamite active

if ObjectCode='gg' then Result:=71; // Dynamiet
//if b=148 then Result:=69; // Quicksand
//if b=129 then Result:=31; // Slanted Wall

if ObjectCode='sd' then Result:=74; // Amoeba Drop
//if b=156 then Result:=75; // Amoeba Stationary  ??
//if b=155 then Result:=75; // Amoeba Stationary  ??
//if b=153 then Result:=76; // Fixed Acid

end;

function EM_to_Stef(Objectcode:byte):integer;
begin
     result:=-1;
     if Objectcode=0 then result:=3; // Rock
     if Objectcode=2 then result:=13; // emerald
     if Objectcode=3 then result:=13; // emerald (in ace mine 01)
     if Objectcode=4 then result:=61; // Robot
     if Objectcode=5 then result:=61; // Robot
     if Objectcode=8 then result:=85 ;// Ship nose up
     if Objectcode=9 then result:=86 ;// Ship nose right
     if Objectcode=10 then result:=87 ;// Ship nose down
     if Objectcode=11 then result:=70 ;// Ship nose left
     if Objectcode=12 then result:=Ship_Up_ID ;// Ship nose up about to move
     if Objectcode=13 then result:=Ship_Right_ID;
     if Objectcode=14 then result:=Ship_Down_ID;
     if Objectcode=15 then result:=Ship_Left_ID;
     if Objectcode=16 then result:=9; // Bom
     if Objectcode=18 then result:=4 ; //Diamant (Infotron)
     if Objectcode=19 then result:=4 ; //Diamant // in acemine 01
     if Objectcode=20 then result:=82; // monster (bug nose Up)
     if Objectcode=21 then result:=83; // monster (bug nose right)
     if Objectcode=22 then result:=84; // monster (bug nose Down)
     if Objectcode=23 then result:=5; // monster (bug nose left)
     if Objectcode=24 then result:=Bug_Up_ID;
     if Objectcode=25 then result:=Bug_Right_ID;
     if Objectcode=26 then result:=Bug_Down_ID;
     if Objectcode=27 then result:=Bug_Left_ID;
     if Objectcode=28 then result:=74; // Amoeba Drop
     if Objectcode=32 then result:=3; // Rock ( in Acemine 01)
     if Objectcode=36 then result:=-16; // eigenlijk Magic Wall Active
     if Objectcode=37 then result:=12; // monster
     if Objectcode=40 then result:=-72; // eigenlijk wheel active ......  moet nog gefixt worden.
     if Objectcode=41 then result:=Yam_Up_ID;
     if Objectcode=42 then result:=Yam_Down_ID;
     if Objectcode=43 then result:=Yam_Left_ID;
     if Objectcode=44 then result:=Yam_Right_ID;
     if Objectcode=45 then result:=69; //Drijfzand met steen erin
     if Objectcode=57 then result:=Exp_Wall_Hor_ID;
     if Objectcode=58 then result:=Exp_Wall_Ver_ID;
     if Objectcode=59 then result:=73; // Dynamite active
     if Objectcode=60 then result:=73; // Dynamite active
     if Objectcode=61 then result:=73; // Dynamite active (tickk ?) (Crystal Cavern 1 level 5)
     if Objectcode=62 then result:=73;  // Dynamite active last tick
     if Objectcode=63 then result:=67; // AcidBox Bottom
     if Objectcode=64 then result:=8; // Exit open
     if Objectcode=65 then result:=8; // Exit open <> frame
     if Objectcode=66 then result:=8; // Exit open <> frame
     if Objectcode=67 then result:=Balloon_ID;
     if Objectcode=68 then result:=PoisonDirt_ID;
     if Objectcode=69 then result:=Spring_ID;
     if Objectcode=73 then result:=Well_ID;
     if Objectcode=75 then result:=Stitch_ID;
     if Objectcode=78 then result:=68; // Onzichtbare muur
     if Objectcode=101 then result:=Acid_ID ;
     if Objectcode=114 then result:=0; // Dynamite Collect (Should this increase DynamiteCollected ??)
     if Objectcode=114 then result:=-114;  // nut move left
     if Objectcode=115 then result:=-115;  // nut move right
     if Objectcode=116 then result:=6; // Wall
     if Objectcode=117 then result:=10; // explosion : internal tile - should not be used
     if Objectcode=118 then result:=0; // same story as 123: disappearing Diamond
     if Objectcode=119 then result:=-119;  // bomb move left
     if Objectcode=120 then result:=-120;  // bomb move right
     if Objectcode=121 then result:=-121;  // Rock move left
     if Objectcode=122 then result:=-122;  // Rock move right
     if Objectcode=123 then result:=0; // ????
        // if Objectcode=123 then result:=62; // Acid
        // 123:
        // In bd4 is dit acid
        // in Crystal Cavern is dit een disappearing Emerald
        // ---> turn to zero, acid will be filled in later
     if Objectcode=124 then result:=0; // Dirt Collect Left
     if Objectcode=125 then result:=0; // Dirt Collect Right
     if Objectcode=126 then result:=0; // Dirt Collect Up
     if Objectcode=127 then result:=0; // Dirt Collect Down
     if Objectcode=128 then result:=0; // Leeg
     if Objectcode=129 then result:=31; // Slanted Wall
     if Objectcode=130 then result:=1; // Opvulsel
     if Objectcode=131 then result:=6; // muur
     if Objectcode=132 then result:=17; // Brokkelmuur
     if Objectcode=133 then result:=60; // Key Red
     if Objectcode=134 then result:=59; // Key Yellow
     if Objectcode=135 then result:=58; // Key Blue
     if Objectcode=136 then result:=57; // Key Green
     if Objectcode=137 then result:=55; // Door Red Closed
     if Objectcode=138 then result:=54; // Door Yellow Closed
     if Objectcode=139 then result:=53; // Door blue Closed
     if Objectcode=140 then result:=52; // Door Green Closed
     if Objectcode=141 then result:=Invisible_Wall_ID; // in Crystal Cavern 2
     if Objectcode=142 then result:=81; // Door Gray Red Closed
     if Objectcode=143 then result:=80; // Door Gray Yellow Closed
     if Objectcode=144 then result:=79; // Door Gray Blue Clodes
     if Objectcode=145 then result:=56; // Door Gray Green Closed
     if Objectcode=146 then result:=16; // Magic Wall
     if Objectcode=147 then result:=72; // Wheel
     if Objectcode=148 then result:=77; // Quicksand
     if Objectcode=149 then result:=63; // AcidBox TopLeft
     if Objectcode=150 then result:=64; // AcidBox TopRight
     if Objectcode=151 then result:=65; // AcidBox BottomLeft
     if Objectcode=152 then result:=66; // AcidBox BottomRight
     if Objectcode=153 then result:=Invisible_Wall_ID; // of fixed acid ?
     if Objectcode=154 then result:=11; // Amoeba
     if Objectcode=155 then result:=75; // Amoeba Stationary  ??
     if Objectcode=156 then result:=75; // Amoeba Stationary  ??
     if Objectcode=157 then result:=75; // Amoeba Stationary  ??
     if Objectcode=158 then result:=7; // Exit Close
     if Objectcode=159 then result:=141; // Arrow left
     if Objectcode=160 then result:=33 ; // crumble_Wall 4  Impassable dirt
     if Objectcode=161 then result:=Glasses_ID ;
     if Objectcode=162 then result:=Candy_Trick_ID ;
     if Objectcode=165 then result:=Switch_Well_Id ;
     if Objectcode=168 then result:=24 ; // Pattern 5 looks like green tube ver: Stop Top
     if Objectcode=169 then result:=24 ; // Pattern 5 looks like green tube ver
     if Objectcode=170 then result:=24 ; // Pattern 5 looks like green tube ver: Stop bottom
     if Objectcode=173 then result:=136; // Point, moet eigenlijk aanhalingsteken zijn
     if Objectcode=174 then result:=136; // Point, moet eigenlijk streepje zijn
     if Objectcode=175 then result:=71; // Dynamiet
     if Objectcode=176 then result:=21; // pattern 2
     if Objectcode=177 then result:=28 ; // Wall 9
     if Objectcode=178 then result:=29 ; // Wall 10
     if Objectcode=179 then result:=20; // pattern 1  // indestructable wall moet dat zijn
     if Objectcode=180 then result:=Round_Stone_Wall_ID;
     if Objectcode=181 then result:=34 ; // crumble_Wall 5  looks like rooster
     if Objectcode=182 then result:=34 ; // crumble_Wall 5  looks like white fuse (eigenlijk)
     if Objectcode=184 then result:=Wind_Cross_ID ;
     if Objectcode=185 then result:=Wind_Right_ID ;
     if Objectcode=186 then result:=Wind_Down_ID ;
     if Objectcode=187 then result:=Wind_Left_ID ;
     if Objectcode=188 then result:=Wind_Up_ID ;
     if Objectcode=189 then result:=Dirt2_ID ;
     if Objectcode=191 then result:=Key_KK_ID ;
     if Objectcode=192 then result:=Key_Purple_ID ;
     if Objectcode=193 then result:=Key_Brown_ID ;
     if Objectcode=194 then result:=Key_White_ID ;
     if Objectcode=195 then result:=Door_KK_Close_ID ; // door gray (green) : alle grijze deuren gaan open met de grijze sleutel ???
     if Objectcode=196 then result:=Door_Pur_Close_ID ;
     if Objectcode=197 then result:=Door_Brown_Close_ID ;
     if Objectcode=198 then result:=Door_White_Close_ID ;
     if Objectcode=199 then result:=SpringBounce_ID ;
     if (Objectcode>=200) and (Objectcode<236) then result:=Objectcode-100; // zijn letters
     if Objectcode=236 then result:=136; // Exclamation point
     if Objectcode=237 then result:=139; // Exclamation point
     if Objectcode=238 then result:=136; // Point, moet eigenlijk dubbelpunt zijn
     if Objectcode=239 then result:=138; // Question Mark
     if Objectcode=240 then result:=143; // Arrow Right
     if Objectcode=241 then result:=31;
        //if Objectcode=241 then result:=145; // Copy right   (in BD4)
        // in Crystal cavern 2: 241 is Crumble wall pattern
     if Objectcode=242 then result:=Door_Gray_KK_cl_ID ;
     if Objectcode=243 then result:=Door_Gray_Pu_cl_ID ;
     if Objectcode=244 then result:=Door_Gray_Br_cl_ID ;
     if Objectcode=245 then result:=Door_Gray_Wh_cl_ID ;

     if result=-1 then result:=grover_ID;
end;

function Boulderoid_To_Stef(ObjectCode:char):byte;
begin
     result:=0;
     if Objectcode='W' then result:=6;
     if Objectcode=' ' then result:=0;
     if Objectcode='.' then result:=1;
     if Objectcode='r' then result:=3;
     if Objectcode='d' then result:=4;
     if Objectcode='r' then result:=3;
     if Objectcode='w' then result:=17;
     if Objectcode='m' then result:=16;
     if Objectcode='x' then result:=155;  // expanding wall hor
     if Objectcode='v' then result:=156;  // expanding wall ver
     if Objectcode='V' then result:=154;  // expanding wall cross
     if Objectcode='r' then result:=3;
     if Objectcode='P' then result:=2;
     if Objectcode='X' then result:=7;
     if Objectcode='H' then result:=Hidden_Exit_ID; // hidden exit
     if Objectcode='a' then result:=11;
     if Objectcode='s' then result:=Slime_ID; // slime
     if Objectcode='b' then result:=82; // bug left ?
     if Objectcode='B' then result:=83;
     if Objectcode='c' then result:=84;
     if Objectcode='C' then result:=5;
     if Objectcode='o' then result:=85;
     if Objectcode='O' then result:=86;
     if Objectcode='q' then result:=87;
     if Objectcode='Q' then result:=70;
     if Objectcode='L' then result:=6;
     if Objectcode='T' then result:=9; // not correct
     if Objectcode='t' then result:=71; // fuse  ????
     if Objectcode='G' then result:=157; // glue
     if Objectcode='A' then result:=62;
     if Objectcode='f' then result:=15; // mad rockford
     if Objectcode='F' then result:=15; // stupid rockford
     if Objectcode='0' then result:=48; //  teleports
     if Objectcode='1' then result:=48;
     if Objectcode='2' then result:=48;
     if Objectcode='3' then result:=48;
     if Objectcode='4' then result:=48;
     if Objectcode='5' then result:=48;
     if Objectcode='6' then result:=48;
     if Objectcode='7' then result:=48;
     if Objectcode='8' then result:=48;
     if Objectcode='9' then result:=48;

end;

function FranztoStef(ObjectCode:integer):integer;
begin
     result:=-1;
     if ObjectCode=2   then result:=6;
     if ObjectCode=1   then result:=1;
     if ObjectCode=100 then result:=3;
     if ObjectCode=4   then result:=17;
     if ObjectCode=208 then result:=14;
     if ObjectCode=0   then result:=0;
     if ObjectCode=34  then result:=56;
     if ObjectCode=35  then result:=79;
     if ObjectCode=36  then result:=80;
     if ObjectCode=37  then result:=81;
     if ObjectCode=33  then result:=Door_Red_cl_ID;
     if ObjectCode=32  then result:=54;
     if ObjectCode=31  then result:=53;
     if ObjectCode=30  then result:=52;
     if ObjectCode=11  then result:=7;
     if ObjectCode=3   then result:=2;
     if ObjectCode=101 then result:=4;
     if ObjectCode=29  then result:=60;
     if ObjectCode=28  then result:=59;
     if ObjectCode=27  then result:=58;
     if ObjectCode=26  then result:=57;
     if ObjectCode=102 then result:=Diamond_ID;
     if ObjectCode=103 then result:=Bomb_ID;
     if ObjectCode=104 then result:=Nut_ID;
     if ObjectCode=105 then result:=Dynamite_ID;
     if ObjectCode=204 then result:=Bug_Down_ID;
     if ObjectCode=205 then result:=Bug_left_ID;
     if ObjectCode=206 then result:=Bug_Up_ID;
     if ObjectCode=207 then result:=Bug_right_ID;
     if ObjectCode=212 then result:=Robot_ID;
     if ObjectCode=10  then result:=Amoeba_ID;
     if ObjectCode=9   then result:=Amoeba_ID;
     if ObjectCode=21  then result:=63;
     if ObjectCode=22  then result:=64;
     if ObjectCode=23  then result:=65;
     if ObjectCode=24  then result:=67;
     if ObjectCode=25  then result:=66;
     if ObjectCode=20  then result:=Acid_ID;
     if ObjectCode=5   then result:=31;
     if ObjectCode=200 then result:=Ship_down_ID;
     if ObjectCode=201 then result:=Ship_Left_ID;
     if ObjectCode=202 then result:=Ship_Up_ID;
     if ObjectCode=203 then result:=Ship_Right_ID;
     if ObjectCode=8   then result:=Magic_Wall_ID;
     if ObjectCode=6   then result:=Quicksand_ID;
     if ObjectCode=7   then result:=Quicksand_Rock_ID;
     if ObjectCode=13  then result:=Wheel_ID;
     if ObjectCode=14  then result:=Invisible_Wall_ID;
     if ObjectCode=150 then result:=Amoeba_drop_ID;
     if ObjectCode=106 then result:=Dynamite_Active_ID;
     // letters
     if (ObjectCode>=49) and (ObjectCode<=85) then result:=Objectcode+50;
     if ObjectCode=89  then result:=139; // '!'
end;

function DC2_to_Stef(Objectcode:word):byte;
begin
     result:=0;
     if objectcode=0000 then result:=Rock_ID;
     if objectcode=5779 then result:=Steel_Wall_ID;
     if objectcode=5543 then result:=Stone_Wall1_ID;
     if objectcode=4025 then result:=Magic_Wall_ID;
     if objectcode=3811 then result:=Exit_Close_ID;
     if objectcode=3836 then result:=Exit_Close_ID;//steel
     if objectcode=1868 then result:=Bomb_ID;
     if objectcode=5536 then result:=Dynamite_ID;
     if objectcode=1777 then result:=Nut_ID;
     if (objectcode>=5500) and (objectcode<=5515)then result:=Dirt_ID;
     if (objectcode>=873) and (objectcode<=1668)then result:=Emerald_ID;
     if (objectcode>=279) and (objectcode<=872)then result:=Diamond_ID;
     if objectcode=2083 then result:=Crystal_ID;
     if objectcode=1956 then result:=Pearl_ID;
     if (objectcode>=5782) and (objectcode<=5793)then result:=20; // construction walls
     if objectcode=4544 then result:=Robot_ID;
     if objectcode=5109 then result:=Yam_Up_ID;
     if objectcode=5772 then result:=Wheel_ID;
     if (objectcode>=3969) and (objectcode<=3973) then result:=Amoeba_ID;
     if objectcode=3973 then result:=Amoeba_drop_ID;
     if objectcode=4183 then result:=Bug_Up_ID;
     if objectcode=4224 then result:=Bug_Right_ID;
     if objectcode=4192 then result:=Bug_Down_ID;
     if objectcode=4216 then result:=Bug_Left_ID;
     if objectcode=4048 then result:=Ship_Up_ID;
     if objectcode=4089 then result:=Ship_Right_ID;
     if objectcode=4057 then result:=Ship_Down_ID;
     if objectcode=4081 then result:=Ship_Left_ID;
     //if objectcode=4318 then result:=Mole_Up_ID;
     if (objectcode>=5820) and (objectcode<=5828) then result:=Invisible_Dirt_ID;

     if objectcode=5537 then result:=60;
     if objectcode=5538 then result:=59;
     if objectcode=5539 then result:=58;
     if objectcode=5540 then result:=57;
     if objectcode=5541 then result:=179;//key white
     if objectcode=5761 then result:=55;
     if objectcode=5762 then result:=81;
     if objectcode=5763 then result:=54;
     if objectcode=5764 then result:=80;
     if objectcode=5765 then result:=53;
     if objectcode=5766 then result:=79;
     if objectcode=5767 then result:=52;
     if objectcode=5768 then result:=56;
     if objectcode=5769 then result:=176;// door white
     if (objectcode>=5545) and (objectcode<=5570) then result:=objectcode-5445; // alphabet
     if (objectcode>=5599) and (objectcode<=5624) then result:=objectcode-5499;
     if (objectcode>=5653) and (objectcode<=5678) then result:=objectcode-5553;
     if (objectcode>=5628) and (objectcode<=5638) then result:=objectcode-5502;
     if objectcode=5584 then result:=136; //point
     if objectcode=5590 then result:=145; //copyright
     if objectcode=5585 then result:=139; // !
     if objectcode=5587 then result:=141; //<-
     if objectcode=5588 then result:=143; //->
     if objectcode=5592 then result:=144; // arrow down
     if objectcode=5589 then result:=138; //?
     if objectcode=5695 then result:=141; //<- (Steel)

     if (objectcode>=5803) and (objectcode<=5813) then result:=Steel_Wall_ID;//sign
     if (objectcode>=5796) and (objectcode<=5802) then result:=Steel_Wall_ID;// pattern
     if objectcode=5781 then result:=Steel_Wall_ID; // steel wall not round
     if objectcode=5683 then result:=139; //??
     if objectcode=5292 then result:=Exp_Wall_Hor_ID;
     if objectcode=5309 then result:=Exp_Wall_Ver_ID;
     if objectcode=5318 then result:=Exp_Wall_ID;
   // if objectcode=5818 then result:=Invisible_StoneWall_ID;
     if objectcode=5818 then result:=Invisible_Wall_ID;
     if objectcode=5819 then result:=Invisible_Steel_ID;
     if objectcode=5496 then result:=Quicksand_ID;
     if objectcode=3703 then result:=Quicksand_Rock_ID;
     if objectcode=5837 then result:=note_ID;
     if objectcode=5542 then result:=Round_Stone_Wall_ID;
     if objectcode=5814 then result:=Diamond_Wall_ID;
     if objectcode=5815 then result:=Emerald_Wall_ID;
     if objectcode=5816 then result:=Pearl_Wall_ID;
     if objectcode=5817 then result:=Crystal_Wall_ID;
     if objectcode=5353 then result:=Forcefield_ID;
     if objectcode=5377 then result:=Extra_Time_ID;
     if objectcode=5775 then result:=AcidBox_TL_ID;
     if objectcode=5776 then result:=AcidBox_TR_ID;
     if objectcode=5777 then result:=AcidBox_BL_ID;
     if objectcode=5778 then result:=AcidBox_BR_ID;
     if objectcode=5774 then result:=AcidBox_B_ID;
     if objectcode=5455 then result:=Acid_ID;
     if objectcode=5196 then result:=Switch_Or_ID;
     if objectcode=5219 then result:=Belt_Or_Left_ID;
     if objectcode=5211 then result:=Belt_Or_ID;
     if objectcode=5227 then result:=Belt_Or_Right_ID;
     if objectcode=5157 then result:=SwitchGate_Open_ID;
     if objectcode=5158 then result:=SwitchGate_Closed_ID;
     if objectcode=5175 then result:=SwitchGate_Switch_ID;
     if objectcode=3794 then result:=Exit_Open_ID;
     if objectcode=3819 then result:=Exit_Open_ID; // steel
     if objectcode=5780 then result:=Steel_Slanted_ID;
     if (objectcode>=5526) and (objectcode<=5535) then result:=Landmine_ID;
     if objectcode=5544 then result:=Stone_Wall1_ID; // not round

end;

function BDConstructionKitToStef(ObjectCode:integer):TBDC_out;
var
bit4object:array[1..2] of byte;
i:integer;
begin
{0 Boulder
1 Diamond
2 Magic wall
3 Brick wall
4 Steel wall
5 Expanding wall
6 Rockford
7 Dirt
8 Firefly
9 Butterfly
A Amoeba
B Slime
C Hidden out
D Visible out
E In
F Space
}
     bit4object[1]:=(objectcode div 16);
     bit4object[2]:=(objectcode mod 16);
     for i:=1 to 2 do
     begin
          if bit4object[i]=0 then result.bytes[i]:=C64Boulder_ID;
          if bit4object[i]=1 then result.bytes[i]:=C64Diamond_ID;
          if bit4object[i]=2 then result.bytes[i]:=Magic_Wall_ID;
          if bit4object[i]=3 then result.bytes[i]:=Stone_Wall1_ID;
          if bit4object[i]=4 then result.bytes[i]:=Steel_Wall_ID;
          if bit4object[i]=5 then result.bytes[i]:=155; //(expanding wall)
          if bit4object[i]=6 then result.bytes[i]:=LifeInABox_ID;
          if bit4object[i]=7 then result.bytes[i]:=Dirt_ID;
          if bit4object[i]=8 then result.bytes[i]:=Firefly_Left_ID;
          if bit4object[i]=9 then result.bytes[i]:=Butterfly_Left_ID;
          if bit4object[i]=10 then result.bytes[i]:=Amoeba_ID;
          if bit4object[i]=11 then result.bytes[i]:=Slime_ID; // slime
          if bit4object[i]=12 then result.bytes[i]:=Hidden_Exit_ID; // is actually hidden out
          if bit4object[i]=13 then result.bytes[i]:=Hidden_Exit_ID;
          if bit4object[i]=14 then result.bytes[i]:=2;
          if bit4object[i]=15 then result.bytes[i]:=Empty_Space_ID;
     end;       
end;


function Rush_To_Stef(ObjectCode:byte):byte;
begin
     case objectcode of
     0: result:=0;
     1: result:=Dirt_ID;
     2: result:=C64Boulder_ID;
     3: result:=Slime_ID;
     4: result:=Steel_Wall_ID;
     5: result:=Stone_Wall1_ID;
     6: result:=exp_Wall_Hor_ID;
     10: result:=Stone_Wall1_ID;
     56: result:=Quicksand_ID;
     128: result:=C64Diamond_ID;
     130: result:=Amoeba_ID;
     131: result:=Slime_ID;
     133: result:=Magic_Wall_ID;
     134: result:=2;
     135: result:=Hidden_Exit_ID;
     137: result:=Slime_ID;
     178: result:=Butterfly_Left_ID;
     224: result:=Butterfly_Up_ID;
     225: result:=Butterfly_Left_ID;
     226: result:=Butterfly_Right_ID;
     227: result:=Firefly_Up_ID;
     228: result:=Firefly_Left_ID;
     229: result:=Firefly_Right_ID;
     255: result:=Slime_ID;
     else
         result:=Grover_ID;
     end;
end;

function Das_To_Stef(ObjectCode:String):integer;
var
   i,code:integer;
begin
     result:=Grover_ID;
     if Objectcode='0' then result:=Empty_Space_ID;
     if Objectcode='1' then result:=Dirt_ID;
     if Objectcode='2' then result:=Stone_Wall1_ID;
     if Objectcode='3' then result:=Magic_Wall_ID;
     if Objectcode='4' then result:=Exit_Close_ID;
     if Objectcode='5' then result:=Exit_open_ID;
     if Objectcode='6' then result:=Hidden_Exit_ID;
     if Objectcode='7' then result:=Exit_open_ID;
     if Objectcode='8' then result:=Firefly_Up_ID;
     if Objectcode='9' then result:=Firefly_Down_ID;
     //if Objectcode='10' then result:=Firefly_Left_ID;
     if Objectcode='11' then result:=Firefly_Right_ID;
     // delay
     if Objectcode='12' then result:=Butterfly_Up_ID;
     if Objectcode='13' then result:=Butterfly_Down_ID;
     if Objectcode='14' then result:=Butterfly_Left_ID;
     if Objectcode='15' then result:=Butterfly_Right_ID;
     //
     if Objectcode='16' then result:=C64Boulder_ID;
     if Objectcode='17' then result:=C64Boulder_ID;   //delay

     if Objectcode='20' then result:=C64Diamond_ID;
     if Objectcode='37' then result:=2; // eigenlijk "inn"
     //if Objectcode='41' then result:=eating wall ;
     if Objectcode='42' then result:=EXP_Wall_Hor_ID;
     if Objectcode='44' then result:=EXP_Wall_Ver_ID;
     if Objectcode='46' then result:=EXP_Wall_ID;
     if Objectcode='48' then result:=Butterfly_Up_ID;
     if Objectcode='49' then result:=Butterfly_Down_ID;
     if Objectcode='50' then result:=Butterfly_Left_ID;
     if Objectcode='51' then result:=Butterfly_Right_ID;
     // delay
     if Objectcode='52' then result:=Firefly_Up_ID;
     if Objectcode='53' then result:=Firefly_Down_ID;
     if Objectcode='54' then result:=Firefly_Left_ID;
     if Objectcode='55' then result:=Firefly_Right_ID;
     if Objectcode='56' then result:=Steel_Wall_ID;
     if Objectcode='57' then result:=Slime_ID;
     if Objectcode='58' then result:=Acid_ID;
     //if Objectcode='86' then result:=voodoo doll;
     if Objectcode='87' then result:=Amoeba_ID;
     if Objectcode='184' then result:=33; // uneatable dirt

     if Objectcode='194' then result:=EXP_Wall_Hor_ID;
     if Objectcode='196' then result:=EXP_Wall_Ver_ID;
     if Objectcode='198' then result:=EXP_Wall_ID;
     val(Objectcode,i,code);
     if code<>0 then result:=-1;
end;

function Rocksndiamonds_to_Stef(ObjectCode:byte):byte;
begin
      result:=Grover_ID;
      if objectcode=0  then result:=Empty_Space_ID;
      if objectcode=1  then result:=Dirt_ID;
      if objectcode=2  then result:=Stone_Wall1_ID; // stable
      if objectcode=3  then result:=Round_Stone_Wall_ID; // unstable
      if objectcode=4  then result:=Rock_ID;
      if objectcode=6  then result:=Emerald_ID;
      if objectcode=7  then result:=Exit_Close_ID;
      if objectcode=8  then result:=2;
      if objectcode=9  then result:=Bug_Right_ID; // Nogmaals ???
      if objectcode=10  then result:=Ship_Right_ID; // Nogmaals ???
      if objectcode=11 then result:=Yam_Up_ID;
      if objectcode=12 then result:=Robot_ID;
      if objectcode=13 then result:=Steel_Wall_ID;
      if objectcode=14 then result:=Diamond_ID;
      if objectcode=15 then result:=Amoeba_ID; // inactive
      if objectcode=16 then result:=Quicksand_ID;
      if objectcode=17 then result:=Quicksand_Rock_ID;
      if objectcode=18 then result:=Amoeba_Drop_ID;
      if objectcode=19 then result:=Bomb_ID;
      if objectcode=20 then result:=Magic_Wall_ID;
      if objectcode=22 then result:=Acid_ID;
      if objectcode=23 then result:=Amoeba_ID;
      if objectcode=24 then result:=Amoeba_ID;// nogmaals ?
      if objectcode=25 then result:=Nut_ID;
      if objectcode=27 then result:=Biomaze_ID;
      if objectcode=28 then result:=Dynamite_Active_ID;
      if objectcode=29 then result:=Stone_Wall2_ID;
      if objectcode=30 then result:=Wheel_ID;
      if objectcode=32 then result:=Key_Red_ID;
      if objectcode=33 then result:=Key_Yellow_ID;
      if objectcode=34 then result:=Key_Green_ID;
      if objectcode=35 then result:=Key_Blue_ID;
      if objectcode=36 then result:=Door_Red_cl_ID;
      if objectcode=37 then result:=Door_Yellow_cl_ID;
      if objectcode=38 then result:=Door_Green_cl_ID;
      if objectcode=39 then result:=Door_Yellow_cl_ID;
      if objectcode=40 then result:=Door_Gray_Re_cl_ID;
      if objectcode=41 then result:=Door_Gray_Ye_cl_ID;
      if objectcode=42 then result:=Door_Gray_Gr_cl_ID;
      if objectcode=43 then result:=Door_Gray_Bl_cl_ID;
      if objectcode=44 then result:=Dynamite_ID;
      if objectcode=45 then result:=Pacman_Right_ID;
      if objectcode=46 then result:=Invisible_Wall_ID;
      if objectcode=49 then result:=Diamond_Wall_ID;
      if objectcode=50 then result:=Emerald_Wall_ID;
      if objectcode=51 then
      begin
           result:=RockBirth_ID;
           // amoeba
           // convert to diamonds=true (eigenlijk amoeba content)
      end;
      //if objectcode=53 then result:=Extra_Time_ID;  // fuel
      if objectcode=56 then result:=Emerald_ID; // is eigenlijk original BD-diamond
      if objectcode=80 then result:=2;
      if objectcode=81 then result:=Fellow2_ID;
      if objectcode=84 then result:=Bug_Right_ID;
      if objectcode=85 then result:=Bug_Up_ID;
      if objectcode=86 then result:=Bug_Left_ID;
      if objectcode=87 then result:=Bug_Down_ID;
      if objectcode=88 then result:=Ship_Right_ID;
      if objectcode=89 then result:=Ship_Up_ID;
      if objectcode=90 then result:=Ship_Left_ID;
      if objectcode=91 then result:=Ship_Down_ID;
      if objectcode=92 then result:=Pacman_Right_ID;
      if objectcode=93 then result:=Pacman_Up_ID;
      if objectcode=94  then result:=Pacman_Left_ID;
      if objectcode=95 then result:=Pacman_Down_ID;
      if objectcode=100 then result:=AcidBox_TL_ID;
      if objectcode=101 then result:=AcidBox_TR_ID;
      if objectcode=102 then result:=AcidBox_BL_ID;
      if objectcode=103 then result:=AcidBox_B_ID;
      if objectcode=104 then result:=AcidBox_BR_ID;
      if objectcode=107  then result:=Exit_Open_ID;
      if objectcode=121  then result:=139; //exclamation point
      if objectcode=124  then result:=145; //Dollar sign
      if objectcode=134  then result:=136; //point
      if objectcode=148  then result:=141; //Arrow Left
      if objectcode=150  then result:=143; //Arrow Right
      if objectcode=151  then result:=138; //question mark
      if objectcode=182  then result:=145; //copyright

      if (objectcode>=153) and (objectcode<=179) then result :=objectcode-53; // letters
      if (objectcode>=136) and (objectcode<=146) then result :=objectcode-10; // cijfers
end;


function MaplevelhdrV1toV2(hdr: TlevelhdrV1): TlevelhdrV2;
var
i,j,k:integer;
begin
            result.BorderX:=hdr.Borderx;
            result.Bordery:=hdr.Bordery;
            result.Fellowx:=hdr.Fellowx;
            result.Fellowy:=hdr.Fellowy;
            result.DiamondsToCollect:=hdr.DiamondsToCollect;
            for i:=1 to 8 do
            for j:=1 to 3 do
            for k:=1 to 3 do
            result.YamContent[i,j,k]:=hdr.YamContent[i,j,k];
            result.LevelTime:=hdr.LevelTime;
            result.MagicWallTime:=hdr.MagicWallTime;
            result.WheelTime:=hdr.WheelTime;
            result.AmoebaRate:=hdr.AmoebaRate;
            result.EmeraldScore:=hdr.EmeraldScore;
            result.DiamondScore:=hdr.DiamondScore;
            result.RedGemScore:=hdr.RedGemScore;
            result.DynamiteScore:=hdr.DynamiteScore;
            result.NutScore:=hdr.NutScore;
            result.RobotScore:=hdr.RobotScore;
            result.ShipScore:=hdr.ShipScore;
            result.YamScore:=hdr.YamScore;
            result.TimeScore:=hdr.TimeScore;
            result.Bugscore:=hdr.Bugscore;
            result.KeyScore:=hdr.KeyScore;
            result.LevelName:=hdr.LevelName;
            result.LevelAuthor:=hdr.LevelAuthor;
            result.LevelCreationDate:=hdr.LevelCreationDate;
            result.Description:=hdr.Description;
            result.Status:=hdr.Status;
            result.PearlScore:=hdr.PearlScore;
            result.ChrystalScore:=hdr.ChrystalScore;
            result.GateWheelTime:=hdr.GateWheelTime;
            result.Hatchtime:=hdr.Hatchtime;
            result.AmoebaSpread:=hdr.AmoebaSpread;
            result.CheckAmoebapossible:=hdr.CheckAmoebapossible;
            result.Amoebabrake:=hdr.Amoebabrake;
            result.SlimePermeability:=hdr.SlimePermeability;
            result.DiamondsToCollect2:=hdr.DiamondsToCollect2;
            result.intermission:=hdr.intermission;
            result.PacmanScore:=hdr.PacmanScore;
            result.Fellowx2:=hdr.Fellowx2;
            result.Fellowy2:=hdr.Fellowy2;
            result.Extratime:=hdr.Extratime;
            result.ForcefieldTime:=hdr.ForcefieldTime;
            for i:=1 to 3 do
            for j:=1 to 3 do
            result.WellContent[i,j]:=hdr.WellContent[i,j];
            result.WellActiveStart:=hdr.WellActiveStart;
end;


function Stef_to_BDCFF(Objectcode:byte):string;
begin
     case Objectcode of
          Empty_Space_ID: result := ' ';
          Dirt_ID: result := '.';
          Fellow_ID: result := 'F';
          Rock_ID: result := 'B';
          Steel_Wall_ID : result := 'W';
          Stone_Wall1_ID : result := 'w';
     else  result := 'W';
     end;
end;

function BDCFF_to_Stef(Objectcode:byte):string;
begin
     case Objectcode of
          Empty_Space_ID: result := ' ';
          Dirt_ID: result := '.';
          Fellow_ID: result := 'F';
          Rock_ID: result := 'B';
          Steel_Wall_ID : result := 'W';
          Stone_Wall1_ID : result := 'w';
     else  result := 'W';
     end;
end;

end.
