/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

class SouthCanvas
extends Panel {
    static final int baseY = 1;
    static final int baseX = 7;
    static final int tileWidth = 18;
    static final int GEMCOUNT = 0;
    static final int GEMSNEEDED = 1;
    static final int SCORE = 2;
    static final int TIME = 3;
    Font stdFont = new Font("Helvetica", 0, 12);
    private NumDisplay[] nd = new NumDisplay[5];
    String msg = "";
    int bombs;
    static final int[] tiles = new int[]{22, 23, 13, 61, 0, 4, 2, 3, 9, 10, 5, 11, 87, 52, 32, 36, 24, 28, 82, 86, 67};
    Button[] zoomButton = new Button[6];
    Button plusButton = new Button("+");
    Button minusButton = new Button("-");
    Image offImage;
    static final String[] editModeString = new String[]{"Draw mode", "Flood fill mode", "Random draw mode"};

    SouthCanvas() {
        this.setLayout(null);
        this.nd[0] = new NumDisplay(3);
        this.nd[1] = new NumDisplay(3);
        this.nd[2] = new NumDisplay(6);
        this.nd[3] = new NumDisplay(3);
        this.add(this.nd[0]);
        this.nd[0].move(160, 1);
        this.add(this.nd[1]);
        this.nd[1].move(208, 1);
        this.add(this.nd[2]);
        this.nd[2].move(320, 1);
        this.add(this.nd[3]);
        this.nd[3].move(464, 1);
        int n = 0;
        while (n < 6) {
            this.zoomButton[n] = new Button(String.valueOf(n + 1));
            this.zoomButton[n].setFont(this.stdFont);
            this.add(this.zoomButton[n]);
            this.zoomButton[n].reshape(n * 16, 24, 16, 16);
            ++n;
        }
        this.add(this.plusButton);
        this.plusButton.setFont(this.stdFont);
        this.add(this.minusButton);
        this.minusButton.setFont(this.stdFont);
        this.minusButton.reshape(584, 24, 16, 16);
        this.plusButton.reshape(624, 24, 16, 16);
    }

    void addBomb() {
        Graphics graphics;
        ++this.bombs;
        if (this.bombs < 7 && (graphics = this.getGraphics()) != null) {
            graphics.drawImage(Boulderland.img[61], this.bombs * 16, 1, null);
        }
    }

    void clearBombs() {
        this.bombs = 0;
        this.repaint();
    }

    void deleteBomb() {
        Graphics graphics;
        --this.bombs;
        if (this.bombs < 6 && (graphics = this.getGraphics()) != null) {
            graphics.setColor(Color.black);
            graphics.fillRect((this.bombs + 1) * 16, 1, 16, 16);
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (Boulderland.mode == 2) {
            if (n2 >= 1 && n2 < 17) {
                int n3 = n / 18;
                Boulderland.editTile = n3 < 7 || n3 >= 7 + tiles.length ? 22 : tiles[n3 - 7];
                this.repaint();
            } else if (n2 > 25) {
                Boulderland.editMode = (Boulderland.editMode + 1) % 3;
                this.repaint();
            }
        }
        return true;
    }

    public void paint(Graphics graphics) {
        int n;
        if (graphics == null) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.size().width, this.size().height);
        this.paintMain(graphics);
        if (Boulderland.mode == 2 && this.nd[0].isShowing()) {
            n = 0;
            while (n < 4) {
                this.nd[n].hide();
                ++n;
            }
        }
        if (Boulderland.mode != 2 && !this.nd[0].isShowing()) {
            n = 0;
            while (n < 4) {
                this.nd[n].show();
                ++n;
            }
        }
        this.paintBombs(graphics);
        this.paintDelay(graphics);
    }

    void setDisplay(int n, int n2) {
        this.nd[n].setValue(n2);
    }

    void setMessage(String string) {
        this.msg = string;
        this.paintMessage(null);
    }

    public void update(Graphics graphics) {
        int n = this.size().width;
        int n2 = this.size().height;
        if (this.offImage == null || this.offImage.getWidth(this) != n || this.offImage.getHeight(this) != n2) {
            this.offImage = this.createImage(this.size().width, this.size().height);
        }
        Graphics graphics2 = this.offImage.getGraphics();
        this.paint(graphics2);
        graphics.drawImage(this.offImage, 0, 0, this);
    }

    void updateDisplays() {
        int n = 0;
        while (n < 4) {
            this.nd[n].repaint();
            ++n;
        }
    }

    void paintDelay(Graphics graphics) {
        graphics.setFont(this.stdFont);
        graphics.setColor(Color.lightGray);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = String.valueOf(Boulderland.delay);
        int n = (24 - fontMetrics.stringWidth(string)) / 2;
        graphics.drawString(string, 600 + n, 36);
    }

    private void paintBombs(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n = 0;
        while (n < 6 && n < this.bombs) {
            graphics.drawImage(Boulderland.img[61], (n + 1) * 16, 1, null);
            ++n;
        }
    }

    private void paintEdit(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n = 0;
        while (n < tiles.length) {
            Image image = Boulderland.img[tiles[n]];
            graphics.drawImage(image, (n + 7) * 18, 1, null);
            if (tiles[n] == Boulderland.editTile) {
                graphics.setColor(Color.white);
                graphics.drawRect((n + 7) * 18, 1, 15, 15);
                graphics.drawRect((n + 7) * 18 - 1, 0, 17, 17);
                graphics.setColor(Color.black);
                graphics.drawRect((n + 7) * 18 + 1, 2, 13, 13);
            }
            ++n;
        }
    }

    private void paintMain(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (Boulderland.mode == 2) {
            this.paintEdit(graphics);
        } else {
            graphics.drawImage(Boulderland.img[13], 136, 1, null);
            graphics.drawImage(Boulderland.scoreImage, 272, 1, null);
            graphics.drawImage(Boulderland.timeImage, 424, 1, null);
        }
        this.paintMessage(graphics);
    }

    private void paintMessage(Graphics graphics) {
        if (graphics == null && (graphics = this.getGraphics()) != null) {
            graphics.clearRect(96, 26, 488, 16);
        }
        if (graphics == null) {
            return;
        }
        String string = this.msg;
        if (Boulderland.mode == 2) {
            string = editModeString[Boulderland.editMode];
        }
        if (string.length() > 0) {
            Font font = new Font("Helvetica", 1, 14);
            graphics.setFont(font);
            graphics.setColor(Color.yellow);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (fontMetrics != null) {
                int n = fontMetrics.stringWidth(string);
                graphics.drawString(string, this.size().width / 2 - n / 2, 36);
            }
        }
    }
}

