/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.PrintStream;
import java.util.Random;
import java.util.Vector;

class Replay {
    static final String playerKey = "player";
    static final String gemsCollectedKey = "gemsCollected";
    static final String escapedKey = "escaped";
    static final String timeLeftKey = "timeLeft";
    static final String commentKey = "comment";
    static final String seedKey = "seed";
    static final String movesKey = "moves";
    static final byte NOMOVE = -1;
    String player = "Unknown";
    int gemsCollected;
    int timeLeft;
    boolean escaped = false;
    long seed;
    Vector commentStr = new Vector();
    Vector commentPos = new Vector();
    byte[] moves;
    int movePos;
    int moveCount;
    String comp;
    int commentIndex;

    Replay() {
        this.moves = new byte[10001];
        this.movePos = 0;
        this.moveCount = 0;
        this.seed = new Random().nextLong();
        this.seed %= 1000000L;
    }

    Replay(Scanner scanner) {
        try {
            Object object;
            while ((object = scanner.next()) instanceof String) {
                double d;
                Object object2;
                String string = (String)object;
                if (string.equals(playerKey)) {
                    scanner.expectToken('=');
                    object2 = scanner.next().toString();
                    this.player = object2;
                } else if (string.equals(gemsCollectedKey)) {
                    scanner.expectToken('=');
                    object2 = scanner.next();
                    if (object2 instanceof Double) {
                        d = (Double)object2;
                        this.gemsCollected = (int)d;
                    }
                } else if (string.equals(commentKey)) {
                    object2 = scanner.next();
                    if (object2 instanceof Double) {
                        int n = ((Double)object2).intValue();
                        object2 = scanner.next();
                        if (object2 instanceof String) {
                            this.commentPos.addElement(new Integer(n));
                            this.commentStr.addElement(object2);
                        }
                    }
                } else if (string.equals(seedKey)) {
                    scanner.expectToken('=');
                    object2 = scanner.next();
                    if (object2 instanceof Double) {
                        this.seed = ((Double)object2).longValue();
                    }
                } else if (string.equals(timeLeftKey)) {
                    scanner.expectToken('=');
                    object2 = scanner.next();
                    if (object2 instanceof Double) {
                        d = (Double)object2;
                        this.timeLeft = (int)d;
                    }
                } else if (string.equals(escapedKey)) {
                    this.escaped = true;
                } else if (string.equals(movesKey)) {
                    scanner.expectToken('=');
                    object2 = scanner.next();
                    this.comp = (String)object2;
                    return;
                }
                while (!(object2 = scanner.next()).toString().equals(";")) {
                }
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void save(PrintStream printStream) throws IOException {
        printStream.println("    player = \"" + this.player + "\";");
        printStream.println("    gemsCollected = " + this.gemsCollected + ";");
        printStream.println("    timeLeft = " + this.timeLeft + ";");
        printStream.println("    seed = " + this.seed + ";");
        int n = 0;
        while (n < this.commentPos.size()) {
            int n2 = (Integer)this.commentPos.elementAt(n);
            String string = (String)this.commentStr.elementAt(n);
            printStream.println("    comment " + n2 + " \"" + string + "\";");
            ++n;
        }
        if (this.escaped) {
            printStream.println("    escaped;");
        }
        if (this.comp == null) {
            this.compress();
        }
        printStream.println("    moves = \"" + this.comp + "\";");
    }

    void compress() {
        char[] cArray = new char[this.moveCount];
        int n = 0;
        int n2 = 0;
        while (n2 < this.moveCount) {
            int n3 = 0;
            while (n2 < this.moveCount && this.moves[n2] == -1) {
                ++n3;
                ++n2;
            }
            if (n3 > 0) {
                String string = String.valueOf(n3);
                int n4 = string.length();
                int n5 = 0;
                while (n5 < n4) {
                    cArray[n++] = string.charAt(n5);
                    ++n5;
                }
            }
            if (n2 < this.moveCount) {
                cArray[n++] = (char)(97 + this.moves[n2]);
            }
            ++n2;
        }
        this.comp = new String(cArray, 0, n);
        this.moves = null;
        cArray = null;
        System.gc();
    }

    void expand() {
        if (this.moves == null) {
            int n = this.comp.length();
            this.moveCount = 0;
            this.moves = new byte[10001];
            int n2 = 0;
            while (n2 < n) {
                int n3 = 0;
                while (n2 < n && this.comp.charAt(n2) >= '0' && this.comp.charAt(n2) <= '9') {
                    n3 = n3 * 10 + (this.comp.charAt(n2) - 48);
                    ++n2;
                }
                int n4 = 0;
                while (n4 < n3) {
                    this.moves[this.moveCount++] = -1;
                    ++n4;
                }
                if (n2 < n) {
                    this.moves[this.moveCount++] = (byte)(this.comp.charAt(n2) - 97);
                }
                ++n2;
            }
            this.comp = null;
        }
    }

    void reset() {
        this.movePos = 0;
    }

    void addNotMoved() {
        this.moves[this.moveCount++] = -1;
    }

    void addMove(int n, boolean bl, boolean bl2) {
        byte by = (byte)n;
        if (bl) {
            by = (byte)(by | 4);
        }
        if (bl2) {
            by = (byte)(by | 8);
        }
        this.moves[this.moveCount++] = by;
    }

    byte nextMove() {
        if (this.movePos == this.moveCount) {
            return -1;
        }
        return this.moves[this.movePos++];
    }

    void addComment(int n, String string) {
        this.commentPos.addElement(new Integer(n));
        this.commentStr.addElement(string);
    }
}

