/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

class NorthCanvas
extends Panel {
    private int men = 3;
    private String str = "";
    private Image offImage;
    static final int START = 0;
    static final int REPLAY = 1;
    static final int EDIT = 2;
    static final int MENU = 3;
    static final int LOAD = 4;
    static final int SAVE = 5;
    static final int KILL = 6;
    static final int OPTIONS = 7;
    static final int TEST = 8;
    static final int BUTTON_COUNT = 9;
    Button[] button = new Button[9];

    NorthCanvas() {
        this.setBackground(Color.black);
        this.setLayout(null);
        String[] stringArray = new String[]{"Start", "Replay", "Edit", "Menu", "Load", "Save", "Kill", "Options", "Test"};
        int[] nArray = new int[]{4, 68, 576, 4, 512, 576, 68, 68, 132};
        Font font = new Font("Helvetica", 0, 12);
        int n = 0;
        while (n < 9) {
            this.button[n] = new Button(stringArray[n]);
            this.button[n].setFont(font);
            this.button[n].reshape(nArray[n], 0, 60, 17);
            this.add(this.button[n]);
            this.button[n].hide();
            ++n;
        }
        if (Boulderland.restricted) {
            this.button[4].disable();
            this.button[5].disable();
        }
    }

    public void paint(Graphics graphics) {
        this.layoutButtons();
        if (graphics == null) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.size().width, this.size().height);
        this.size();
        this.size();
        this.paintLevel(graphics);
        if (Boulderland.mode == 1 || Boulderland.mode == 3) {
            this.paintMen(graphics);
        }
    }

    void setLevel(int n, String string, boolean bl) {
        if (n < 0) {
            this.setString("Testplay of " + string);
            return;
        }
        if (bl) {
            this.setString("Bonuslevel " + n + ": " + string);
            return;
        }
        this.setString("Level " + n + ": " + string);
    }

    void setMen(int n) {
        this.men = n;
        this.repaint();
    }

    void setString(String string) {
        this.str = string;
        this.repaint();
    }

    public void update(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n = this.size().width;
        int n2 = this.size().height;
        if (this.offImage == null || this.offImage.getWidth(null) != n || this.offImage.getHeight(null) != n2) {
            this.offImage = this.createImage(this.size().width, this.size().height);
        }
        Graphics graphics2 = this.offImage.getGraphics();
        this.paint(graphics2);
        graphics.drawImage(this.offImage, 0, 0, this);
    }

    private void center(Graphics graphics, String string, int n, int n2, Color color) {
        if (graphics == null) {
            return;
        }
        int n3 = this.size().width;
        graphics.setColor(color);
        graphics.setFont(new Font("Helvetica", n2 > 30 ? 1 : 0, n2));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (fontMetrics != null) {
            int n4 = fontMetrics.stringWidth(string);
            graphics.drawString(string, n3 / 2 - n4 / 2, n);
        }
    }

    private void layoutButtons() {
        int[] nArray = new int[]{0, 1, 2};
        int[] nArray2 = new int[]{3, 7, 8, 4, 5};
        int[] nArray3 = new int[]{3, 6};
        int[] nArray4 = new int[]{6};
        int[] nArray5 = new int[]{8};
        int[] nArray6 = new int[]{};
        if (Boulderland.optionsDialog != null) {
            nArray6 = nArray5;
        } else if (Boulderland.mode == 0) {
            nArray6 = nArray;
        } else if (Boulderland.mode == 2) {
            nArray6 = nArray2;
        } else if (Boulderland.mode == 1) {
            nArray6 = nArray3;
        } else if (Boulderland.mode == 3) {
            nArray6 = nArray4;
        }
        int n = this.size().height - 18;
        int n2 = 0;
        while (n2 < 9) {
            boolean bl = false;
            int n3 = 0;
            while (n3 < nArray6.length) {
                if (nArray6[n3] == n2) {
                    bl = true;
                }
                ++n3;
            }
            if (bl && !this.button[n2].isShowing()) {
                this.button[n2].show();
            } else if (!bl && this.button[n2].isShowing()) {
                this.button[n2].hide();
            }
            if (this.button[n2].location().y != n) {
                this.button[n2].move(this.button[n2].location().x, n);
            }
            ++n2;
        }
    }

    private void paintLevel(Graphics graphics) {
        int n;
        String string;
        if (graphics == null) {
            return;
        }
        int n2 = this.size().height;
        Font font = new Font("Helvetica", 1, 16);
        graphics.setFont(font);
        graphics.setColor(Color.red);
        if (Boulderland.mode == 2) {
            string = "Editor";
            if (Boulderland.restricted) {
                string = String.valueOf(string) + " (Restricted)";
            }
        } else if (Boulderland.mode == 6) {
            string = "Please select a replay";
        } else if (Boulderland.mode == 0) {
            n = Boulderland.startLevel;
            string = "Start at level " + n + " (" + Boulderland.levelNames.elementAt(n - 1) + ")";
        } else {
            string = Boulderland.mode == 7 ? "Paused" : this.str;
        }
        n = graphics.getFontMetrics().stringWidth(string);
        graphics.drawString(string, this.size().width / 2 - n / 2, n2 - 3);
    }

    private void paintMen(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n = this.size().height;
        int n2 = 0;
        while (n2 < 10) {
            int n3 = (38 - n2) * 16;
            int n4 = n2 < this.men ? 69 : 22;
            graphics.drawImage(Boulderland.img[n4], n3, n - 18, null);
            ++n2;
        }
    }
}

