/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.PrintStream;
import java.util.Random;

class Map {
    static final int DIR_UP = 0;
    static final int DIR_DOWN = 1;
    static final int DIR_LEFT = 2;
    static final int DIR_RIGHT = 3;
    static final int[][] add = new int[][]{{0, -1}, {0, 1}, {-1, 0}, {1, 0}};
    static final int[] ghostPrevDir = new int[]{2, 3, 1, 0};
    static final int[] ghostNextDir = new int[]{3, 2, 0, 1};
    static final int[] flyPrevDir = new int[]{3, 2, 0, 1};
    static final int[] flyNextDir = new int[]{2, 3, 1, 0};
    private Field[][] field;
    private int playerStatus;
    static final int PS_ENTERING = 0;
    static final int PS_ALIVE = 1;
    static final int PS_DEAD = 2;
    static final int PS_ESCAPED = 3;
    private int playerX;
    private int playerY;
    private int width;
    private int height;
    private int magicStatus = 0;
    static final int MS_READY = 0;
    static final int MS_MAGIC = 1;
    static final int MS_OVER = 2;
    private int magicTime;
    private int gemCount;
    private int bombCount;
    private int shield;
    private int timer;
    private int roundCount;
    int manWaitCount = 1;
    int manWaitAnimation = -1;
    int manLastDir = 3;
    private Options options;
    private int deathCount;
    private Random random;
    static final int[][] fieldConvert = new int[][]{{22, 32}, {23, 46}, {2, 64}, {3, 120}, {0, 35}, {4, 43}, {9, 45}, {10, 124}, {5, 126}, {87, 37}, {11, 111}, {13, 42}, {67, 167}, {24, 97}, {28, 115}, {32, 103}, {36, 102}, {52, 176}, {61, 98}, {82, 119}, {86, 116}};

    Map(Options options, int n, int n2) {
        this.options = options;
        this.initDimensions(n, n2);
        int n3 = 0;
        while (n3 < this.width) {
            this.field[n3][0].transform(0);
            this.field[n3][this.height - 1].transform(0);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.height) {
            this.field[0][n4].transform(0);
            this.field[this.width - 1][n4].transform(0);
            ++n4;
        }
        int n5 = 1;
        while (n5 < this.width - 1) {
            int n6 = 1;
            while (n6 < this.height - 1) {
                this.field[n5][n6].transform(23);
                ++n6;
            }
            ++n5;
        }
        this.field[1][1].transform(2);
        this.field[2][1].transform(3);
        this.field[1][2].transform(13);
        this.prepare(0L);
    }

    Map(Map map) {
        this.options = map.options;
        this.initDimensions(map.width, map.height);
        int n = 0;
        while (n < this.width) {
            int n2 = 0;
            while (n2 < this.height) {
                this.field[n][n2].type = map.field[n][n2].type;
                this.field[n][n2].info = map.field[n][n2].info;
                ++n2;
            }
            ++n;
        }
        this.bombCount = map.bombCount;
        this.gemCount = map.gemCount;
        this.magicStatus = map.magicStatus;
        this.magicTime = map.magicTime;
        this.playerStatus = map.playerStatus;
        this.playerX = map.playerX;
        this.playerY = map.playerY;
        this.roundCount = map.roundCount;
        this.shield = map.shield;
        this.timer = map.timer;
        this.prepare(0L);
    }

    Map(String[] stringArray, Options options) {
        this.options = options;
        int n = stringArray[0].length();
        int n2 = stringArray.length;
        this.initDimensions(n, n2);
        int n3 = 0;
        while (n3 < this.width) {
            int n4 = 0;
            while (n4 < this.height) {
                char c = stringArray[n4].charAt(n3);
                int n5 = 0;
                while (n5 < fieldConvert.length && fieldConvert[n5][1] != c) {
                    ++n5;
                }
                if (n5 < fieldConvert.length) {
                    this.field[n3][n4].transform(fieldConvert[n5][0]);
                }
                ++n4;
            }
            ++n3;
        }
        this.prepare(0L);
    }

    Field getField(int n, int n2) {
        return this.field[n][n2];
    }

    int getGemCount() {
        return this.gemCount;
    }

    int getHeight() {
        return this.height;
    }

    int getMagicStatus() {
        return this.magicStatus;
    }

    int getPlayerStatus() {
        return this.playerStatus;
    }

    int getPlayerX() {
        return this.playerX;
    }

    int getPlayerY() {
        return this.playerY;
    }

    int getShield() {
        return this.shield;
    }

    int getTimer() {
        return this.timer;
    }

    int getWidth() {
        return this.width;
    }

    void initRandom(long l) {
        this.random = new Random(l);
    }

    boolean isEnough() {
        return this.gemCount >= this.options.gemsNeeded;
    }

    private void moveCreature(Field field, Field field2) {
        field2.type = field.type;
        field2.info = field.info;
        field.type = 22;
        field.info = 0;
        field2.setMoved();
    }

    void startReplay(Replay replay) {
        this.initRandom(replay.seed);
    }

    /*
     * WARNING - void declaration
     */
    void playerEvent(Replay replay, Replay replay2) {
        int n;
        int n2;
        if (replay != null && (n2 = replay.commentIndex++) < replay.commentPos.size() && (n = ((Integer)replay.commentPos.elementAt(n2)).intValue()) == this.timer) {
            String string = (String)replay.commentStr.elementAt(n2);
            Boulderland.south.setMessage(string);
        }
        if (this.playerStatus == 1) {
            n2 = -1;
            boolean bl = false;
            boolean bl2 = false;
            if (Boulderland.suicide) {
                Boulderland.suicide = false;
                this.shield = 0;
                this.field[this.playerX][this.playerY].explosion(40, this);
                return;
            }
            if (replay == null) {
                n2 = Boulderland.dir;
                boolean bl3 = Boulderland.ctrl;
                bl2 = Boulderland.shift;
            } else {
                byte by = replay.nextMove();
                if (by != -1) {
                    n2 = by & 3;
                    boolean bl4 = (by & 4) != 0;
                    boolean bl5 = bl2 = (by & 8) != 0;
                }
            }
            if (n2 >= 0 && n2 < 4) {
                void var4_8;
                if (replay2 != null) {
                    replay2.addMove(n2, (boolean)var4_8, bl2);
                }
                if (this.shield > 0) {
                    n2 = 3 - n2;
                }
                Field field = this.field[this.playerX][this.playerY];
                Field field2 = field.neighbor(n2);
                if (var4_8 != false) {
                    if (this.bombCount > 0 && field2.type == 22) {
                        --this.bombCount;
                        field2.transform(field2.lower.isSpace() ? 66 : 62);
                        field2.setMoved();
                        Boulderland.south.deleteBomb();
                    } else if (field2.type == 52) {
                        field2.transform(57);
                    }
                } else {
                    int n3;
                    if (field2.type == 23) {
                        field2.type = 22;
                    } else if (field2.type == 13) {
                        field2.type = 22;
                        ++this.gemCount;
                        int n4 = this.gemCount;
                        Boulderland.south.setDisplay(0, n4);
                        n4 = this.options.gemValue;
                        if ((Game.score += n4) / 1000 > (Game.score - n4) / 1000) {
                            Boulderland.north.setMen(++Game.lives);
                        }
                        n3 = Game.score;
                        Boulderland.south.setDisplay(2, n3);
                    } else if (field2.type == 61) {
                        field2.type = 22;
                        ++this.bombCount;
                        Boulderland.south.addBomb();
                    } else if (field2.type == 67) {
                        field2.type = 22;
                        this.shield += 50;
                    } else if (!(n2 != 2 && n2 != 3 || field2.type != 11 && field2.type != 87 || !field2.neighbor(n2).isSpace())) {
                        double d = this.random.nextDouble();
                        double d2 = field2.type == 11 ? 0.4 : 0.2;
                        if (d < d2) {
                            field2.neighbor(n2).transform(field2.type);
                            field2.transform(22);
                        }
                    } else if ((n2 == 2 || n2 == 3) && field2.type == 66 && field2.neighbor(n2).isSpace()) {
                        field2.neighbor(n2).transform(field2.type);
                        field2.transform(22);
                    } else if (field2.type == 52) {
                        Field field3 = field2;
                        while (field3.type == 52) {
                            field3 = field3.neighbor(n2);
                        }
                        if (field3.type == 22) {
                            field2.transform(22);
                            field3.transform(52);
                            field3.info = 0;
                            field3.setMoved();
                        }
                    } else if (field2.type == 3 && this.isEnough()) {
                        this.playerStatus = 3;
                        field.transform(22);
                        int n5 = this.timer / 10;
                        if ((Game.score += n5) / 1000 > (Game.score - n5) / 1000) {
                            Boulderland.north.setMen(++Game.lives);
                        }
                        n3 = Game.score;
                        Boulderland.south.setDisplay(2, n3);
                    }
                    if (!bl2 && field2.type == 22) {
                        field.type = 22;
                        field2.type = 69;
                        int n6 = this.playerX;
                        n3 = this.playerY;
                        this.playerX = (this.playerX + this.width + add[n2][0]) % this.width;
                        this.playerY = (this.playerY + this.height + add[n2][1]) % this.height;
                        if (n6 == 0 && this.playerX == this.width - 1 || n6 == this.width - 1 && this.playerX == 0 || n3 == 0 && this.playerY == this.height - 1 || n3 == this.height - 1 && this.playerY == 0) {
                            Boulderland.bc.centerPos(this.playerX, this.playerY);
                        }
                    }
                }
                this.manWaitCount = 0;
                this.manWaitAnimation = -1;
                if (n2 == 2 || n2 == 3) {
                    this.manLastDir = n2;
                }
                return;
            }
            ++this.manWaitCount;
            if (this.manWaitCount == 20) {
                this.manWaitAnimation = (int)(this.random.nextDouble() * 100.0) % 3;
                this.manWaitCount = 0;
            }
            if (replay2 != null) {
                replay2.addNotMoved();
            }
        }
    }

    boolean round() {
        int n;
        ++this.roundCount;
        if (this.playerStatus == 1) {
            --this.timer;
            if (this.timer <= 0) {
                this.shield = 0;
                this.field[this.playerX][this.playerY].explosion(46, this);
                this.playerStatus = 2;
            }
        } else if (this.playerStatus != 0) {
            ++this.deathCount;
            if (this.deathCount > 25) {
                return true;
            }
        }
        boolean bl = true;
        int n2 = 0;
        if (this.playerStatus == 1) {
            Field field = this.field[this.playerX][this.playerY];
            if (field.isTypeAround(36)) {
                field.explosion(46, this);
            } else if (field.isTypeAround(32)) {
                field.explosion(40, this);
            }
        }
        int n3 = this.height - 1;
        while (n3 >= 0) {
            n = this.width - 1;
            while (n >= 0) {
                Field field = this.field[n][n3];
                if (field.moved == 0) {
                    int n4 = field.type;
                    block0 : switch (n4) {
                        case 52: {
                            boolean bl2;
                            boolean bl3 = bl2 = this.random.nextDouble() < this.options.bubblePlop;
                            if (bl2) {
                                field.transform(57);
                                break;
                            }
                            if (field.upper.isSpace()) {
                                ++field.info;
                                if (field.info < 3) break;
                                field.upper.transform(52);
                                field.upper.info = 0;
                                field.upper.setMoved();
                                field.transform(22);
                                field.info = 0;
                                break;
                            }
                            if (field.upper.isSlidy() && field.left.isSpace() && field.left.upper.isSpace()) {
                                field.transform(22);
                                field.left.transform(52);
                                field.left.setMoved();
                                break;
                            }
                            if (field.upper.isSlidy() && field.right.isSpace() && field.right.upper.isSpace()) {
                                field.transform(22);
                                field.right.transform(52);
                                field.right.setMoved();
                                break;
                            }
                            field.info = 0;
                            break;
                        }
                        case 11: 
                        case 13: 
                        case 61: 
                        case 67: 
                        case 87: {
                            int n5;
                            if (field.lower.isSpace()) {
                                field.transform(field.getFallingType());
                                break;
                            }
                            if (!field.lower.isSlidy()) break;
                            if (field.left.isSpace() && field.left.lower.isSpace()) {
                                int n6 = field.left.upper.type;
                                if (n6 == 11 || n6 == 12 || n6 == 13 || n6 == 21) break;
                                field.left.transform(field.getFallingType());
                                field.transform(22);
                                field.left.setMoved();
                                field.moved = 2;
                                break;
                            }
                            if (!field.right.isSpace() || !field.right.lower.isSpace() || (n5 = field.right.upper.type) == 11 || n5 == 12 || n5 == 13 || n5 == 21) break;
                            field.right.transform(field.getFallingType());
                            field.transform(22);
                            field.right.setMoved();
                            field.moved = 2;
                            break;
                        }
                        case 12: 
                        case 21: 
                        case 68: 
                        case 88: {
                            if (field.lower.isSpace()) {
                                if (field.lower.moved == 2 || field.lower.type == 82) break;
                                field.transform(22);
                                field.lower.transform(n4);
                                field.lower.setMoved();
                                break;
                            }
                            field.transform(field.getStaticType());
                            break;
                        }
                        case 66: {
                            if (field.lower.isSpace()) {
                                field.transform(22);
                                field.lower.transform(n4);
                                field.lower.setMoved();
                                break;
                            }
                            field.explosion(40, this);
                            break;
                        }
                        case 32: {
                            if (field.upper.isFalling() || field.isTypeAround(24)) {
                                field.explosion(40, this);
                                break;
                            }
                            int n7 = field.info;
                            int n8 = ghostPrevDir[n7];
                            Field field2 = field.neighbor(n8);
                            if (field2.isSpace() && field2.moved == 0) {
                                field.info = n8;
                                this.moveCreature(field, field2);
                            } else {
                                field2 = field.neighbor(n7);
                                if (field2.isSpace() && field2.moved == 0) {
                                    this.moveCreature(field, field2);
                                } else {
                                    int n9 = ghostNextDir[n7];
                                    field2 = field.neighbor(n9);
                                    field.info = n9;
                                    if (field2.isSpace() && field2.moved == 0) {
                                        this.moveCreature(field, field2);
                                    } else {
                                        field2 = field;
                                    }
                                }
                            }
                            if (field2.upper.isFalling()) {
                                field2.explosion(40, this);
                                break;
                            }
                            field.setMoved();
                            break;
                        }
                        case 36: {
                            if (field.upper.isFalling() || field.isTypeAround(24)) {
                                field.explosion(46, this);
                                break;
                            }
                            int n10 = field.info;
                            int n11 = flyPrevDir[n10];
                            Field field3 = field.neighbor(n11);
                            if (field3.isSpace() && field3.moved == 0) {
                                field.info = n11;
                                this.moveCreature(field, field3);
                            } else {
                                field3 = field.neighbor(n10);
                                if (field3.isSpace() && field3.moved == 0) {
                                    this.moveCreature(field, field3);
                                } else {
                                    int n12 = flyNextDir[n10];
                                    field3 = field.neighbor(n12);
                                    field.info = n12;
                                    if (field3.isSpace() && field3.moved == 0) {
                                        this.moveCreature(field, field3);
                                    } else {
                                        field3 = field;
                                    }
                                }
                            }
                            if (field3.upper.isFalling()) {
                                field3.explosion(46, this);
                                break;
                            }
                            field.setMoved();
                            break;
                        }
                        case 82: {
                            if (field.upper.isFalling()) {
                                field.explosion(40, this);
                                break;
                            }
                            if (this.roundCount % 4 != 0 || this.playerStatus != 1) break;
                            int[] nArray = new int[4];
                            if (n != this.playerX && this.roundCount % 7 != 0) {
                                nArray[0] = n < this.playerX ? 3 : 2;
                                nArray[1] = n3 < this.playerY ? 1 : 0;
                                nArray[2] = n < this.playerX ? 2 : 3;
                                nArray[3] = n3 < this.playerY ? 0 : 1;
                            } else {
                                nArray[0] = n3 < this.playerY ? 1 : 0;
                                nArray[1] = n < this.playerX ? 3 : 2;
                                nArray[2] = n3 < this.playerY ? 0 : 1;
                                nArray[3] = n < this.playerX ? 2 : 3;
                            }
                            int n13 = 0;
                            while (n13 < 4) {
                                int n14 = nArray[n13];
                                Field field4 = field.neighbor(n14);
                                int n15 = field4.type;
                                if (n15 == 69) {
                                    field4.explosion(40, this);
                                    break block0;
                                }
                                if (n15 == 22 || n15 == 23) {
                                    int[] nArray2 = new int[]{1, 0, 3, 2};
                                    Field field5 = field;
                                    field4.setMoved();
                                    int n16 = 82;
                                    int n17 = 0;
                                    while (n17 < 100) {
                                        field4.type = n16;
                                        field4.info = nArray2[n14] + 1;
                                        field5.transform(22);
                                        int n18 = field5.info - 1;
                                        if (n18 < 0) break;
                                        field4 = field5;
                                        field5 = field5.neighbor(n18);
                                        n14 = nArray2[n18];
                                        if (field5.type != 86) break;
                                        n16 = 86;
                                        ++n17;
                                    }
                                    if (n17 != 100) break block0;
                                    field5.transform(67);
                                    break block0;
                                }
                                ++n13;
                            }
                            break;
                        }
                        case 69: {
                            if (!field.upper.isFalling()) break;
                            field.explosion(40, this);
                            break;
                        }
                        case 24: {
                            Field field6;
                            int n19;
                            ++n2;
                            if (bl && field.isGrowable()) {
                                bl = false;
                            }
                            int n20 = n19 = this.random.nextDouble() < this.options.amoebaSpeed ? (int)(this.random.nextDouble() * 4.0) % 4 : -1;
                            if (n19 < 0 || !(field6 = field.neighbor(n19)).isType(22) && !field6.isType(23)) break;
                            field6.transform(24);
                            field6.setMoved();
                            break;
                        }
                        case 2: {
                            if (this.roundCount <= 25) break;
                            if (this.playerStatus == 0) {
                                this.playerX = n;
                                this.playerY = n3;
                                this.playerStatus = 1;
                                field.transform(69);
                                break;
                            }
                            field.transform(22);
                            break;
                        }
                        case 5: {
                            if (!field.upper.isType(12) && !field.upper.isType(21)) break;
                            if (this.magicStatus == 0) {
                                this.magicStatus = 1;
                            }
                            if (this.magicStatus != 1) break;
                            if (field.lower.isType(22)) {
                                field.lower.transform(field.upper.type == 21 ? 12 : 21);
                            }
                            field.lower.setMoved();
                            field.upper.transform(22);
                            break;
                        }
                        case 28: {
                            if (!field.upper.isType(11) && !field.upper.isType(13) || !field.lower.isSpace() || !(this.random.nextDouble() < this.options.slimePerm)) break;
                            int n21 = field.upper.getFallingType();
                            field.lower.transform(n21);
                            field.lower.setMoved();
                            field.upper.transform(22);
                            break;
                        }
                        case 9: {
                            if (field.left.isSpace()) {
                                field.left.transform(9);
                                field.left.setMoved();
                            }
                            if (!field.right.isSpace()) break;
                            field.right.transform(9);
                            field.right.setMoved();
                            break;
                        }
                        case 10: {
                            if (field.upper.isSpace()) {
                                field.upper.transform(10);
                                field.upper.setMoved();
                            }
                            if (!field.lower.isSpace()) break;
                            field.lower.transform(10);
                            field.lower.setMoved();
                            break;
                        }
                        case 45: 
                        case 60: {
                            field.transform(22);
                            break;
                        }
                        case 51: {
                            field.transform(13);
                            break;
                        }
                        case 65: {
                            field.explosion(40, this);
                            break;
                        }
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 62: 
                        case 63: 
                        case 64: {
                            field.transform(n4 + 1);
                        }
                    }
                }
                --n;
            }
            --n3;
        }
        if (bl) {
            this.replaceType(24, 13);
        }
        if (this.options.amoebaMaximalSize > 0 && n2 > 0 && n2 >= this.options.amoebaMaximalSize) {
            this.replaceType(24, 11);
        }
        if (this.magicStatus == 1) {
            ++this.magicTime;
            if (this.magicTime >= this.options.magicDuration) {
                this.magicStatus = 2;
            }
        }
        if (this.shield > 0) {
            --this.shield;
        }
        n = this.height - 1;
        while (n >= 0) {
            int n22 = this.width - 1;
            while (n22 >= 0) {
                this.field[n22][n].moved = 0;
                --n22;
            }
            --n;
        }
        return false;
    }

    void save(PrintStream printStream) throws IOException {
        printStream.println();
        printStream.println("map = {");
        int n = 0;
        while (n < this.height) {
            String string = "    \"";
            int n2 = 0;
            while (n2 < this.width) {
                int n3 = this.field[n2][n].type;
                int n4 = 0;
                while (fieldConvert[n4][0] != n3) {
                    ++n4;
                }
                string = String.valueOf(string) + (char)fieldConvert[n4][1];
                ++n2;
            }
            string = String.valueOf(string) + "\"";
            printStream.println(string);
            ++n;
        }
        printStream.println("};");
    }

    void setPlayerStatus(int n) {
        this.playerStatus = n;
    }

    void start() {
        this.timer = this.options.totalTime;
        this.playerStatus = 0;
    }

    private void initDimensions(int n, int n2) {
        int n3;
        this.width = n;
        this.height = n2;
        this.field = new Field[this.width][this.height];
        int n4 = 0;
        while (n4 < this.width) {
            n3 = 0;
            while (n3 < this.height) {
                this.field[n4][n3] = new Field();
                ++n3;
            }
            ++n4;
        }
        n3 = 0;
        while (n3 < this.width) {
            int n5 = 0;
            while (n5 < this.height) {
                Field field = this.field[n3][n5 == 0 ? this.height - 1 : n5 - 1];
                Field field2 = this.field[n3][n5 == this.height - 1 ? 0 : n5 + 1];
                Field field3 = this.field[n3 == 0 ? this.width - 1 : n3 - 1][n5];
                Field field4 = this.field[n3 == this.width - 1 ? 0 : n3 + 1][n5];
                this.field[n3][n5].linkToNeighbors(field, field2, field3, field4);
                ++n5;
            }
            ++n3;
        }
    }

    private void prepare(long l) {
        int n;
        this.playerX = -1;
        this.playerY = 0;
        int n2 = 0;
        while (n2 < this.height) {
            n = 0;
            while (n < this.width) {
                if (this.field[n][n2].type == 2) {
                    this.playerX = n;
                    this.playerY = n2;
                }
                ++n;
            }
            ++n2;
        }
        if (this.playerX < 0) {
            this.field[0][0].transform(2);
            this.playerX = 0;
        }
        n2 = 0;
        while (n2 < this.height) {
            n = 1;
            while (n < this.width) {
                if (this.field[n][n2].type == 82) {
                    int n3;
                    Field field = this.field[n][n2];
                    block4: do {
                        n3 = 0;
                        while (n3 < 4) {
                            Field field2 = field.neighbor(n3);
                            if (field2.type == 86 && field2.moved == 0) {
                                field.info = n3 + 1;
                                field.moved = 1;
                                field = field.neighbor(n3);
                                continue block4;
                            }
                            ++n3;
                        }
                    } while (n3 != 4);
                }
                ++n;
            }
            ++n2;
        }
        this.initRandom(l);
    }

    private void replaceType(int n, int n2) {
        int n3 = this.height - 1;
        while (n3 >= 0) {
            int n4 = this.width - 1;
            while (n4 >= 0) {
                if (this.field[n4][n3].isType(n)) {
                    this.field[n4][n3].transform(n2);
                }
                --n4;
            }
            --n3;
        }
    }
}

