/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Vector;

class Level {
    static final String replayKey = "replay";
    private Map originalMap;
    private Map playMap;
    private Replay inReplay;
    private Replay outReplay;
    private Options options = new Options();

    Level(int n, int n2) {
        this.originalMap = new Map(this.options, n, n2);
        this.playMap = null;
    }

    Level(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream);
        this.originalMap = null;
        this.playMap = null;
        try {
            Object object;
            while ((object = scanner.next()) instanceof String) {
                Vector<Object> vector;
                String string = (String)object;
                if (string.equals("name")) {
                    scanner.expectToken('=');
                    vector = scanner.next().toString();
                    this.options.name = vector;
                } else if (string.equals("author")) {
                    scanner.expectToken('=');
                    vector = scanner.next().toString();
                    this.options.author = vector;
                } else if (string.equals("amoebaSpeed")) {
                    double d;
                    scanner.expectToken('=');
                    vector = scanner.next();
                    if (vector instanceof Double && (d = ((Double)((Object)vector)).doubleValue()) >= 0.0 && d <= 1.0) {
                        this.options.amoebaSpeed = d;
                    }
                } else if (string.equals("colors")) {
                    int n;
                    scanner.expectToken('=');
                    vector = scanner.next();
                    if (vector instanceof Double && (n = ((Double)((Object)vector)).intValue()) >= 0 && n < 10) {
                        this.options.setColors(n);
                    }
                } else if (string.equals("amoebaMaxSize")) {
                    int n;
                    scanner.expectToken('=');
                    vector = scanner.next();
                    if (vector instanceof Double && (n = ((Double)((Object)vector)).intValue()) >= 0) {
                        this.options.amoebaMaximalSize = n;
                    }
                } else if (string.equals("totalTime")) {
                    int n;
                    scanner.expectToken('=');
                    vector = scanner.next();
                    if (vector instanceof Double && (n = ((Double)((Object)vector)).intValue()) >= 1 && n < 10000) {
                        this.options.totalTime = n;
                    }
                } else if (string.equals("gemsNeeded")) {
                    int n;
                    scanner.expectToken('=');
                    vector = scanner.next();
                    if (vector instanceof Double && (n = ((Double)((Object)vector)).intValue()) >= 1 && n < 1000) {
                        this.options.gemsNeeded = n;
                    }
                } else if (string.equals("gemValue")) {
                    int n;
                    scanner.expectToken('=');
                    vector = scanner.next();
                    if (vector instanceof Double && (n = ((Double)((Object)vector)).intValue()) >= 0 && n < 1000) {
                        this.options.gemValue = n;
                    }
                } else if (string.equals("bonusGemValue")) {
                    int n;
                    scanner.expectToken('=');
                    vector = scanner.next();
                    if (vector instanceof Double && (n = ((Double)((Object)vector)).intValue()) >= 0 && n < 1000) {
                        this.options.bonusGemValue = n;
                    }
                } else if (string.equals("magicDuration")) {
                    int n;
                    scanner.expectToken('=');
                    vector = scanner.next();
                    if (vector instanceof Double && (n = ((Double)((Object)vector)).intValue()) >= 0 && n < 10000) {
                        this.options.magicDuration = n;
                    }
                } else if (string.equals("bonusLevel")) {
                    this.options.bonusLevel = true;
                } else if (string.equals("bubblePlop")) {
                    double d;
                    scanner.expectToken('=');
                    vector = scanner.next();
                    if (vector instanceof Double && (d = ((Double)((Object)vector)).doubleValue()) >= 0.0 && d <= 1.0) {
                        this.options.bubblePlop = d;
                    }
                } else if (string.equals("slimePerm")) {
                    double d;
                    scanner.expectToken('=');
                    vector = scanner.next();
                    if (vector instanceof Double && (d = ((Double)((Object)vector)).doubleValue()) >= 0.0 && d <= 1.0) {
                        this.options.slimePerm = d;
                    }
                } else if (string.equals("map")) {
                    Object object2;
                    scanner.expectToken('=');
                    scanner.expectToken('{');
                    vector = new Vector<Object>();
                    while ((object2 = scanner.next()) instanceof String && (vector.size() <= 0 || ((String)vector.elementAt(0)).length() == ((String)object2).length())) {
                        vector.addElement(object2);
                    }
                    Object[] objectArray = new String[vector.size()];
                    vector.copyInto(objectArray);
                    this.originalMap = new Map((String[])objectArray, this.options);
                } else if (string.equals(replayKey)) {
                    scanner.expectToken('=');
                    scanner.expectToken('{');
                    this.inReplay = new Replay(scanner);
                    scanner.expectToken('}');
                }
                while (!((Object)(vector = scanner.next())).toString().equals(";")) {
                }
            }
        }
        catch (Exception exception) {
            this.playMap = null;
        }
        if (this.originalMap == null) {
            this.originalMap = new Map(this.options, 40, 25);
        }
    }

    Replay getInReplay() {
        return this.inReplay;
    }

    Options getOptions() {
        return this.options;
    }

    Map getOriginalMap() {
        return this.originalMap;
    }

    Replay getOutReplay() {
        return this.outReplay;
    }

    Map getPlayMap() {
        return this.playMap;
    }

    synchronized boolean round() {
        this.playMap.playerEvent(this.inReplay, this.outReplay);
        return this.playMap.round();
    }

    void save(PrintStream printStream, boolean bl) throws Exception {
        this.options.save(printStream);
        this.originalMap.save(printStream);
        if (bl) {
            printStream.println("");
            printStream.println("replay = {");
            this.outReplay.save(printStream);
            printStream.println("};");
        }
    }

    void start() {
        int n = this.options.gemsNeeded;
        Boulderland.south.setDisplay(1, n);
        Boulderland.south.clearBombs();
        Boulderland.south.setDisplay(0, 0);
        this.outReplay = new Replay();
        this.playMap = new Map(this.originalMap);
        if (this.inReplay != null) {
            this.inReplay.expand();
            this.playMap.startReplay(this.inReplay);
        } else {
            this.playMap.startReplay(this.outReplay);
        }
        this.playMap.start();
    }
}

