/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.RGBImageFilter;

public class FrameColorFilter
extends RGBImageFilter {
    private double fr;
    private double fg;
    private double fb;
    int width;
    int height;
    int frame;
    double[] ff;

    public FrameColorFilter(int n, int n2, double d, double d2, double d3, int n3) {
        this.width = n;
        this.height = n2;
        this.fr = d;
        this.fg = d2;
        this.fb = d3;
        this.frame = n3;
        this.canFilterIndexColorModel = true;
        this.ff = new double[n3];
        try {
            double d4 = Math.sqrt((double)n3 * 2.0);
            int n4 = 0;
            while (n4 < n3) {
                this.ff[n4] = Math.sqrt((double)n4 * 2.0) / d4;
                ++n4;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public int filterRGB(int n, int n2, int n3) {
        double d = 1.0;
        int n4 = n;
        int n5 = n2;
        if (n >= this.width - this.frame) {
            n4 = this.width - n - 1;
        }
        if (n2 >= this.height - this.frame) {
            n5 = this.height - n2 - 1;
        }
        if (n4 < this.frame) {
            d = n5 < n4 ? this.ff[n5] : this.ff[n4];
        } else if (n5 < this.frame) {
            d = this.ff[n5];
        }
        int n6 = this.convert((n3 & 0xFF0000) >> 16, this.fr * (d *= (double)((n + n2) * 2) / (double)(this.width + this.height) / 2.0 + 0.7));
        int n7 = this.convert((n3 & 0xFF00) >> 8, this.fg * d);
        int n8 = this.convert(n3 & 0xFF, this.fb * d);
        int n9 = n3 >> 24 & 0xFF;
        return n9 << 24 | n6 << 16 | n7 << 8 | n8;
    }

    private int convert(int n, double d) {
        int n2 = (int)((double)n * d);
        if (n2 > 255) {
            n2 = 255;
        }
        return n2;
    }
}

