/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.List;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Vector;

public class Boulderland
extends Panel {
    public static String levelLib = "Standard";
    static BoardCanvas bc;
    public static boolean restricted;
    Image offScreen;
    public static OptionsDialog optionsDialog;
    public static Frame frame;
    static Image[] img;
    static Image[] digitImage;
    static Image scoreImage;
    static Image timeImage;
    boolean filtering = false;
    static Image allBmpsImage;
    Image[][] ci = new Image[7][89];
    boolean[] ciOk = new boolean[7];
    private Game game;
    private Level level;
    private double filterRed = 1.0;
    private double filterGreen = 1.0;
    private double filterBlue = 1.0;
    private double[][] rgbs = new double[][]{{0.7, 0.9, 0.2}, {1.2, 0.6, 0.9}, {1.1, 1.1, 0.7}, {1.0, 1.0, 1.0}};
    private static GameThread gt;
    static Thread gtc;
    static int dir;
    static boolean shift;
    static int delay;
    static Vector levelFiles;
    static Vector levelNames;
    static Vector levelAuthors;
    static Vector replayFiles;
    static Vector replayInfos;
    static boolean ctrl;
    static final int MODE_MENU = 0;
    static final int MODE_GAME = 1;
    static final int MODE_EDIT = 2;
    static final int MODE_TEST = 3;
    static final int MODE_SELECTREPLAY = 6;
    static final int MODE_PAUSE = 7;
    static int mode;
    private int oldMode;
    static NorthCanvas north;
    static SouthCanvas south;
    static int startLevel;
    static URL baseURL;
    int colorSet = -1;
    static final int fSize = 16;
    static Image oi;
    static Graphics oig;
    private int oldBaseX;
    private int oldBaseY;
    static final int EM_DRAW = 0;
    static final int EM_FLOOD = 1;
    static final int EM_RANDOM = 2;
    static int editMode;
    static int ff;
    static final int[][] cSizes;
    static int cZoom;
    static int cw;
    static int ch;
    private Image offImage;
    private Level intro;
    private List replayList;
    private Panel centerPanel;
    private Button okButton;
    private boolean[] dirDown = new boolean[4];
    static boolean saveNext;
    static int MAXDELAY;
    static boolean suicide;
    static int editTile;
    public static Applet applet;
    static Image backgroundImage;
    static Boulderland boulderland;
    static boolean forceBreak;
    static int loadIndex;
    static String loadMsg;
    static /* synthetic */ Class class$Boulderland;

    public Boulderland(URL uRL, Applet applet) {
        baseURL = uRL;
        Boulderland.applet = applet;
        this.setBackground(Color.black);
        boulderland = this;
    }

    void construct(Graphics graphics) {
        int n;
        Object object;
        this.showStatus("Starting Boulderland - please wait...");
        this.paintText(graphics, "Starting Boulderland", Color.blue, 160, 30);
        this.paintText(graphics, "Loading images (12k)...", new Color(255, 192, 128), 210, 15);
        this.loadImages();
        if (this.colorSet < 0) {
            object = this.getColorModel();
            int n2 = ((ColorModel)object).getPixelSize();
            if (n2 > 8) {
                this.filtering = true;
            } else {
                this.colorSet = 0;
            }
            if (this.filtering) {
                this.colorSet = (int)(Math.random() * 4.0);
                this.filterRed = this.rgbs[this.colorSet][0];
                this.filterGreen = this.rgbs[this.colorSet][1];
                this.filterBlue = this.rgbs[this.colorSet][2];
            }
        }
        this.offScreen = this.createImage(640, 400);
        object = this.offScreen.getGraphics();
        Image image = backgroundImage;
        int n3 = image.getWidth(this);
        int n4 = image.getHeight(this);
        int n5 = 640 / n3;
        int n6 = 400 / n4 + 1;
        int n7 = 0;
        while (n7 <= n5) {
            n = 0;
            while (n <= n6) {
                ((Graphics)object).drawImage(image, n7 * n3, n * n4, this);
                ++n;
            }
            ++n7;
        }
        if (this.filtering) {
            FrameColorFilter frameColorFilter = new FrameColorFilter(640, 400, this.filterRed, this.filterGreen, this.filterBlue, 24);
            MediaTracker mediaTracker = new MediaTracker(this);
            ImageProducer imageProducer = this.offScreen.getSource();
            this.offScreen = this.createImage(new FilteredImageSource(imageProducer, frameColorFilter));
            mediaTracker.addImage(this.offScreen, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            n = 0;
            while (n < 8) {
                float f = (float)n / 7.0f;
                ((Graphics)object).setColor(new Color((float)((double)f * this.filterRed), (float)((double)f * this.filterGreen), (float)((double)f * this.filterBlue)));
                ((Graphics)object).drawRect(n, n, 640 - n * 2, 400 - n * 2);
                ++n;
            }
        }
        graphics.drawImage(this.offScreen, 0, 24, this);
        this.paintText(graphics, "Starting Boulderland", Color.blue, 160, 30);
        this.paintText(graphics, "Loading images (12k)...", new Color(255, 192, 128), 210, 15);
        this.paintText(graphics, "Fetching level list (2k)...", Color.red, 240, 15);
        this.loadLevelList();
        this.paintText(graphics, "Fetching replay list (1k)...", Color.yellow, 270, 15);
        this.loadReplayList();
        this.paintText(graphics, "Loading intro (7k)...", Color.green, 300, 15);
        this.loadIntro();
        this.paintText(graphics, "Preparing graphics...", Color.white, 330, 15);
        oi = this.createImage(704, 384);
        oig = oi.getGraphics();
        oig.setColor(Color.black);
        oig.fillRect(0, 0, 640, 384);
        this.oicolorize();
        bc = new BoardCanvas();
        north = new NorthCanvas();
        south = new SouthCanvas();
        this.setLayout(null);
        this.add(north);
        this.add(bc);
        this.add(south);
        north.reshape(0, 0, 640, 24);
        this.zoom(cZoom);
        south.reshape(0, 424, 640, 40);
        this.requestFocus();
        this.startDemo();
    }

    static int getStartLevel() {
        return startLevel;
    }

    public boolean action(Event event, Object object) {
        int n = 0;
        while (n < 6) {
            if (event.target == Boulderland.south.zoomButton[n]) {
                this.zoom(n);
                return true;
            }
            ++n;
        }
        if (event.target == this.okButton) {
            mode = 0;
            int n2 = this.replayList.getSelectedIndex();
            this.remove(this.centerPanel);
            this.centerPanel.remove(this.replayList);
            this.centerPanel.remove(this.okButton);
            this.centerPanel = null;
            this.okButton = null;
            this.replayList = null;
            bc.show();
            String string = (String)replayFiles.elementAt(n2);
            String string2 = "replays/" + levelLib + "/" + string;
            this.goReplay(string2);
        } else if (event.target == Boulderland.north.button[2]) {
            this.cmdEdit();
        } else if (event.target == Boulderland.north.button[1]) {
            this.cmdReplay();
        } else if (event.target == Boulderland.north.button[0]) {
            this.cmdStart();
        } else if (event.target == Boulderland.north.button[3]) {
            this.cmdMenu();
        } else if (event.target == Boulderland.north.button[8]) {
            this.cmdTest();
        } else if (event.target == Boulderland.north.button[6]) {
            suicide = true;
        } else if (event.target == Boulderland.north.button[7]) {
            this.cmdOptions();
        } else if (event.target == Boulderland.north.button[4]) {
            this.cmdLoad();
        } else if (event.target == Boulderland.north.button[5]) {
            this.cmdSave(false);
        } else if (event.target == Boulderland.south.plusButton && delay < MAXDELAY) {
            delay += 5;
            south.repaint();
        } else if (event.target == Boulderland.south.minusButton && delay > 0) {
            delay -= 5;
            south.repaint();
        } else {
            return super.action(event, object);
        }
        return true;
    }

    void goReplay(String string) {
        try {
            InputStream inputStream = null;
            inputStream = applet != null ? Boulderland.getInputStream(string) : new FileInputStream(string);
            this.intro = new Level(inputStream);
            this.startDemo();
            inputStream.close();
            this.repaintAll();
            return;
        }
        catch (Exception exception) {
            Boulderland.error("Could not load replay: ", exception);
            this.repaintAll();
            this.startThread();
            return;
        }
    }

    public void paint(Graphics graphics) {
        if (graphics != null) {
            if (this.offScreen == null) {
                this.construct(graphics);
            }
            if (Boulderland.bc.size().width == this.size().width) {
                return;
            }
            graphics.drawImage(this.offScreen, 0, 24, this);
            if (loadIndex >= 0) {
                this.paintText(graphics, "Get ready for Level " + loadIndex + ":", Color.red, 220, 30);
                this.paintText(graphics, loadMsg, new Color(192, 192, 64), 270, 32);
                return;
            }
            int n = Boulderland.bc.location().x;
            int n2 = Boulderland.bc.location().y;
            int n3 = Boulderland.bc.size().width;
            int n4 = Boulderland.bc.size().height;
            int n5 = 0;
            while (n5 < 8) {
                float f = (float)n5 / 14.0f * 1.2f;
                graphics.setColor(new Color((float)((double)f * this.filterRed), (float)((double)f * this.filterGreen), (float)((double)f * this.filterBlue)));
                graphics.drawRect(n - n5 - 1, n2 - n5 - 1, n3 + n5 * 2, n4 + n5 * 2);
                ++n5;
            }
            if (cZoom < 2) {
                this.paintText(graphics, "Version 1.1", new Color(255, 192, 128), 368, 15);
            }
            if (cZoom < 4) {
                this.paintText(graphics, "Created by Holger Knublauch", new Color(192, 128, 128), 408, 15);
            }
        }
    }

    private void paintText(Graphics graphics, String string, Color color, int n, int n2) {
        Font font = new Font("Helvetica", 1, n2);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = (this.size().width - n3) / 2;
        graphics.setColor(Color.black);
        graphics.drawString(string, n4 + 1, n + 1);
        graphics.drawString(string, n4 - 1, n - 1);
        graphics.drawString(string, n4 - 1, n + 1);
        graphics.drawString(string, n4 + 1, n - 1);
        graphics.setColor(color);
        graphics.drawString(string, n4, n);
    }

    public boolean keyDown(Event event, int n) {
        Options options = this.level.getOptions();
        if (mode == 1 || mode == 3) {
            int n2 = -1;
            switch (n) {
                case 1004: {
                    n2 = 0;
                    break;
                }
                case 1005: {
                    n2 = 1;
                    break;
                }
                case 1006: {
                    n2 = 2;
                    break;
                }
                case 1007: {
                    n2 = 3;
                }
            }
            if (!(n2 < 0 || n2 == dir || (dir = n2) < 0 || dir == 0 && this.dirDown[1] || dir == 1 && this.dirDown[0] || dir == 2 && this.dirDown[2] || dir == 3 && this.dirDown[3])) {
                this.dirDown[Boulderland.dir] = true;
            }
            ctrl = (event.modifiers & 2) != 0;
            boolean bl = shift = (event.modifiers & 1) != 0;
        }
        if (n == 107 && (mode == 1 || mode == 3)) {
            suicide = true;
        } else if (n == 99 && (mode == 1 || mode == 3)) {
            bc.centerMan();
        } else if (n == 109 && (mode == 1 || mode == 2)) {
            this.cmdMenu();
        } else if (mode == 0 && n == 1005 && startLevel < levelFiles.size()) {
            ++startLevel;
            north.repaint();
        } else if (mode == 0 && n == 1004 && startLevel > 1) {
            --startLevel;
            north.repaint();
        } else if (mode == 0 && n == 1003 && startLevel < levelFiles.size() - 5) {
            startLevel += 5;
            north.repaint();
        } else if (mode == 0 && n == 1002 && startLevel > 5) {
            startLevel -= 5;
            north.repaint();
        } else if ((mode == 0 || mode == 1) && n == 1018) {
            ff = 5;
        } else if ((mode == 0 || mode == 1) && n == 1019) {
            ff = 10;
        } else if (mode == 0 && n == 32) {
            this.cmdStart();
        } else if (mode == 2 && n == 32) {
            this.cmdTest();
        } else if (!(restricted || n != 114 || mode != 1 && mode != 3)) {
            saveNext = true;
            south.setMessage("Replay active.");
        } else if (n == 112 && (mode == 1 || mode == 3 || mode == 7)) {
            this.cmdPause();
        } else if (n == 43 && delay < MAXDELAY) {
            delay += 5;
            south.repaint();
        } else if (n == 45 && delay > 0) {
            delay -= 5;
            south.repaint();
        } else if (n == 101 && mode == 0) {
            this.cmdEdit();
        } else if (n == 1014 && options.colorIndex > 0) {
            options.setColors(options.colorIndex - 1);
            this.oicolorize();
        } else if (n == 1015 && options.colorIndex < 6) {
            options.setColors(options.colorIndex + 1);
            this.oicolorize();
        } else if (n == 1008) {
            this.zoom(0);
        } else if (n == 1009) {
            this.zoom(1);
        } else if (n == 1010) {
            this.zoom(2);
        } else if (n == 1011) {
            this.zoom(3);
        } else if (n == 1012) {
            this.zoom(4);
        } else if (n == 1013) {
            this.zoom(5);
        }
        this.requestFocus();
        return super.keyDown(event, n);
    }

    void zoom(int n) {
        cZoom = n;
        cw = cSizes[cZoom][0];
        ch = cSizes[cZoom][1];
        int n2 = cw * 16;
        int n3 = ch * 16;
        int n4 = (640 - n2) / 2;
        int n5 = (400 - n3) / 2 + 24;
        bc.reshape(n4, n5, n2, n3);
        this.repaint();
    }

    public boolean keyUp(Event event, int n) {
        int n2 = -1;
        switch (n) {
            case 1004: {
                n2 = 0;
                break;
            }
            case 1005: {
                n2 = 1;
                break;
            }
            case 1006: {
                n2 = 2;
                break;
            }
            case 1007: {
                n2 = 3;
            }
        }
        if (n2 >= 0) {
            this.dirDown[n2] = false;
            if (n2 == dir) {
                int n3 = 3;
                while (n3 >= 0 && !this.dirDown[n3]) {
                    --n3;
                }
                dir = n3 >= 0 ? n3 : -1;
            }
            ctrl = (event.modifiers & 2) != 0;
            shift = (event.modifiers & 1) != 0;
        }
        return true;
    }

    void newTry() {
        Game.level.start();
        north.setLevel(Game.levelIndex, this.level.getOptions().name, this.level.getOptions().bonusLevel);
        north.setMen(--Game.lives);
    }

    void tryOver() {
        boolean bl;
        gtc = null;
        gt = null;
        System.gc();
        south.clearBombs();
        int n = mode;
        if (saveNext) {
            this.saveReplay();
            saveNext = false;
        }
        boolean bl2 = bl = Game.level.getPlayMap().getPlayerStatus() == 3;
        if (n == 3) {
            if (!saveNext) {
                Boulderland.bc.baseX = this.oldBaseX;
                Boulderland.bc.baseY = this.oldBaseY;
                bc.setMap(this.level.getOriginalMap());
                bc.resetAnimation();
                mode = 2;
                south.repaint();
                bc.repaint();
            }
        } else if (n == 0 || Game.lives < 1 && !this.level.getOptions().bonusLevel && !bl) {
            if (!saveNext) {
                if (mode == 1) {
                    north.setString("GAME OVER");
                    long l = System.currentTimeMillis();
                    while (System.currentTimeMillis() - l < 2500L) {
                    }
                }
                this.startDemo();
            } else {
                this.oldMode = 0;
            }
        } else {
            Options options = this.level.getOptions();
            if (bl || options.bonusLevel) {
                Game.nextLevel();
                this.level = Game.level;
                north.setLevel(Game.levelIndex, this.level.getOptions().name, this.level.getOptions().bonusLevel);
                oig.setColor(Color.black);
                oig.fillRect(0, 0, 640, 384);
                this.oicolorize();
            } else {
                this.newTry();
            }
            north.setMen(Game.lives);
            this.startThread();
        }
        north.repaint();
    }

    void saveReplay() {
        try {
            Level level = Game.level;
            Replay replay = level.getOutReplay();
            replay.gemsCollected = Game.level.getPlayMap().getGemCount();
            replay.timeLeft = Game.level.getPlayMap().getTimer();
            replay.escaped = Game.level.getPlayMap().getPlayerStatus() == 3;
            this.cmdSave(true);
            return;
        }
        catch (Exception exception) {
            Boulderland.error("", exception);
            return;
        }
    }

    static void error(String string, Exception exception) {
        south.setMessage(String.valueOf(string) + (exception != null ? exception.toString() : ""));
        if (exception != null) {
            exception.printStackTrace();
            return;
        }
        System.out.println("Error Msg:" + string);
    }

    public void update(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n = this.size().width;
        int n2 = this.size().height;
        if (this.offImage == null || this.offImage.getWidth(this) != n || this.offImage.getHeight(this) != n2) {
            this.offImage = this.createImage(this.size().width, this.size().height);
        }
        Graphics graphics2 = this.offImage.getGraphics();
        this.paint(graphics2);
        graphics.drawImage(this.offImage, 0, 0, this);
    }

    void repaintAll() {
        if (this.centerPanel == null) {
            bc.update(bc.getGraphics());
        }
        north.update(north.getGraphics());
        south.repaint();
    }

    static void setTimer(int n) {
        south.setDisplay(3, n);
    }

    static void updateGemCount(int n) {
        south.setDisplay(0, n);
    }

    static void updateGemsNeeded(int n) {
        south.setDisplay(1, n);
    }

    static void updateScore(int n) {
        south.setDisplay(2, n);
    }

    private void cmdLoad() {
        Frame frame = this.findFrame();
        FileDialog fileDialog = new FileDialog(frame, "Open Level...", 0);
        fileDialog.show();
        if (fileDialog.getFile() != null && fileDialog.getFile().length() > 0) {
            String string = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                this.level = new Level(fileInputStream);
                bc.setMap(this.level.getOriginalMap());
                Boulderland.bc.baseY = 0;
                Boulderland.bc.baseX = 0;
                oig.setColor(Color.black);
                oig.fillRect(0, 0, 640, 384);
                this.invalidate();
                this.validate();
                this.repaintAll();
            }
            catch (Exception exception) {
                Boulderland.error("Load error:", exception);
            }
        }
        this.requestFocus();
    }

    private void cmdSave(boolean bl) {
        Frame frame = this.findFrame();
        FileDialog fileDialog = new FileDialog(frame, bl ? "Save replay" : "Save Level...", 1);
        fileDialog.show();
        if (fileDialog.getFile() != null && fileDialog.getFile().length() > 0) {
            String string = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            if (string.endsWith(".*.*")) {
                string = string.substring(0, string.length() - 4);
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                PrintStream printStream = new PrintStream(fileOutputStream);
                this.level.save(printStream, mode == 3 || mode == 1);
                printStream.close();
            }
            catch (Exception exception) {
                Boulderland.error("Load error: ", exception);
            }
        }
        this.requestFocus();
    }

    private void cmdEdit() {
        this.endThread();
        mode = 2;
        south.clearBombs();
        this.level = new Level(40, 24);
        oig.setColor(Color.black);
        oig.fillRect(0, 0, 640, 384);
        this.oicolorize();
        Boulderland.bc.baseY = 0;
        Boulderland.bc.baseX = 0;
        bc.setMap(this.level.getOriginalMap());
        bc.resetAnimation();
        this.repaintAll();
    }

    private void cmdKill() {
        suicide = true;
    }

    private void cmdMenu() {
        if (mode == 1) {
            this.endThread();
            south.clearBombs();
        }
        mode = 0;
        this.repaintAll();
        this.startDemo();
    }

    private void cmdOptions() {
        if (optionsDialog == null) {
            Frame frame = this.findFrame();
            optionsDialog = new OptionsDialog(frame, this.level.getOptions());
            north.repaint();
            optionsDialog.show();
        }
    }

    private Frame findFrame() {
        Frame frame = Boulderland.frame;
        if (frame == null) {
            Container container = this;
            while (!((container = container.getParent()) instanceof Frame)) {
            }
            frame = (Frame)container;
        }
        return frame;
    }

    private void cmdPause() {
        if (mode != 7) {
            this.oldMode = mode;
            mode = 7;
        } else {
            mode = this.oldMode;
        }
        north.repaint();
    }

    private void cmdReplay() {
        this.endThread();
        if (restricted) {
            mode = 6;
            this.centerPanel = new Panel();
            this.centerPanel.setBackground(Color.white);
            this.centerPanel.setLayout(new BorderLayout());
            this.replayList = new List();
            this.okButton = new Button("Start replay");
            int n = 0;
            while (n < replayFiles.size()) {
                this.replayList.addItem(replayInfos.elementAt(n).toString());
                ++n;
            }
            this.replayList.select(0);
            bc.hide();
            this.centerPanel.add("Center", this.replayList);
            this.centerPanel.add("South", this.okButton);
            this.add(this.centerPanel);
            this.centerPanel.reshape(0, Boulderland.north.size().height, this.size().width, 400);
            this.centerPanel.validate();
            this.repaintAll();
            return;
        }
        Frame frame = this.findFrame();
        FileDialog fileDialog = new FileDialog(frame, "Open replay...", 0);
        fileDialog.show();
        if (fileDialog.getFile() != null && fileDialog.getFile().length() > 0) {
            String string = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            this.goReplay(string);
        }
    }

    private synchronized void cmdStart() {
        this.endThread();
        south.clearBombs();
        south.setDisplay(2, 0);
        south.setMessage("");
        mode = 1;
        this.game = new Game(baseURL);
        this.showStatus("Loading level...");
        this.setLoading(startLevel);
        Game.loadLevel(startLevel);
        this.level = Game.level;
        oig.setColor(Color.black);
        oig.fillRect(0, 0, 640, 384);
        this.oicolorize();
        this.showStatus("");
        this.setLoading(-1);
        this.newTry();
        this.startThread();
    }

    private void cmdTest() {
        this.oldBaseX = Boulderland.bc.baseX;
        this.oldBaseY = Boulderland.bc.baseY;
        mode = 3;
        this.game = new Game(baseURL, this.level);
        this.level.start();
        south.setDisplay(2, 0);
        south.repaint();
        this.oicolorize();
        Options options = this.level.getOptions();
        north.setLevel(-1, options.name, options.bonusLevel);
        north.setMen(0);
        this.startThread();
    }

    private void endThread() {
        try {
            if (gtc != null && gtc.isAlive()) {
                gtc.setPriority(5);
                forceBreak = true;
                while (forceBreak) {
                    Thread thread = Thread.currentThread();
                    if (thread == gtc) continue;
                    Thread.sleep(1L);
                }
                gtc.stop();
                gtc = null;
                System.gc();
                return;
            }
        }
        catch (Exception exception) {
            Boulderland.error("Thread exception: ", exception);
            System.out.println("Serious error: " + exception);
            exception.printStackTrace();
        }
    }

    private void loadImages() {
        MediaTracker mediaTracker = new MediaTracker(this);
        try {
            try {
                Object object;
                if (applet == null) {
                    object = Toolkit.getDefaultToolkit();
                    allBmpsImage = ((Toolkit)object).getImage(new URL(baseURL, "bitmaps.gif"));
                    backgroundImage = ((Toolkit)object).getImage(new URL(baseURL, "lightslate.gif"));
                } else {
                    object = (class$Boulderland != null ? class$Boulderland : (class$Boulderland = Boulderland.class$("Boulderland"))).getResourceAsStream("bitmaps.gif");
                    byte[] byArray = new byte[((InputStream)object).available()];
                    ((InputStream)object).read(byArray);
                    allBmpsImage = Toolkit.getDefaultToolkit().createImage(byArray);
                    object = (class$Boulderland != null ? class$Boulderland : (class$Boulderland = Boulderland.class$("Boulderland"))).getResourceAsStream("lightslate.gif");
                    byArray = new byte[((InputStream)object).available()];
                    ((InputStream)object).read(byArray);
                    backgroundImage = Toolkit.getDefaultToolkit().createImage(byArray);
                }
            }
            catch (Exception exception) {}
            mediaTracker.addImage(allBmpsImage, 1);
            mediaTracker.addImage(backgroundImage, 1);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {}
            mediaTracker = new MediaTracker(this);
            int n = 0;
            while (n < 89) {
                int n2 = n / 24;
                int n3 = n % 24;
                ImageProducer imageProducer = allBmpsImage.getSource();
                CropImageFilter cropImageFilter = new CropImageFilter(n2 * 16, n3 * 16, 16, 16);
                Boulderland.img[n] = this.createImage(new FilteredImageSource(imageProducer, cropImageFilter));
                mediaTracker.addImage(img[n], 0);
                ++n;
            }
            ImageProducer imageProducer = allBmpsImage.getSource();
            CropImageFilter cropImageFilter = new CropImageFilter(0, 384, 40, 16);
            scoreImage = this.createImage(new FilteredImageSource(imageProducer, cropImageFilter));
            mediaTracker.addImage(scoreImage, 0);
            imageProducer = allBmpsImage.getSource();
            cropImageFilter = new CropImageFilter(40, 384, 32, 16);
            timeImage = this.createImage(new FilteredImageSource(imageProducer, cropImageFilter));
            mediaTracker.addImage(timeImage, 0);
            int n4 = 0;
            while (n4 < 10) {
                imageProducer = allBmpsImage.getSource();
                cropImageFilter = new CropImageFilter(64, n4 * 16, 12, 16);
                Boulderland.digitImage[n4] = this.createImage(new FilteredImageSource(imageProducer, cropImageFilter));
                mediaTracker.addImage(digitImage[n4], 0);
                ++n4;
            }
            try {
                mediaTracker.waitForAll();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        catch (Exception exception) {
            Boulderland.error("Images error: ", exception);
            return;
        }
    }

    static InputStream getInputStream(String string) throws Exception {
        InputStream inputStream = null;
        if (!restricted) {
            inputStream = new FileInputStream(string);
        } else {
            InputStream inputStream2 = (class$Boulderland != null ? class$Boulderland : (class$Boulderland = Boulderland.class$("Boulderland"))).getResourceAsStream(string);
            byte[] byArray = new byte[inputStream2.available()];
            inputStream2.read(byArray);
            inputStream = new ByteArrayInputStream(byArray);
        }
        return inputStream;
    }

    private void loadIntro() {
        try {
            InputStream inputStream = Boulderland.getInputStream("replays/intro.blr");
            this.intro = new Level(inputStream);
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            this.intro = new Level(6, 6);
            return;
        }
    }

    private void loadLevelList() {
        try {
            InputStream inputStream = Boulderland.getInputStream("levels/" + levelLib + "/index.txt");
            Scanner scanner = new Scanner(inputStream);
            levelFiles = new Vector();
            levelNames = new Vector();
            levelAuthors = new Vector();
            try {
                while (true) {
                    String string = (String)scanner.next();
                    String string2 = (String)scanner.next();
                    String string3 = (String)scanner.next();
                    levelFiles.addElement(string);
                    levelNames.addElement(string2);
                    levelAuthors.addElement(string3);
                    scanner.expectToken(';');
                }
            }
            catch (Exception exception) {
                return;
            }
        }
        catch (Exception exception) {
            this.showStatus("Fatal: Could not fetch level list!");
            System.out.println(String.valueOf(exception));
            return;
        }
    }

    private void loadReplayList() {
        if (applet == null) {
            return;
        }
        try {
            InputStream inputStream = Boulderland.getInputStream("replays/" + levelLib + "/index.txt");
            Scanner scanner = new Scanner(inputStream);
            replayFiles = new Vector();
            replayInfos = new Vector();
            try {
                while (true) {
                    String string = (String)scanner.next();
                    String string2 = (String)scanner.next();
                    replayFiles.addElement(string);
                    replayInfos.addElement(string2);
                    scanner.expectToken(';');
                }
            }
            catch (Exception exception) {
                return;
            }
        }
        catch (Exception exception) {
            this.showStatus("Fatal: Could not fetch replay list!");
            System.out.println(String.valueOf(exception));
            return;
        }
    }

    private void oiclear() {
        oig.setColor(Color.black);
        oig.fillRect(0, 0, 640, 384);
    }

    private void oicolorize() {
        int n;
        if (this.level == null) {
            int n2 = 0;
            while (n2 < 89) {
                if (img[n2] != null) {
                    int n3 = n2 / 24;
                    int n4 = n2 % 24;
                    oig.drawImage(img[n2], (40 + n3) * 16, n4 * 16, this);
                }
                ++n2;
            }
            return;
        }
        Options options = this.level.getOptions();
        int n5 = options.colorIndex;
        if (!this.ciOk[n5]) {
            this.showStatus("Preparing graphics...");
            this.ciOk[n5] = true;
            MediaTracker mediaTracker = new MediaTracker(this);
            n = 0;
            while (n < 89) {
                if (img[n] != null) {
                    if (options.colors[n][0] != 1.0 || options.colors[n][1] != 1.0 || options.colors[n][2] != 1.0) {
                        ImageProducer imageProducer = img[n].getSource();
                        ColorFilter colorFilter = new ColorFilter(options.colors[n][0], options.colors[n][1], options.colors[n][2]);
                        this.ci[n5][n] = this.createImage(new FilteredImageSource(imageProducer, colorFilter));
                        mediaTracker.addImage(this.ci[n5][n], 0);
                    } else {
                        this.ci[n5][n] = img[n];
                    }
                }
                ++n;
            }
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {}
            this.showStatus("");
        }
        int n6 = 0;
        while (n6 < 89) {
            if (img[n6] != null) {
                n = n6 / 24;
                int n7 = n6 % 24;
                oig.drawImage(this.ci[n5][n6], (40 + n) * 16, n7 * 16, this);
            }
            ++n6;
        }
    }

    private void startDemo() {
        mode = 0;
        this.game = new Game(baseURL, this.intro);
        this.level = this.intro;
        this.intro.getInReplay().reset();
        this.oicolorize();
        oig.setColor(Color.black);
        oig.fillRect(0, 0, 640, 384);
        this.showStatus("");
        south.setDisplay(2, 0);
        --Game.lives;
        Game.level.start();
        this.startThread();
    }

    private void startThread() {
        south.setMessage("");
        bc.setMap(this.level.getPlayMap());
        gt = new GameThread(this);
        gtc = new Thread(gt);
        gtc.setPriority(1);
        gtc.start();
    }

    public void showStatus(String string) {
        if (string == null) {
            string = "";
        }
        if (applet != null) {
            applet.showStatus(string);
            return;
        }
        frame.setTitle("Boulderland" + (string.length() > 0 ? ": " + string : ""));
    }

    void setLoading(int n) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        restricted = true;
        optionsDialog = null;
        frame = null;
        img = new Image[89];
        digitImage = new Image[10];
        dir = -1;
        delay = 20;
        startLevel = 1;
        cSizes = new int[][]{{16, 12}, {20, 14}, {24, 16}, {30, 20}, {36, 22}, {40, 24}};
        cZoom = 1;
        MAXDELAY = 995;
        editTile = 11;
        loadIndex = -1;
        loadMsg = null;
    }
}

