/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;

class BoardCanvas
extends Canvas {
    int baseY;
    int baseX;
    boolean updated = false;
    private Map map;
    int round;
    int[] di = new int[89];
    boolean mouseJustClicked = false;

    BoardCanvas() {
        this.setBackground(Color.black);
        this.resetAnimation();
    }

    void resetAnimation() {
        int n = 0;
        while (n < 89) {
            this.di[n] = n;
            ++n;
        }
    }

    void setMap(Map map) {
        this.map = map;
    }

    void centerPos(int n, int n2) {
        this.baseX = n - Boulderland.cw / 2;
        this.baseY = n2 - Boulderland.ch / 2;
    }

    void click(int n, int n2, boolean bl) {
        if (Boulderland.mode != 2) {
            return;
        }
        if (n == 0 && this.baseX > 0) {
            --this.baseX;
            this.repaint();
            return;
        }
        if (n2 == 0 && this.baseY > 0) {
            --this.baseY;
            this.repaint();
            return;
        }
        if (n == Boulderland.cw - 1 && this.baseX < this.map.getWidth() - Boulderland.cw) {
            ++this.baseX;
            this.repaint();
            return;
        }
        if (n2 == Boulderland.ch - 1 && this.baseY < this.map.getHeight() - Boulderland.ch) {
            ++this.baseY;
            this.repaint();
            return;
        }
        if (n + this.baseX < this.map.getWidth() && n2 + this.baseY < this.map.getHeight() && (this.map.getField((int)(n + this.baseX), (int)(n2 + this.baseY)).type != Boulderland.editTile || Boulderland.editMode == 2)) {
            int n3 = n + this.baseX;
            int n4 = n2 + this.baseY;
            if (bl && (n3 == 0 || n3 == this.map.getWidth() - 1 || n4 == 0 || n4 == this.map.getHeight() - 1)) {
                return;
            }
            switch (Boulderland.editMode) {
                case 0: {
                    this.map.getField(n3, n4).transform(Boulderland.editTile);
                    Graphics graphics = this.getGraphics();
                    if (graphics == null) break;
                    Point point = this.getBase();
                    graphics.drawImage(Boulderland.img[Boulderland.editTile], point.x + n * 16, point.y + n2 * 16, this);
                    return;
                }
                case 1: {
                    this.map.getField(n3, n4).floodFill(Boulderland.editTile, 89);
                    this.repaint();
                    return;
                }
                case 2: {
                    int n5 = 0;
                    while (n5 < 5) {
                        int n6 = n3 + (int)(Math.random() * 10.0) - 4;
                        int n7 = n4 + (int)(Math.random() * 10.0) - 4;
                        if (n6 >= 0 && n6 < this.map.getWidth() && n7 >= 0 && n7 < this.map.getHeight()) {
                            this.map.getField(n6, n7).transform(Boulderland.editTile);
                        }
                        this.repaint();
                        ++n5;
                    }
                    return;
                }
            }
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.mouseJustClicked = true;
        this.click(n / 16, n2 / 16, false);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.mouseJustClicked) {
            this.mouseJustClicked = false;
            return true;
        }
        this.click(n / 16, n2 / 16, true);
        return true;
    }

    Point getBase() {
        int n = this.size().width;
        int n2 = this.size().height;
        int n3 = Boulderland.cw * 16;
        int n4 = Boulderland.ch * 16;
        return new Point((n - n3) / 2, (n2 - n4) / 2);
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        this.painti(Boulderland.oig);
        graphics.drawImage(Boulderland.oi, 0, 0, this);
        this.updated = true;
    }

    private void animationStep() {
        ++this.round;
        this.di[9] = 4;
        this.di[10] = 4;
        this.di[12] = 11;
        this.di[36] = 36 + this.round % 4;
        this.di[32] = 32 + this.round % 4;
        this.di[24] = 24 + this.round % 4;
        this.di[82] = 82 + this.round % 4;
        this.di[52] = 52 + this.round % 4;
        this.di[13] = 13 + this.round % 8;
        this.di[21] = 13 + this.round % 8;
        this.di[66] = 61;
        this.di[88] = 87;
        this.di[68] = 67;
        this.di[28] = 28 + this.round % 4;
        this.di[2] = this.round % 2;
        this.di[5] = this.map.getMagicStatus() == 1 ? 5 + this.round % 4 : 4;
        int n = this.di[3] = this.map.isEnough() ? this.round % 2 : 0;
        if (this.map.manWaitAnimation >= 0) {
            int n2 = this.map.manWaitCount;
            switch (this.map.manWaitAnimation) {
                case 0: {
                    this.di[69] = n2 % 2 == 0 ? 71 : 69;
                    return;
                }
                case 1: {
                    this.di[69] = n2 < 7 ? 70 : 69;
                    return;
                }
                case 2: {
                    this.di[69] = n2 == 1 ? 72 : (n2 == 2 ? 73 : (n2 == 3 ? 72 : 69));
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (this.map.manWaitCount > 0) {
            this.di[69] = 69;
            return;
        }
        this.di[69] = (this.map.manLastDir == 2 ? 74 : 78) + this.round % 4;
    }

    public void painti(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.map == null) {
            graphics.setColor(Color.blue);
            graphics.fillRect(0, 0, this.size().width, this.size().height);
            return;
        }
        int n = Boulderland.cw;
        int n2 = Boulderland.ch;
        int n3 = this.map.getWidth();
        int n4 = this.map.getHeight();
        if (Boulderland.mode != 2) {
            this.animationStep();
            if (this.baseX > 0 && this.map.getPlayerX() < this.baseX + 4) {
                --this.baseX;
            } else if (this.baseX < n3 - n && this.map.getPlayerX() > this.baseX + n - 4 - 1) {
                ++this.baseX;
            }
            if (this.baseY > 0 && this.map.getPlayerY() < this.baseY + 4) {
                --this.baseY;
            } else if (this.baseY < n4 - n2 && this.map.getPlayerY() > this.baseY + n2 - 4 - 1) {
                ++this.baseY;
            }
        }
        if (this.baseX + n > n3) {
            this.baseX = n3 - n;
        }
        if (this.baseY + n2 > n4) {
            this.baseY = n4 - n2;
        }
        if (this.baseY < 0) {
            this.baseY = 0;
        }
        if (this.baseX < 0) {
            this.baseX = 0;
        }
        if (this.baseX + n > n3) {
            n = n3 - this.baseX;
        }
        if (this.baseY + n2 > n4) {
            n2 = n4 - this.baseY;
        }
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 22;
                try {
                    n7 = this.map.getField((int)(n5 + this.baseX), (int)(n6 + this.baseY)).type;
                }
                catch (Exception exception) {}
                int n8 = this.di[n7] / 24 * 16;
                int n9 = this.di[n7] % 24 * 16;
                graphics.copyArea(640 + n8, n9, 16, 16, -640 - n8 + n5 * 16, -n9 + n6 * 16);
                ++n6;
            }
            ++n5;
        }
    }

    void centerMan() {
        if (this.map != null) {
            this.centerPos(this.map.getPlayerX(), this.map.getPlayerY());
        }
    }
}

