
  var Module = typeof Module !== 'undefined' ? Module : {};

  if (!Module.expectedDataFileDownloads) {
    Module.expectedDataFileDownloads = 0;
  }

  Module.expectedDataFileDownloads++;
  (function() {
    // When running as a pthread, FS operations are proxied to the main thread, so we don't need to
    // fetch the .data bundle on the worker
    if (Module['ENVIRONMENT_IS_PTHREAD']) return;
    var loadPackage = function(metadata) {

      var PACKAGE_PATH = '';
      if (typeof window === 'object') {
        PACKAGE_PATH = window['encodeURIComponent'](window.location.pathname.toString().substring(0, window.location.pathname.toString().lastIndexOf('/')) + '/');
      } else if (typeof process === 'undefined' && typeof location !== 'undefined') {
        // web worker
        PACKAGE_PATH = encodeURIComponent(location.pathname.toString().substring(0, location.pathname.toString().lastIndexOf('/')) + '/');
      }
      var PACKAGE_NAME = 'rocksndiamonds.data';
      var REMOTE_PACKAGE_BASE = 'rocksndiamonds.data';
      if (typeof Module['locateFilePackage'] === 'function' && !Module['locateFile']) {
        Module['locateFile'] = Module['locateFilePackage'];
        err('warning: you defined Module.locateFilePackage, that has been renamed to Module.locateFile (using your locateFilePackage for now)');
      }
      var REMOTE_PACKAGE_NAME = Module['locateFile'] ? Module['locateFile'](REMOTE_PACKAGE_BASE, '') : REMOTE_PACKAGE_BASE;

      var REMOTE_PACKAGE_SIZE = metadata['remote_package_size'];
      var PACKAGE_UUID = metadata['package_uuid'];

      function fetchRemotePackage(packageName, packageSize, callback, errback) {
        if (typeof process === 'object' && typeof process.versions === 'object' && typeof process.versions.node === 'string') {
          require('fs').readFile(packageName, function(err, contents) {
            if (err) {
              errback(err);
            } else {
              callback(contents.buffer);
            }
          });
          return;
        }
        var xhr = new XMLHttpRequest();
        xhr.open('GET', packageName, true);
        xhr.responseType = 'arraybuffer';
        xhr.onprogress = function(event) {
          var url = packageName;
          var size = packageSize;
          if (event.total) size = event.total;
          if (event.loaded) {
            if (!xhr.addedTotal) {
              xhr.addedTotal = true;
              if (!Module.dataFileDownloads) Module.dataFileDownloads = {};
              Module.dataFileDownloads[url] = {
                loaded: event.loaded,
                total: size
              };
            } else {
              Module.dataFileDownloads[url].loaded = event.loaded;
            }
            var total = 0;
            var loaded = 0;
            var num = 0;
            for (var download in Module.dataFileDownloads) {
            var data = Module.dataFileDownloads[download];
              total += data.total;
              loaded += data.loaded;
              num++;
            }
            total = Math.ceil(total * Module.expectedDataFileDownloads/num);
            if (Module['setStatus']) Module['setStatus']('Downloading data... (' + loaded + '/' + total + ')');
          } else if (!Module.dataFileDownloads) {
            if (Module['setStatus']) Module['setStatus']('Downloading data...');
          }
        };
        xhr.onerror = function(event) {
          throw new Error("NetworkError for: " + packageName);
        }
        xhr.onload = function(event) {
          if (xhr.status == 200 || xhr.status == 304 || xhr.status == 206 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            var packageData = xhr.response;
            callback(packageData);
          } else {
            throw new Error(xhr.statusText + " : " + xhr.responseURL);
          }
        };
        xhr.send(null);
      };

      function handleError(error) {
        console.error('package error:', error);
      };

      var fetchedCallback = null;
      var fetched = Module['getPreloadedPackage'] ? Module['getPreloadedPackage'](REMOTE_PACKAGE_NAME, REMOTE_PACKAGE_SIZE) : null;

      if (!fetched) fetchRemotePackage(REMOTE_PACKAGE_NAME, REMOTE_PACKAGE_SIZE, function(data) {
        if (fetchedCallback) {
          fetchedCallback(data);
          fetchedCallback = null;
        } else {
          fetched = data;
        }
      }, handleError);

    function runWithFS() {

      function assert(check, msg) {
        if (!check) throw msg + new Error().stack;
      }
Module['FS_createPath']("/", "conf", true, true);
Module['FS_createPath']("/", "docs", true, true);
Module['FS_createPath']("/docs", "credits", true, true);
Module['FS_createPath']("/docs", "editor", true, true);
Module['FS_createPath']("/docs", "elements", true, true);
Module['FS_createPath']("/docs", "program", true, true);
Module['FS_createPath']("/", "levels", true, true);
Module['FS_createPath']("/levels", "Classic_Games", true, true);
Module['FS_createPath']("/levels/Classic_Games", "classic_supaplex", true, true);
Module['FS_createPath']("/levels/Classic_Games", "classic_emerald_mine", true, true);
Module['FS_createPath']("/levels/Classic_Games", "Classic_Boulder_Dash", true, true);
Module['FS_createPath']("/levels/Classic_Games/Classic_Boulder_Dash", "classic_boulderdash_native", true, true);
Module['FS_createPath']("/levels/Classic_Games/Classic_Boulder_Dash", "classic_boulderdash", true, true);
Module['FS_createPath']("/levels/Classic_Games", "classic_sokoban", true, true);
Module['FS_createPath']("/levels/Classic_Games/classic_sokoban", "tapes", true, true);
Module['FS_createPath']("/levels", "Tutorials", true, true);
Module['FS_createPath']("/levels/Tutorials", "rnd_tutorial_ncrecc", true, true);
Module['FS_createPath']("/levels/Tutorials/rnd_tutorial_ncrecc", "tapes", true, true);
Module['FS_createPath']("/levels/Tutorials/rnd_tutorial_ncrecc", "graphics", true, true);
Module['FS_createPath']("/levels/Tutorials", "rnd_tutorial_niko_boehm", true, true);
Module['FS_createPath']("/levels/Tutorials/rnd_tutorial_niko_boehm", "tapes", true, true);
Module['FS_createPath']("/levels/Tutorials", "rnd_tutorial_aaron_davidson", true, true);
Module['FS_createPath']("/levels/Tutorials/rnd_tutorial_aaron_davidson", "tapes", true, true);
Module['FS_createPath']("/", "graphics", true, true);
Module['FS_createPath']("/graphics", "gfx_classic", true, true);
Module['FS_createPath']("/graphics/gfx_classic", "joystick", true, true);
Module['FS_createPath']("/graphics/gfx_classic", "icons", true, true);
Module['FS_createPath']("/", "sounds", true, true);
Module['FS_createPath']("/sounds", "snd_classic", true, true);
Module['FS_createPath']("/", "music", true, true);
Module['FS_createPath']("/music", "mus_classic", true, true);

      /** @constructor */
      function DataRequest(start, end, audio) {
        this.start = start;
        this.end = end;
        this.audio = audio;
      }
      DataRequest.prototype = {
        requests: {},
        open: function(mode, name) {
          this.name = name;
          this.requests[name] = this;
          Module['addRunDependency']('fp ' + this.name);
        },
        send: function() {},
        onload: function() {
          var byteArray = this.byteArray.subarray(this.start, this.end);
          this.finish(byteArray);
        },
        finish: function(byteArray) {
          var that = this;
          // canOwn this data in the filesystem, it is a slide into the heap that will never change
          Module['FS_createDataFile'](this.name, null, byteArray, true, true, true);
          Module['removeRunDependency']('fp ' + that.name);
          this.requests[this.name] = null;
        }
      };

      var files = metadata['files'];
      for (var i = 0; i < files.length; ++i) {
        new DataRequest(files[i]['start'], files[i]['end'], files[i]['audio'] || 0).open('GET', files[i]['filename']);
      }

      function processPackageData(arrayBuffer) {
        assert(arrayBuffer, 'Loading data file failed.');
        assert(arrayBuffer instanceof ArrayBuffer, 'bad input to processPackageData');
        var byteArray = new Uint8Array(arrayBuffer);
        var curr;
        // Reuse the bytearray from the XHR as the source for file reads.
          DataRequest.prototype.byteArray = byteArray;
          var files = metadata['files'];
          for (var i = 0; i < files.length; ++i) {
            DataRequest.prototype.requests[files[i].filename].onload();
          }          Module['removeRunDependency']('datafile_rocksndiamonds.data');

      };
      Module['addRunDependency']('datafile_rocksndiamonds.data');

      if (!Module.preloadResults) Module.preloadResults = {};

      Module.preloadResults[PACKAGE_NAME] = {fromCache: false};
      if (fetched) {
        processPackageData(fetched);
        fetched = null;
      } else {
        fetchedCallback = processPackageData;
      }

    }
    if (Module['calledRun']) {
      runWithFS();
    } else {
      if (!Module['preRun']) Module['preRun'] = [];
      Module["preRun"].push(runWithFS); // FS is not initialized yet, wait for it
    }

    }
    loadPackage({"files": [{"filename": "/conf/gamecontrollerdb.txt", "start": 0, "end": 47586}, {"filename": "/docs/credits/credits_8.txt", "start": 47586, "end": 47913}, {"filename": "/docs/credits/credits_1.txt", "start": 47913, "end": 48196}, {"filename": "/docs/credits/credits_2.txt", "start": 48196, "end": 48485}, {"filename": "/docs/credits/credits_5.txt", "start": 48485, "end": 48697}, {"filename": "/docs/credits/credits_9.txt", "start": 48697, "end": 49002}, {"filename": "/docs/credits/credits_3.txt", "start": 49002, "end": 49302}, {"filename": "/docs/credits/credits_7.txt", "start": 49302, "end": 49727}, {"filename": "/docs/credits/credits_6.txt", "start": 49727, "end": 50037}, {"filename": "/docs/credits/credits_4.txt", "start": 50037, "end": 50319}, {"filename": "/docs/credits/credits_10.txt", "start": 50319, "end": 50454}, {"filename": "/docs/editor/editor_1.txt", "start": 50454, "end": 54415}, {"filename": "/docs/elements/mm_steel_block.txt", "start": 54415, "end": 54500}, {"filename": "/docs/elements/bdx_bomb.txt", "start": 54500, "end": 54664}, {"filename": "/docs/elements/df_mirror_fixed.txt", "start": 54664, "end": 54731}, {"filename": "/docs/elements/bdx_rock.txt", "start": 54731, "end": 54907}, {"filename": "/docs/elements/mm_wooden_wall.txt", "start": 54907, "end": 54945}, {"filename": "/docs/elements/sp_port_any.txt", "start": 54945, "end": 54989}, {"filename": "/docs/elements/bdx_steelwall_sloped.txt", "start": 54989, "end": 55103}, {"filename": "/docs/elements/emc_lenses.txt", "start": 55103, "end": 55195}, {"filename": "/docs/elements/bdx_biter_switch.txt", "start": 55195, "end": 55237}, {"filename": "/docs/elements/wall.txt", "start": 55237, "end": 55295}, {"filename": "/docs/elements/bdx_trapped_diamond.txt", "start": 55295, "end": 55403}, {"filename": "/docs/elements/exit_open.txt", "start": 55403, "end": 55688}, {"filename": "/docs/elements/quicksand_fast_full.txt", "start": 55688, "end": 55801}, {"filename": "/docs/elements/empty_space.txt", "start": 55801, "end": 55866}, {"filename": "/docs/elements/trap.txt", "start": 55866, "end": 56018}, {"filename": "/docs/elements/sp_hardware_red.txt", "start": 56018, "end": 56087}, {"filename": "/docs/elements/bdx_exit.txt", "start": 56087, "end": 56360}, {"filename": "/docs/elements/amoeba_to_diamond.txt", "start": 56360, "end": 56441}, {"filename": "/docs/elements/emc_magic_ball.txt", "start": 56441, "end": 56796}, {"filename": "/docs/elements/dragon.txt", "start": 56796, "end": 57112}, {"filename": "/docs/elements/arrow_down.txt", "start": 57112, "end": 57196}, {"filename": "/docs/elements/sp_zonk.txt", "start": 57196, "end": 57327}, {"filename": "/docs/elements/acid.txt", "start": 57327, "end": 57594}, {"filename": "/docs/elements/emc_gate_6.txt", "start": 57594, "end": 57882}, {"filename": "/docs/elements/expandable_wall_any.txt", "start": 57882, "end": 58057}, {"filename": "/docs/elements/key_2.txt", "start": 58057, "end": 58230}, {"filename": "/docs/elements/sp_gravity_off_port.txt", "start": 58230, "end": 58331}, {"filename": "/docs/elements/mm_lightball.txt", "start": 58331, "end": 58381}, {"filename": "/docs/elements/em_gate_4_gray.txt", "start": 58381, "end": 58778}, {"filename": "/docs/elements/em_gate_2_gray.txt", "start": 58778, "end": 59175}, {"filename": "/docs/elements/player_2.txt", "start": 59175, "end": 59193}, {"filename": "/docs/elements/black_orb.txt", "start": 59193, "end": 59366}, {"filename": "/docs/elements/balloon_switch_down.txt", "start": 59366, "end": 59535}, {"filename": "/docs/elements/bdx_amoeba_1.txt", "start": 59535, "end": 59871}, {"filename": "/docs/elements/dark_yamyam.txt", "start": 59871, "end": 60018}, {"filename": "/docs/elements/bdx_player_glued.txt", "start": 60018, "end": 60116}, {"filename": "/docs/elements/unused.txt", "start": 60116, "end": 60132}, {"filename": "/docs/elements/bug.txt", "start": 60132, "end": 60325}, {"filename": "/docs/elements/bomb.txt", "start": 60325, "end": 60456}, {"filename": "/docs/elements/sp_murphy.txt", "start": 60456, "end": 60569}, {"filename": "/docs/elements/bdx_conveyor.txt", "start": 60569, "end": 60627}, {"filename": "/docs/elements/df_fibre_optic.txt", "start": 60627, "end": 60708}, {"filename": "/docs/elements/spring.txt", "start": 60708, "end": 60849}, {"filename": "/docs/elements/sp_chip_top.txt", "start": 60849, "end": 60896}, {"filename": "/docs/elements/char_space.txt", "start": 60896, "end": 61110}, {"filename": "/docs/elements/mm_envelope.txt", "start": 61110, "end": 61238}, {"filename": "/docs/elements/emc_key_8.txt", "start": 61238, "end": 61319}, {"filename": "/docs/elements/em_gate_1_gray.txt", "start": 61319, "end": 61716}, {"filename": "/docs/elements/penguin.txt", "start": 61716, "end": 62050}, {"filename": "/docs/elements/quicksand_empty.txt", "start": 62050, "end": 62252}, {"filename": "/docs/elements/conveyor_belt.txt", "start": 62252, "end": 62479}, {"filename": "/docs/elements/sp_base.txt", "start": 62479, "end": 62573}, {"filename": "/docs/elements/bdx_conveyor_dir_switch.txt", "start": 62573, "end": 62641}, {"filename": "/docs/elements/bdx_conveyor_switch.txt", "start": 62641, "end": 62689}, {"filename": "/docs/elements/bd_amoeba.txt", "start": 62689, "end": 63045}, {"filename": "/docs/elements/bdx_gravestone.txt", "start": 63045, "end": 63092}, {"filename": "/docs/elements/df_steel_grid_fixed.txt", "start": 63092, "end": 63196}, {"filename": "/docs/elements/df_slope.txt", "start": 63196, "end": 63256}, {"filename": "/docs/elements/em_gate_4.txt", "start": 63256, "end": 63544}, {"filename": "/docs/elements/bd_expandable_wall.txt", "start": 63544, "end": 63892}, {"filename": "/docs/elements/landmine.txt", "start": 63892, "end": 64017}, {"filename": "/docs/elements/gate_1.txt", "start": 64017, "end": 64082}, {"filename": "/docs/elements/expandable_wall_vertical.txt", "start": 64082, "end": 64297}, {"filename": "/docs/elements/df_wooden_grid_rotating.txt", "start": 64297, "end": 64406}, {"filename": "/docs/elements/mm_steel_wall.txt", "start": 64406, "end": 64444}, {"filename": "/docs/elements/arrow_right.txt", "start": 64444, "end": 64528}, {"filename": "/docs/elements/bdx_gate.txt", "start": 64528, "end": 64598}, {"filename": "/docs/elements/timegate_open.txt", "start": 64598, "end": 64656}, {"filename": "/docs/elements/nut.txt", "start": 64656, "end": 64737}, {"filename": "/docs/elements/dynabomb_increase_power.txt", "start": 64737, "end": 65186}, {"filename": "/docs/elements/sp_disk_orange.txt", "start": 65186, "end": 65254}, {"filename": "/docs/elements/bdx_wall_key.txt", "start": 65254, "end": 65339}, {"filename": "/docs/elements/crystal.txt", "start": 65339, "end": 65404}, {"filename": "/docs/elements/bdx_bubble.txt", "start": 65404, "end": 65543}, {"filename": "/docs/elements/key_4.txt", "start": 65543, "end": 65716}, {"filename": "/docs/elements/balloon_switch_any.txt", "start": 65716, "end": 66109}, {"filename": "/docs/elements/emc_gate_8_gray.txt", "start": 66109, "end": 66506}, {"filename": "/docs/elements/bdx_nut.txt", "start": 66506, "end": 66587}, {"filename": "/docs/elements/bdx_wall_diggable.txt", "start": 66587, "end": 66637}, {"filename": "/docs/elements/df_laser.txt", "start": 66637, "end": 66741}, {"filename": "/docs/elements/bdx_acid.txt", "start": 66741, "end": 66888}, {"filename": "/docs/elements/current_ce_value.txt", "start": 66888, "end": 67117}, {"filename": "/docs/elements/mm_steel_lock.txt", "start": 67117, "end": 67237}, {"filename": "/docs/elements/mm_bomb.txt", "start": 67237, "end": 67324}, {"filename": "/docs/elements/bdx_magic_wall.txt", "start": 67324, "end": 67776}, {"filename": "/docs/elements/arrow_left.txt", "start": 67776, "end": 67860}, {"filename": "/docs/elements/player_3.txt", "start": 67860, "end": 67878}, {"filename": "/docs/elements/bdx_chasing_rock.txt", "start": 67878, "end": 68171}, {"filename": "/docs/elements/game_of_life.txt", "start": 68171, "end": 68541}, {"filename": "/docs/elements/sp_chip_left.txt", "start": 68541, "end": 68588}, {"filename": "/docs/elements/trigger_element.txt", "start": 68588, "end": 68749}, {"filename": "/docs/elements/acid_pool_bottomright.txt", "start": 68749, "end": 68829}, {"filename": "/docs/elements/amoeba_dead.txt", "start": 68829, "end": 68974}, {"filename": "/docs/elements/mm_prism.txt", "start": 68974, "end": 69050}, {"filename": "/docs/elements/wall_emerald_yellow.txt", "start": 69050, "end": 69171}, {"filename": "/docs/elements/timegate_closed.txt", "start": 69171, "end": 69212}, {"filename": "/docs/elements/bdx_rocket.txt", "start": 69212, "end": 69266}, {"filename": "/docs/elements/satellite.txt", "start": 69266, "end": 69645}, {"filename": "/docs/elements/sp_gravity_on_port.txt", "start": 69645, "end": 69745}, {"filename": "/docs/elements/dc_landmine.txt", "start": 69745, "end": 69921}, {"filename": "/docs/elements/char.txt", "start": 69921, "end": 69990}, {"filename": "/docs/elements/df_mine.txt", "start": 69990, "end": 70054}, {"filename": "/docs/elements/prev_ce.txt", "start": 70054, "end": 70237}, {"filename": "/docs/elements/df_steel_grid_rotating.txt", "start": 70237, "end": 70345}, {"filename": "/docs/elements/emc_magic_ball_switch.txt", "start": 70345, "end": 70408}, {"filename": "/docs/elements/mm_mcduffin.txt", "start": 70408, "end": 70576}, {"filename": "/docs/elements/steel_exit_closed.txt", "start": 70576, "end": 70827}, {"filename": "/docs/elements/gate_2_gray.txt", "start": 70827, "end": 70935}, {"filename": "/docs/elements/bdx_grass_ball.txt", "start": 70935, "end": 71005}, {"filename": "/docs/elements/bdx_sand.txt", "start": 71005, "end": 71079}, {"filename": "/docs/elements/gate_4.txt", "start": 71079, "end": 71144}, {"filename": "/docs/elements/balloon_switch_up.txt", "start": 71144, "end": 71313}, {"filename": "/docs/elements/key_3.txt", "start": 71313, "end": 71486}, {"filename": "/docs/elements/bdx_dragonfly.txt", "start": 71486, "end": 71762}, {"filename": "/docs/elements/sp_exit_closed.txt", "start": 71762, "end": 71890}, {"filename": "/docs/elements/balloon_switch_right.txt", "start": 71890, "end": 72059}, {"filename": "/docs/elements/bdx_steelwall_diggable.txt", "start": 72059, "end": 72115}, {"filename": "/docs/elements/sokoban_object.txt", "start": 72115, "end": 72285}, {"filename": "/docs/elements/timegate_switch.txt", "start": 72285, "end": 72415}, {"filename": "/docs/elements/dc_magic_wall.txt", "start": 72415, "end": 72936}, {"filename": "/docs/elements/em_steel_exit_open.txt", "start": 72936, "end": 73325}, {"filename": "/docs/elements/bdx_replicator_switch.txt", "start": 73325, "end": 73362}, {"filename": "/docs/elements/bdx_invisible_exit.txt", "start": 73362, "end": 73443}, {"filename": "/docs/elements/df_wooden_wall.txt", "start": 73443, "end": 73479}, {"filename": "/docs/elements/emc_gate_7.txt", "start": 73479, "end": 73767}, {"filename": "/docs/elements/bdx_wall_sloped_down_left.txt", "start": 73767, "end": 73899}, {"filename": "/docs/elements/balloon_switch_left.txt", "start": 73899, "end": 74068}, {"filename": "/docs/elements/df_steel_wall.txt", "start": 74068, "end": 74104}, {"filename": "/docs/elements/bd_wall.txt", "start": 74104, "end": 74276}, {"filename": "/docs/elements/bdx_pot.txt", "start": 74276, "end": 74512}, {"filename": "/docs/elements/acid_pool_topright.txt", "start": 74512, "end": 74592}, {"filename": "/docs/elements/frankie.txt", "start": 74592, "end": 74702}, {"filename": "/docs/elements/bdx_grass_loose.txt", "start": 74702, "end": 74773}, {"filename": "/docs/elements/mm_mirror.txt", "start": 74773, "end": 74920}, {"filename": "/docs/elements/shield_normal.txt", "start": 74920, "end": 75084}, {"filename": "/docs/elements/time_orb_full.txt", "start": 75084, "end": 75289}, {"filename": "/docs/elements/bdx_unused.txt", "start": 75289, "end": 75308}, {"filename": "/docs/elements/bdx_cow.txt", "start": 75308, "end": 75427}, {"filename": "/docs/elements/dc_gate_white_gray.txt", "start": 75427, "end": 75535}, {"filename": "/docs/elements/bdx_sweet.txt", "start": 75535, "end": 75663}, {"filename": "/docs/elements/bdx_diamond.txt", "start": 75663, "end": 75734}, {"filename": "/docs/elements/expandable_wall.txt", "start": 75734, "end": 76082}, {"filename": "/docs/elements/bd_firefly.txt", "start": 76082, "end": 76250}, {"filename": "/docs/elements/dynabomb_increase_size.txt", "start": 76250, "end": 76660}, {"filename": "/docs/elements/bdx_gravity_switch.txt", "start": 76660, "end": 76898}, {"filename": "/docs/elements/wall_crystal.txt", "start": 76898, "end": 77012}, {"filename": "/docs/elements/df_mirror_rotating.txt", "start": 77012, "end": 77111}, {"filename": "/docs/elements/bdx_pneumatic_hammer.txt", "start": 77111, "end": 77434}, {"filename": "/docs/elements/wall_emerald_purple.txt", "start": 77434, "end": 77555}, {"filename": "/docs/elements/balloon_switch_none.txt", "start": 77555, "end": 77725}, {"filename": "/docs/elements/em_key_4.txt", "start": 77725, "end": 77806}, {"filename": "/docs/elements/sp_hardware_base_2.txt", "start": 77806, "end": 77875}, {"filename": "/docs/elements/yamyam.txt", "start": 77875, "end": 78270}, {"filename": "/docs/elements/bdx_steel_exit.txt", "start": 78270, "end": 78483}, {"filename": "/docs/elements/diamond.txt", "start": 78483, "end": 78561}, {"filename": "/docs/elements/lamp.txt", "start": 78561, "end": 78707}, {"filename": "/docs/elements/exit_closed.txt", "start": 78707, "end": 78907}, {"filename": "/docs/elements/dc_gate_white.txt", "start": 78907, "end": 79048}, {"filename": "/docs/elements/sp_chip_right.txt", "start": 79048, "end": 79095}, {"filename": "/docs/elements/bdx_light_rock.txt", "start": 79095, "end": 79179}, {"filename": "/docs/elements/any_element.txt", "start": 79179, "end": 79255}, {"filename": "/docs/elements/steelwall_slippery.txt", "start": 79255, "end": 79294}, {"filename": "/docs/elements/mm_steel_grid_fixed.txt", "start": 79294, "end": 79398}, {"filename": "/docs/elements/speed_pill.txt", "start": 79398, "end": 79487}, {"filename": "/docs/elements/stoneblock.txt", "start": 79487, "end": 79545}, {"filename": "/docs/elements/bdx_sand_glued.txt", "start": 79545, "end": 79589}, {"filename": "/docs/elements/conveyor_belt_switch.txt", "start": 79589, "end": 79802}, {"filename": "/docs/elements/mm_wooden_lock.txt", "start": 79802, "end": 79927}, {"filename": "/docs/elements/bdx_wall_sloped.txt", "start": 79927, "end": 80035}, {"filename": "/docs/elements/emc_fake_grass.txt", "start": 80035, "end": 80187}, {"filename": "/docs/elements/switchgate.txt", "start": 80187, "end": 80357}, {"filename": "/docs/elements/rock.txt", "start": 80357, "end": 80518}, {"filename": "/docs/elements/mm_polarizer_cross.txt", "start": 80518, "end": 80615}, {"filename": "/docs/elements/bdx_trapped_bubble.txt", "start": 80615, "end": 80737}, {"filename": "/docs/elements/sign.txt", "start": 80737, "end": 80774}, {"filename": "/docs/elements/sp_infotron.txt", "start": 80774, "end": 80814}, {"filename": "/docs/elements/switchgate_switch.txt", "start": 80814, "end": 80964}, {"filename": "/docs/elements/emc_android.txt", "start": 80964, "end": 81111}, {"filename": "/docs/elements/bdx_box.txt", "start": 81111, "end": 81293}, {"filename": "/docs/elements/df_mirror.txt", "start": 81293, "end": 81382}, {"filename": "/docs/elements/sokoban_field_empty.txt", "start": 81382, "end": 81719}, {"filename": "/docs/elements/bdx_flying_diamond.txt", "start": 81719, "end": 81809}, {"filename": "/docs/elements/emc_gate_5_gray.txt", "start": 81809, "end": 82206}, {"filename": "/docs/elements/bdx_biter.txt", "start": 82206, "end": 82489}, {"filename": "/docs/elements/steel_exit_open.txt", "start": 82489, "end": 82825}, {"filename": "/docs/elements/dc_gate_fake_gray.txt", "start": 82825, "end": 82998}, {"filename": "/docs/elements/bdx_voodoo_doll.txt", "start": 82998, "end": 83422}, {"filename": "/docs/elements/sand.txt", "start": 83422, "end": 83590}, {"filename": "/docs/elements/sp_chip_bottom.txt", "start": 83590, "end": 83637}, {"filename": "/docs/elements/emc_gate_7_gray.txt", "start": 83637, "end": 84034}, {"filename": "/docs/elements/df_receiver.txt", "start": 84034, "end": 84152}, {"filename": "/docs/elements/sp_port.txt", "start": 84152, "end": 84211}, {"filename": "/docs/elements/bdx_steelwall.txt", "start": 84211, "end": 84276}, {"filename": "/docs/elements/em_exit_open.txt", "start": 84276, "end": 84622}, {"filename": "/docs/elements/spaceship.txt", "start": 84622, "end": 84778}, {"filename": "/docs/elements/shield_deadly.txt", "start": 84778, "end": 85158}, {"filename": "/docs/elements/bdx_butterfly.txt", "start": 85158, "end": 85521}, {"filename": "/docs/elements/sp_hardware_yellow.txt", "start": 85521, "end": 85590}, {"filename": "/docs/elements/pacman.txt", "start": 85590, "end": 85684}, {"filename": "/docs/elements/group.txt", "start": 85684, "end": 85986}, {"filename": "/docs/elements/steelwall.txt", "start": 85986, "end": 86055}, {"filename": "/docs/elements/emc_gate_6_gray.txt", "start": 86055, "end": 86452}, {"filename": "/docs/elements/bdx_covered.txt", "start": 86452, "end": 86466}, {"filename": "/docs/elements/bdx_expandable_steelwall.txt", "start": 86466, "end": 86530}, {"filename": "/docs/elements/mole.txt", "start": 86530, "end": 86789}, {"filename": "/docs/elements/lamp.active.txt", "start": 86789, "end": 86895}, {"filename": "/docs/elements/df_refractor.txt", "start": 86895, "end": 86956}, {"filename": "/docs/elements/bdx_flying_rock.txt", "start": 86956, "end": 87046}, {"filename": "/docs/elements/mm_mirror_fixed.txt", "start": 87046, "end": 87149}, {"filename": "/docs/elements/mm_teleporter.txt", "start": 87149, "end": 87224}, {"filename": "/docs/elements/mm_pacman.txt", "start": 87224, "end": 87298}, {"filename": "/docs/elements/sp_buggy_base.txt", "start": 87298, "end": 87368}, {"filename": "/docs/elements/pearl.txt", "start": 87368, "end": 87550}, {"filename": "/docs/elements/pig.txt", "start": 87550, "end": 87762}, {"filename": "/docs/elements/bd_rock.txt", "start": 87762, "end": 87874}, {"filename": "/docs/elements/mm_gray_ball.txt", "start": 87874, "end": 87972}, {"filename": "/docs/elements/amoeba_dry.txt", "start": 87972, "end": 88305}, {"filename": "/docs/elements/bdx_wall_non_sloped.txt", "start": 88305, "end": 88451}, {"filename": "/docs/elements/bdx_teleporter.txt", "start": 88451, "end": 88624}, {"filename": "/docs/elements/bdx_expanding_wall_switch.txt", "start": 88624, "end": 88696}, {"filename": "/docs/elements/em_exit_closed.txt", "start": 88696, "end": 88896}, {"filename": "/docs/elements/dx_supabomb.txt", "start": 88896, "end": 88958}, {"filename": "/docs/elements/bdx_expandable_wall.txt", "start": 88958, "end": 89136}, {"filename": "/docs/elements/bdx_rocket_launcher.txt", "start": 89136, "end": 89318}, {"filename": "/docs/elements/sp_hardware_base_1.txt", "start": 89318, "end": 89387}, {"filename": "/docs/elements/robot_wheel.txt", "start": 89387, "end": 89740}, {"filename": "/docs/elements/bdx_amoeba_2.txt", "start": 89740, "end": 89893}, {"filename": "/docs/elements/time_orb_empty.txt", "start": 89893, "end": 89953}, {"filename": "/docs/elements/bdx_nitro_pack.txt", "start": 89953, "end": 90120}, {"filename": "/docs/elements/envelope.txt", "start": 90120, "end": 90248}, {"filename": "/docs/elements/bdx_wall_sloped_down_right.txt", "start": 90248, "end": 90382}, {"filename": "/docs/elements/bdx_rock_glued.txt", "start": 90382, "end": 90428}, {"filename": "/docs/elements/expandable_wall_horizontal.txt", "start": 90428, "end": 90633}, {"filename": "/docs/elements/magic_wall.txt", "start": 90633, "end": 91107}, {"filename": "/docs/elements/bdx_replicator.txt", "start": 91107, "end": 91329}, {"filename": "/docs/elements/trigger_player.txt", "start": 91329, "end": 91488}, {"filename": "/docs/elements/bdx_falling_wall.txt", "start": 91488, "end": 91695}, {"filename": "/docs/elements/amoeba_wet.txt", "start": 91695, "end": 91967}, {"filename": "/docs/elements/bd_diamond.txt", "start": 91967, "end": 92065}, {"filename": "/docs/elements/sp_hardware_blue.txt", "start": 92065, "end": 92134}, {"filename": "/docs/elements/emc_gate_5.txt", "start": 92134, "end": 92422}, {"filename": "/docs/elements/bdx_slime.txt", "start": 92422, "end": 92522}, {"filename": "/docs/elements/bdx_skeleton.txt", "start": 92522, "end": 92666}, {"filename": "/docs/elements/em_key_3.txt", "start": 92666, "end": 92747}, {"filename": "/docs/elements/quicksand_fast_empty.txt", "start": 92747, "end": 92949}, {"filename": "/docs/elements/bdx_diamond_glued.txt", "start": 92949, "end": 93022}, {"filename": "/docs/elements/key_1.txt", "start": 93022, "end": 93195}, {"filename": "/docs/elements/amoeba_drop.txt", "start": 93195, "end": 93314}, {"filename": "/docs/elements/wall_diamond.txt", "start": 93314, "end": 93428}, {"filename": "/docs/elements/wall_slippery.txt", "start": 93428, "end": 93524}, {"filename": "/docs/elements/sp_terminal.txt", "start": 93524, "end": 93640}, {"filename": "/docs/elements/light_switch.active.txt", "start": 93640, "end": 93711}, {"filename": "/docs/elements/bdx_inbox.txt", "start": 93711, "end": 93751}, {"filename": "/docs/elements/current_ce_score.txt", "start": 93751, "end": 93980}, {"filename": "/docs/elements/bdx_wall_sloped_up_left.txt", "start": 93980, "end": 94105}, {"filename": "/docs/elements/steel_char.txt", "start": 94105, "end": 94186}, {"filename": "/docs/elements/bdx_firefly.txt", "start": 94186, "end": 94548}, {"filename": "/docs/elements/bdx_creature_switch.txt", "start": 94548, "end": 94671}, {"filename": "/docs/elements/bdx_amoeba.txt", "start": 94671, "end": 94978}, {"filename": "/docs/elements/balloon.txt", "start": 94978, "end": 95102}, {"filename": "/docs/elements/bdx_wall_diamond.txt", "start": 95102, "end": 95181}, {"filename": "/docs/elements/mm_lightbulb.txt", "start": 95181, "end": 95243}, {"filename": "/docs/elements/emc_spring_bumper.txt", "start": 95243, "end": 95329}, {"filename": "/docs/elements/trigger_ce_score.txt", "start": 95329, "end": 95592}, {"filename": "/docs/elements/bdx_invisible_steel_exit.txt", "start": 95592, "end": 95678}, {"filename": "/docs/elements/light_switch.txt", "start": 95678, "end": 95841}, {"filename": "/docs/elements/emc_key_7.txt", "start": 95841, "end": 95922}, {"filename": "/docs/elements/mm_fuse.txt", "start": 95922, "end": 96112}, {"filename": "/docs/elements/dynamite.active.txt", "start": 96112, "end": 96179}, {"filename": "/docs/elements/player_4.txt", "start": 96179, "end": 96197}, {"filename": "/docs/elements/invisible_sand.txt", "start": 96197, "end": 96337}, {"filename": "/docs/elements/player_1.txt", "start": 96337, "end": 96461}, {"filename": "/docs/elements/bdx_key.txt", "start": 96461, "end": 96611}, {"filename": "/docs/elements/bdx_ghost.txt", "start": 96611, "end": 96729}, {"filename": "/docs/elements/acid_pool_bottomleft.txt", "start": 96729, "end": 96809}, {"filename": "/docs/elements/emc_grass.txt", "start": 96809, "end": 96845}, {"filename": "/docs/elements/sp_port_horizontal.txt", "start": 96845, "end": 96871}, {"filename": "/docs/elements/sp_disk_yellow.txt", "start": 96871, "end": 97039}, {"filename": "/docs/elements/gate_1_gray.txt", "start": 97039, "end": 97147}, {"filename": "/docs/elements/dynamite.txt", "start": 97147, "end": 97308}, {"filename": "/docs/elements/mm_key.txt", "start": 97308, "end": 97392}, {"filename": "/docs/elements/bdx_grass.txt", "start": 97392, "end": 97477}, {"filename": "/docs/elements/emc_fake_acid.txt", "start": 97477, "end": 97540}, {"filename": "/docs/elements/tube.txt", "start": 97540, "end": 97666}, {"filename": "/docs/elements/biomaze.txt", "start": 97666, "end": 97868}, {"filename": "/docs/elements/bdx_heavy_rock.txt", "start": 97868, "end": 97941}, {"filename": "/docs/elements/bdx_fake_bonus.txt", "start": 97941, "end": 97953}, {"filename": "/docs/elements/self.txt", "start": 97953, "end": 98196}, {"filename": "/docs/elements/emc_key_5.txt", "start": 98196, "end": 98277}, {"filename": "/docs/elements/sp_hardware_base_5.txt", "start": 98277, "end": 98346}, {"filename": "/docs/elements/mm_wooden_block.txt", "start": 98346, "end": 98436}, {"filename": "/docs/elements/mm_amoeba_wall.txt", "start": 98436, "end": 98514}, {"filename": "/docs/elements/sp_hardware_gray.txt", "start": 98514, "end": 98583}, {"filename": "/docs/elements/mm_ice_wall.txt", "start": 98583, "end": 98629}, {"filename": "/docs/elements/gate_4_gray.txt", "start": 98629, "end": 98737}, {"filename": "/docs/elements/acid_pool_bottom.txt", "start": 98737, "end": 98817}, {"filename": "/docs/elements/sp_disk_red.txt", "start": 98817, "end": 98851}, {"filename": "/docs/elements/mm_wooden_grid_fixed.txt", "start": 98851, "end": 98960}, {"filename": "/docs/elements/unknown.txt", "start": 98960, "end": 98977}, {"filename": "/docs/elements/bd_butterfly.txt", "start": 98977, "end": 99255}, {"filename": "/docs/elements/sp_hardware_base_6.txt", "start": 99255, "end": 99324}, {"filename": "/docs/elements/gate_3_gray.txt", "start": 99324, "end": 99432}, {"filename": "/docs/elements/bdx_lava.txt", "start": 99432, "end": 99543}, {"filename": "/docs/elements/bdx_diamond_key.txt", "start": 99543, "end": 99617}, {"filename": "/docs/elements/dynabomb_increase_number.txt", "start": 99617, "end": 100091}, {"filename": "/docs/elements/em_gate_1.txt", "start": 100091, "end": 100379}, {"filename": "/docs/elements/bdx_steelwall_explodable.txt", "start": 100379, "end": 100444}, {"filename": "/docs/elements/custom.txt", "start": 100444, "end": 101010}, {"filename": "/docs/elements/trigger_ce_value.txt", "start": 101010, "end": 101273}, {"filename": "/docs/elements/bdx_sand_sloped.txt", "start": 101273, "end": 101381}, {"filename": "/docs/elements/sp_chip_single.txt", "start": 101381, "end": 101428}, {"filename": "/docs/elements/next_ce.txt", "start": 101428, "end": 101608}, {"filename": "/docs/elements/quicksand_full.txt", "start": 101608, "end": 101721}, {"filename": "/docs/elements/bdx_player.txt", "start": 101721, "end": 101874}, {"filename": "/docs/elements/sp_port_vertical.txt", "start": 101874, "end": 101900}, {"filename": "/docs/elements/amoeba_full.txt", "start": 101900, "end": 102038}, {"filename": "/docs/elements/em_gate_3.txt", "start": 102038, "end": 102326}, {"filename": "/docs/elements/df_cell.txt", "start": 102326, "end": 102395}, {"filename": "/docs/elements/bdx_stonefly.txt", "start": 102395, "end": 102499}, {"filename": "/docs/elements/bdx_wall.txt", "start": 102499, "end": 102723}, {"filename": "/docs/elements/df_wooden_grid_fixed.txt", "start": 102723, "end": 102832}, {"filename": "/docs/elements/em_gate_3_gray.txt", "start": 102832, "end": 103229}, {"filename": "/docs/elements/gate_3.txt", "start": 103229, "end": 103294}, {"filename": "/docs/elements/emerald.txt", "start": 103294, "end": 103420}, {"filename": "/docs/elements/mm_polarizer.txt", "start": 103420, "end": 103515}, {"filename": "/docs/elements/mm_kettle.txt", "start": 103515, "end": 103667}, {"filename": "/docs/elements/emc_dripper.txt", "start": 103667, "end": 103812}, {"filename": "/docs/elements/emc_gate_8.txt", "start": 103812, "end": 104100}, {"filename": "/docs/elements/wall_emerald.txt", "start": 104100, "end": 104215}, {"filename": "/docs/elements/sokoban_field_full.txt", "start": 104215, "end": 104517}, {"filename": "/docs/elements/acid_pool_topleft.txt", "start": 104517, "end": 104597}, {"filename": "/docs/elements/bdx_clock.txt", "start": 104597, "end": 104629}, {"filename": "/docs/elements/sp_hardware_base_4.txt", "start": 104629, "end": 104698}, {"filename": "/docs/elements/bdx_waiting_rock.txt", "start": 104698, "end": 104991}, {"filename": "/docs/elements/extra_time.txt", "start": 104991, "end": 105101}, {"filename": "/docs/elements/em_steel_exit_closed.txt", "start": 105101, "end": 105352}, {"filename": "/docs/elements/emc_key_6.txt", "start": 105352, "end": 105433}, {"filename": "/docs/elements/gate_2.txt", "start": 105433, "end": 105498}, {"filename": "/docs/elements/from_level_template.txt", "start": 105498, "end": 105735}, {"filename": "/docs/elements/sp_electron.txt", "start": 105735, "end": 105879}, {"filename": "/docs/elements/invisible_steelwall.txt", "start": 105879, "end": 106036}, {"filename": "/docs/elements/sp_hardware_base_3.txt", "start": 106036, "end": 106105}, {"filename": "/docs/elements/bdx_time_penalty.txt", "start": 106105, "end": 106279}, {"filename": "/docs/elements/bd_magic_wall.txt", "start": 106279, "end": 106737}, {"filename": "/docs/elements/sp_sniksnak.txt", "start": 106737, "end": 106816}, {"filename": "/docs/elements/bdx_expandable_wall_switch.txt", "start": 106816, "end": 106887}, {"filename": "/docs/elements/em_key_1.txt", "start": 106887, "end": 106968}, {"filename": "/docs/elements/wall_emerald_red.txt", "start": 106968, "end": 107086}, {"filename": "/docs/elements/bdx_water.txt", "start": 107086, "end": 107130}, {"filename": "/docs/elements/mm_fuel.txt", "start": 107130, "end": 107257}, {"filename": "/docs/elements/wall_bd_diamond.txt", "start": 107257, "end": 107382}, {"filename": "/docs/elements/em_gate_2.txt", "start": 107382, "end": 107670}, {"filename": "/docs/elements/bdx_exploding.txt", "start": 107670, "end": 107690}, {"filename": "/docs/elements/dc_key_white.txt", "start": 107690, "end": 107925}, {"filename": "/docs/elements/emc_plant.txt", "start": 107925, "end": 107987}, {"filename": "/docs/elements/robot.txt", "start": 107987, "end": 108211}, {"filename": "/docs/elements/invisible_wall.txt", "start": 108211, "end": 108356}, {"filename": "/docs/elements/bdx_wall_sloped_up_right.txt", "start": 108356, "end": 108483}, {"filename": "/docs/elements/sp_hardware_green.txt", "start": 108483, "end": 108552}, {"filename": "/docs/elements/emc_magnifier.txt", "start": 108552, "end": 108661}, {"filename": "/docs/elements/arrow_up.txt", "start": 108661, "end": 108745}, {"filename": "/docs/elements/mm_exit.txt", "start": 108745, "end": 108889}, {"filename": "/docs/elements/sokoban_field_player.txt", "start": 108889, "end": 109103}, {"filename": "/docs/elements/sp_gravity_port.txt", "start": 109103, "end": 109210}, {"filename": "/docs/elements/wall_pearl.txt", "start": 109210, "end": 109322}, {"filename": "/docs/elements/em_key_2.txt", "start": 109322, "end": 109403}, {"filename": "/docs/program/program_1.txt", "start": 109403, "end": 109712}, {"filename": "/levels/Classic_Games/levelinfo.conf", "start": 109712, "end": 110010}, {"filename": "/levels/Classic_Games/classic_supaplex/levels.dat", "start": 110010, "end": 280506}, {"filename": "/levels/Classic_Games/classic_supaplex/levelinfo.conf", "start": 280506, "end": 280796}, {"filename": "/levels/Classic_Games/classic_emerald_mine/helpanim.conf", "start": 280796, "end": 285008}, {"filename": "/levels/Classic_Games/classic_emerald_mine/94", "start": 285008, "end": 287114}, {"filename": "/levels/Classic_Games/classic_emerald_mine/73", "start": 287114, "end": 289220}, {"filename": "/levels/Classic_Games/classic_emerald_mine/89", "start": 289220, "end": 291326}, {"filename": "/levels/Classic_Games/classic_emerald_mine/37", "start": 291326, "end": 293432}, {"filename": "/levels/Classic_Games/classic_emerald_mine/1", "start": 293432, "end": 295538}, {"filename": "/levels/Classic_Games/classic_emerald_mine/87", "start": 295538, "end": 297644}, {"filename": "/levels/Classic_Games/classic_emerald_mine/4", "start": 297644, "end": 299750}, {"filename": "/levels/Classic_Games/classic_emerald_mine/24", "start": 299750, "end": 301856}, {"filename": "/levels/Classic_Games/classic_emerald_mine/9", "start": 301856, "end": 303962}, {"filename": "/levels/Classic_Games/classic_emerald_mine/16", "start": 303962, "end": 306068}, {"filename": "/levels/Classic_Games/classic_emerald_mine/5", "start": 306068, "end": 308174}, {"filename": "/levels/Classic_Games/classic_emerald_mine/23", "start": 308174, "end": 310280}, {"filename": "/levels/Classic_Games/classic_emerald_mine/0", "start": 310280, "end": 312386}, {"filename": "/levels/Classic_Games/classic_emerald_mine/80", "start": 312386, "end": 314492}, {"filename": "/levels/Classic_Games/classic_emerald_mine/92", "start": 314492, "end": 316598}, {"filename": "/levels/Classic_Games/classic_emerald_mine/54", "start": 316598, "end": 318704}, {"filename": "/levels/Classic_Games/classic_emerald_mine/27", "start": 318704, "end": 320810}, {"filename": "/levels/Classic_Games/classic_emerald_mine/64", "start": 320810, "end": 322916}, {"filename": "/levels/Classic_Games/classic_emerald_mine/95", "start": 322916, "end": 325022}, {"filename": "/levels/Classic_Games/classic_emerald_mine/101", "start": 325022, "end": 327128}, {"filename": "/levels/Classic_Games/classic_emerald_mine/81", "start": 327128, "end": 329234}, {"filename": "/levels/Classic_Games/classic_emerald_mine/96", "start": 329234, "end": 331340}, {"filename": "/levels/Classic_Games/classic_emerald_mine/34", "start": 331340, "end": 333446}, {"filename": "/levels/Classic_Games/classic_emerald_mine/49", "start": 333446, "end": 335552}, {"filename": "/levels/Classic_Games/classic_emerald_mine/42", "start": 335552, "end": 337658}, {"filename": "/levels/Classic_Games/classic_emerald_mine/99", "start": 337658, "end": 339764}, {"filename": "/levels/Classic_Games/classic_emerald_mine/86", "start": 339764, "end": 341870}, {"filename": "/levels/Classic_Games/classic_emerald_mine/20", "start": 341870, "end": 343976}, {"filename": "/levels/Classic_Games/classic_emerald_mine/15", "start": 343976, "end": 346082}, {"filename": "/levels/Classic_Games/classic_emerald_mine/26", "start": 346082, "end": 348188}, {"filename": "/levels/Classic_Games/classic_emerald_mine/51", "start": 348188, "end": 350294}, {"filename": "/levels/Classic_Games/classic_emerald_mine/84", "start": 350294, "end": 352400}, {"filename": "/levels/Classic_Games/classic_emerald_mine/14", "start": 352400, "end": 354506}, {"filename": "/levels/Classic_Games/classic_emerald_mine/90", "start": 354506, "end": 356612}, {"filename": "/levels/Classic_Games/classic_emerald_mine/33", "start": 356612, "end": 358718}, {"filename": "/levels/Classic_Games/classic_emerald_mine/50", "start": 358718, "end": 360824}, {"filename": "/levels/Classic_Games/classic_emerald_mine/3", "start": 360824, "end": 362930}, {"filename": "/levels/Classic_Games/classic_emerald_mine/29", "start": 362930, "end": 365036}, {"filename": "/levels/Classic_Games/classic_emerald_mine/39", "start": 365036, "end": 367142}, {"filename": "/levels/Classic_Games/classic_emerald_mine/72", "start": 367142, "end": 369248}, {"filename": "/levels/Classic_Games/classic_emerald_mine/65", "start": 369248, "end": 371354}, {"filename": "/levels/Classic_Games/classic_emerald_mine/10", "start": 371354, "end": 373460}, {"filename": "/levels/Classic_Games/classic_emerald_mine/93", "start": 373460, "end": 375566}, {"filename": "/levels/Classic_Games/classic_emerald_mine/32", "start": 375566, "end": 377672}, {"filename": "/levels/Classic_Games/classic_emerald_mine/43", "start": 377672, "end": 379778}, {"filename": "/levels/Classic_Games/classic_emerald_mine/59", "start": 379778, "end": 381884}, {"filename": "/levels/Classic_Games/classic_emerald_mine/19", "start": 381884, "end": 383990}, {"filename": "/levels/Classic_Games/classic_emerald_mine/helptext.conf", "start": 383990, "end": 386512}, {"filename": "/levels/Classic_Games/classic_emerald_mine/79", "start": 386512, "end": 388618}, {"filename": "/levels/Classic_Games/classic_emerald_mine/83", "start": 388618, "end": 390724}, {"filename": "/levels/Classic_Games/classic_emerald_mine/75", "start": 390724, "end": 392830}, {"filename": "/levels/Classic_Games/classic_emerald_mine/35", "start": 392830, "end": 394936}, {"filename": "/levels/Classic_Games/classic_emerald_mine/60", "start": 394936, "end": 397042}, {"filename": "/levels/Classic_Games/classic_emerald_mine/30", "start": 397042, "end": 399148}, {"filename": "/levels/Classic_Games/classic_emerald_mine/97", "start": 399148, "end": 401254}, {"filename": "/levels/Classic_Games/classic_emerald_mine/45", "start": 401254, "end": 403360}, {"filename": "/levels/Classic_Games/classic_emerald_mine/52", "start": 403360, "end": 405466}, {"filename": "/levels/Classic_Games/classic_emerald_mine/2", "start": 405466, "end": 407572}, {"filename": "/levels/Classic_Games/classic_emerald_mine/25", "start": 407572, "end": 409678}, {"filename": "/levels/Classic_Games/classic_emerald_mine/41", "start": 409678, "end": 411784}, {"filename": "/levels/Classic_Games/classic_emerald_mine/71", "start": 411784, "end": 413890}, {"filename": "/levels/Classic_Games/classic_emerald_mine/77", "start": 413890, "end": 415996}, {"filename": "/levels/Classic_Games/classic_emerald_mine/58", "start": 415996, "end": 418102}, {"filename": "/levels/Classic_Games/classic_emerald_mine/12", "start": 418102, "end": 420208}, {"filename": "/levels/Classic_Games/classic_emerald_mine/100", "start": 420208, "end": 422314}, {"filename": "/levels/Classic_Games/classic_emerald_mine/44", "start": 422314, "end": 424420}, {"filename": "/levels/Classic_Games/classic_emerald_mine/62", "start": 424420, "end": 426526}, {"filename": "/levels/Classic_Games/classic_emerald_mine/68", "start": 426526, "end": 428632}, {"filename": "/levels/Classic_Games/classic_emerald_mine/38", "start": 428632, "end": 430738}, {"filename": "/levels/Classic_Games/classic_emerald_mine/47", "start": 430738, "end": 432844}, {"filename": "/levels/Classic_Games/classic_emerald_mine/61", "start": 432844, "end": 434950}, {"filename": "/levels/Classic_Games/classic_emerald_mine/53", "start": 434950, "end": 437056}, {"filename": "/levels/Classic_Games/classic_emerald_mine/66", "start": 437056, "end": 439162}, {"filename": "/levels/Classic_Games/classic_emerald_mine/levelinfo.conf", "start": 439162, "end": 439505}, {"filename": "/levels/Classic_Games/classic_emerald_mine/57", "start": 439505, "end": 441611}, {"filename": "/levels/Classic_Games/classic_emerald_mine/36", "start": 441611, "end": 443717}, {"filename": "/levels/Classic_Games/classic_emerald_mine/31", "start": 443717, "end": 445823}, {"filename": "/levels/Classic_Games/classic_emerald_mine/55", "start": 445823, "end": 447929}, {"filename": "/levels/Classic_Games/classic_emerald_mine/6", "start": 447929, "end": 450035}, {"filename": "/levels/Classic_Games/classic_emerald_mine/11", "start": 450035, "end": 452141}, {"filename": "/levels/Classic_Games/classic_emerald_mine/82", "start": 452141, "end": 454247}, {"filename": "/levels/Classic_Games/classic_emerald_mine/85", "start": 454247, "end": 456353}, {"filename": "/levels/Classic_Games/classic_emerald_mine/88", "start": 456353, "end": 458459}, {"filename": "/levels/Classic_Games/classic_emerald_mine/98", "start": 458459, "end": 460565}, {"filename": "/levels/Classic_Games/classic_emerald_mine/91", "start": 460565, "end": 462671}, {"filename": "/levels/Classic_Games/classic_emerald_mine/8", "start": 462671, "end": 464777}, {"filename": "/levels/Classic_Games/classic_emerald_mine/56", "start": 464777, "end": 466883}, {"filename": "/levels/Classic_Games/classic_emerald_mine/48", "start": 466883, "end": 468989}, {"filename": "/levels/Classic_Games/classic_emerald_mine/78", "start": 468989, "end": 471095}, {"filename": "/levels/Classic_Games/classic_emerald_mine/67", "start": 471095, "end": 473201}, {"filename": "/levels/Classic_Games/classic_emerald_mine/22", "start": 473201, "end": 475307}, {"filename": "/levels/Classic_Games/classic_emerald_mine/76", "start": 475307, "end": 477413}, {"filename": "/levels/Classic_Games/classic_emerald_mine/46", "start": 477413, "end": 479519}, {"filename": "/levels/Classic_Games/classic_emerald_mine/63", "start": 479519, "end": 481625}, {"filename": "/levels/Classic_Games/classic_emerald_mine/17", "start": 481625, "end": 483731}, {"filename": "/levels/Classic_Games/classic_emerald_mine/7", "start": 483731, "end": 485837}, {"filename": "/levels/Classic_Games/classic_emerald_mine/69", "start": 485837, "end": 487943}, {"filename": "/levels/Classic_Games/classic_emerald_mine/18", "start": 487943, "end": 490049}, {"filename": "/levels/Classic_Games/classic_emerald_mine/40", "start": 490049, "end": 492155}, {"filename": "/levels/Classic_Games/classic_emerald_mine/74", "start": 492155, "end": 494261}, {"filename": "/levels/Classic_Games/classic_emerald_mine/28", "start": 494261, "end": 496367}, {"filename": "/levels/Classic_Games/classic_emerald_mine/70", "start": 496367, "end": 498473}, {"filename": "/levels/Classic_Games/classic_emerald_mine/21", "start": 498473, "end": 500579}, {"filename": "/levels/Classic_Games/classic_emerald_mine/13", "start": 500579, "end": 502685}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/levelinfo.conf", "start": 502685, "end": 502977}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash_native/levels.bd", "start": 502977, "end": 523487}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash_native/levelinfo.conf", "start": 523487, "end": 523784}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/064.level", "start": 523784, "end": 524174}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/049.level", "start": 524174, "end": 524564}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/054.level", "start": 524564, "end": 524954}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/023.level", "start": 524954, "end": 525984}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/015.level", "start": 525984, "end": 527014}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/092.level", "start": 527014, "end": 528044}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/069.level", "start": 528044, "end": 528434}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/038.level", "start": 528434, "end": 529464}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/030.level", "start": 529464, "end": 530494}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/093.level", "start": 530494, "end": 531524}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/074.level", "start": 531524, "end": 531914}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/031.level", "start": 531914, "end": 532944}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/040.level", "start": 532944, "end": 533974}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/008.level", "start": 533974, "end": 535004}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/041.level", "start": 535004, "end": 536034}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/019.level", "start": 536034, "end": 536424}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/010.level", "start": 536424, "end": 537454}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/003.level", "start": 537454, "end": 538484}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/024.level", "start": 538484, "end": 538874}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/048.level", "start": 538874, "end": 539904}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/021.level", "start": 539904, "end": 540934}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/047.level", "start": 540934, "end": 541964}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/055.level", "start": 541964, "end": 542994}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/065.level", "start": 542994, "end": 544024}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/044.level", "start": 544024, "end": 544414}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/025.level", "start": 544414, "end": 545444}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/012.level", "start": 545444, "end": 546474}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/014.level", "start": 546474, "end": 546864}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/035.level", "start": 546864, "end": 547894}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/081.level", "start": 547894, "end": 548924}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/004.level", "start": 548924, "end": 549314}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/099.level", "start": 549314, "end": 549704}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/027.level", "start": 549704, "end": 550734}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/078.level", "start": 550734, "end": 551764}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/071.level", "start": 551764, "end": 552794}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/034.level", "start": 552794, "end": 553184}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/089.level", "start": 553184, "end": 553574}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/070.level", "start": 553574, "end": 554604}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/091.level", "start": 554604, "end": 555634}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/059.level", "start": 555634, "end": 556024}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/051.level", "start": 556024, "end": 557054}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/013.level", "start": 557054, "end": 558084}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/057.level", "start": 558084, "end": 559114}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/076.level", "start": 559114, "end": 560144}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/002.level", "start": 560144, "end": 561174}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/072.level", "start": 561174, "end": 562204}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/088.level", "start": 562204, "end": 563234}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/029.level", "start": 563234, "end": 563624}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/080.level", "start": 563624, "end": 564654}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/060.level", "start": 564654, "end": 565684}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/082.level", "start": 565684, "end": 566714}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/083.level", "start": 566714, "end": 567744}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/043.level", "start": 567744, "end": 568774}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/046.level", "start": 568774, "end": 569804}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/094.level", "start": 569804, "end": 570194}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/036.level", "start": 570194, "end": 571224}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/033.level", "start": 571224, "end": 572254}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/052.level", "start": 572254, "end": 573284}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/000.level", "start": 573284, "end": 574314}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/098.level", "start": 574314, "end": 575344}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/018.level", "start": 575344, "end": 576374}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/028.level", "start": 576374, "end": 577404}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/032.level", "start": 577404, "end": 578434}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/095.level", "start": 578434, "end": 579464}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/039.level", "start": 579464, "end": 579854}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/020.level", "start": 579854, "end": 580884}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/037.level", "start": 580884, "end": 581914}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/007.level", "start": 581914, "end": 582944}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/067.level", "start": 582944, "end": 583974}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/001.level", "start": 583974, "end": 585004}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/005.level", "start": 585004, "end": 586034}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/053.level", "start": 586034, "end": 587064}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/056.level", "start": 587064, "end": 588094}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/090.level", "start": 588094, "end": 589124}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/061.level", "start": 589124, "end": 590154}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/022.level", "start": 590154, "end": 591184}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/062.level", "start": 591184, "end": 592214}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/058.level", "start": 592214, "end": 593244}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/045.level", "start": 593244, "end": 594274}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/levelinfo.conf", "start": 594274, "end": 594570}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/085.level", "start": 594570, "end": 595600}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/073.level", "start": 595600, "end": 596630}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/016.level", "start": 596630, "end": 597660}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/075.level", "start": 597660, "end": 598690}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/042.level", "start": 598690, "end": 599720}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/068.level", "start": 599720, "end": 600750}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/084.level", "start": 600750, "end": 601140}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/006.level", "start": 601140, "end": 602170}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/097.level", "start": 602170, "end": 603200}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/086.level", "start": 603200, "end": 604230}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/050.level", "start": 604230, "end": 605260}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/009.level", "start": 605260, "end": 605650}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/077.level", "start": 605650, "end": 606680}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/063.level", "start": 606680, "end": 607710}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/026.level", "start": 607710, "end": 608740}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/066.level", "start": 608740, "end": 609770}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/017.level", "start": 609770, "end": 610800}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/011.level", "start": 610800, "end": 611830}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/079.level", "start": 611830, "end": 612220}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/087.level", "start": 612220, "end": 613250}, {"filename": "/levels/Classic_Games/Classic_Boulder_Dash/classic_boulderdash/096.level", "start": 613250, "end": 614280}, {"filename": "/levels/Classic_Games/classic_sokoban/049.level", "start": 614280, "end": 614685}, {"filename": "/levels/Classic_Games/classic_sokoban/023.level", "start": 614685, "end": 615101}, {"filename": "/levels/Classic_Games/classic_sokoban/015.level", "start": 615101, "end": 615523}, {"filename": "/levels/Classic_Games/classic_sokoban/038.level", "start": 615523, "end": 615794}, {"filename": "/levels/Classic_Games/classic_sokoban/030.level", "start": 615794, "end": 616210}, {"filename": "/levels/Classic_Games/classic_sokoban/031.level", "start": 616210, "end": 616648}, {"filename": "/levels/Classic_Games/classic_sokoban/040.level", "start": 616648, "end": 617070}, {"filename": "/levels/Classic_Games/classic_sokoban/008.level", "start": 617070, "end": 617476}, {"filename": "/levels/Classic_Games/classic_sokoban/041.level", "start": 617476, "end": 617911}, {"filename": "/levels/Classic_Games/classic_sokoban/019.level", "start": 617911, "end": 618365}, {"filename": "/levels/Classic_Games/classic_sokoban/010.level", "start": 618365, "end": 618819}, {"filename": "/levels/Classic_Games/classic_sokoban/003.level", "start": 618819, "end": 619139}, {"filename": "/levels/Classic_Games/classic_sokoban/024.level", "start": 619139, "end": 619593}, {"filename": "/levels/Classic_Games/classic_sokoban/048.level", "start": 619593, "end": 619951}, {"filename": "/levels/Classic_Games/classic_sokoban/021.level", "start": 619951, "end": 620326}, {"filename": "/levels/Classic_Games/classic_sokoban/047.level", "start": 620326, "end": 620674}, {"filename": "/levels/Classic_Games/classic_sokoban/044.level", "start": 620674, "end": 621109}, {"filename": "/levels/Classic_Games/classic_sokoban/025.level", "start": 621109, "end": 621563}, {"filename": "/levels/Classic_Games/classic_sokoban/012.level", "start": 621563, "end": 621934}, {"filename": "/levels/Classic_Games/classic_sokoban/014.level", "start": 621934, "end": 622372}, {"filename": "/levels/Classic_Games/classic_sokoban/035.level", "start": 622372, "end": 622826}, {"filename": "/levels/Classic_Games/classic_sokoban/004.level", "start": 622826, "end": 623242}, {"filename": "/levels/Classic_Games/classic_sokoban/027.level", "start": 623242, "end": 623639}, {"filename": "/levels/Classic_Games/classic_sokoban/034.level", "start": 623639, "end": 623999}, {"filename": "/levels/Classic_Games/classic_sokoban/013.level", "start": 623999, "end": 624396}, {"filename": "/levels/Classic_Games/classic_sokoban/002.level", "start": 624396, "end": 624686}, {"filename": "/levels/Classic_Games/classic_sokoban/029.level", "start": 624686, "end": 625083}, {"filename": "/levels/Classic_Games/classic_sokoban/043.level", "start": 625083, "end": 625442}, {"filename": "/levels/Classic_Games/classic_sokoban/046.level", "start": 625442, "end": 625816}, {"filename": "/levels/Classic_Games/classic_sokoban/036.level", "start": 625816, "end": 626270}, {"filename": "/levels/Classic_Games/classic_sokoban/033.level", "start": 626270, "end": 626600}, {"filename": "/levels/Classic_Games/classic_sokoban/018.level", "start": 626600, "end": 626997}, {"filename": "/levels/Classic_Games/classic_sokoban/028.level", "start": 626997, "end": 627402}, {"filename": "/levels/Classic_Games/classic_sokoban/032.level", "start": 627402, "end": 627747}, {"filename": "/levels/Classic_Games/classic_sokoban/039.level", "start": 627747, "end": 628201}, {"filename": "/levels/Classic_Games/classic_sokoban/020.level", "start": 628201, "end": 628655}, {"filename": "/levels/Classic_Games/classic_sokoban/037.level", "start": 628655, "end": 629090}, {"filename": "/levels/Classic_Games/classic_sokoban/007.level", "start": 629090, "end": 629396}, {"filename": "/levels/Classic_Games/classic_sokoban/001.level", "start": 629396, "end": 629755}, {"filename": "/levels/Classic_Games/classic_sokoban/005.level", "start": 629755, "end": 630126}, {"filename": "/levels/Classic_Games/classic_sokoban/022.level", "start": 630126, "end": 630580}, {"filename": "/levels/Classic_Games/classic_sokoban/045.level", "start": 630580, "end": 630954}, {"filename": "/levels/Classic_Games/classic_sokoban/levelinfo.conf", "start": 630954, "end": 631167}, {"filename": "/levels/Classic_Games/classic_sokoban/016.level", "start": 631167, "end": 631527}, {"filename": "/levels/Classic_Games/classic_sokoban/042.level", "start": 631527, "end": 631911}, {"filename": "/levels/Classic_Games/classic_sokoban/006.level", "start": 631911, "end": 632193}, {"filename": "/levels/Classic_Games/classic_sokoban/050.level", "start": 632193, "end": 632647}, {"filename": "/levels/Classic_Games/classic_sokoban/009.level", "start": 632647, "end": 633035}, {"filename": "/levels/Classic_Games/classic_sokoban/026.level", "start": 633035, "end": 633365}, {"filename": "/levels/Classic_Games/classic_sokoban/017.level", "start": 633365, "end": 633739}, {"filename": "/levels/Classic_Games/classic_sokoban/011.level", "start": 633739, "end": 634174}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/004.tape", "start": 634174, "end": 636026}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/013.tape", "start": 636026, "end": 637386}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/016.tape", "start": 637386, "end": 639410}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/027.tape", "start": 639410, "end": 642548}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/041.tape", "start": 642548, "end": 643712}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/040.tape", "start": 643712, "end": 646974}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/014.tape", "start": 646974, "end": 649486}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/006.tape", "start": 649486, "end": 650174}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/050.tape", "start": 650174, "end": 653426}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/049.tape", "start": 653426, "end": 654682}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/044.tape", "start": 654682, "end": 655898}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/007.tape", "start": 655898, "end": 656670}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/002.tape", "start": 656670, "end": 657802}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/011.tape", "start": 657802, "end": 660380}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/038.tape", "start": 660380, "end": 661224}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/020.tape", "start": 661224, "end": 665104}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/021.tape", "start": 665104, "end": 666270}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/043.tape", "start": 666270, "end": 667566}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/045.tape", "start": 667566, "end": 669834}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/024.tape", "start": 669834, "end": 672874}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/009.tape", "start": 672874, "end": 673994}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/003.tape", "start": 673994, "end": 674764}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/031.tape", "start": 674764, "end": 676718}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/018.tape", "start": 676718, "end": 678310}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/023.tape", "start": 678310, "end": 681558}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/015.tape", "start": 681558, "end": 682984}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/032.tape", "start": 682984, "end": 684112}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/030.tape", "start": 684112, "end": 686916}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/010.tape", "start": 686916, "end": 689422}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/026.tape", "start": 689422, "end": 690894}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/025.tape", "start": 690894, "end": 693710}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/028.tape", "start": 693710, "end": 695662}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/046.tape", "start": 695662, "end": 697374}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/036.tape", "start": 697374, "end": 700462}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/012.tape", "start": 700462, "end": 702140}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/029.tape", "start": 702140, "end": 703584}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/019.tape", "start": 703584, "end": 705048}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/008.tape", "start": 705048, "end": 706240}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/048.tape", "start": 706240, "end": 707364}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/001.tape", "start": 707364, "end": 707780}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/005.tape", "start": 707780, "end": 708610}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/042.tape", "start": 708610, "end": 710214}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/022.tape", "start": 710214, "end": 713326}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/047.tape", "start": 713326, "end": 714718}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/039.tape", "start": 714718, "end": 718542}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/017.tape", "start": 718542, "end": 719726}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/035.tape", "start": 719726, "end": 722094}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/034.tape", "start": 722094, "end": 723808}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/037.tape", "start": 723808, "end": 725752}, {"filename": "/levels/Classic_Games/classic_sokoban/tapes/033.tape", "start": 725752, "end": 727724}, {"filename": "/levels/Tutorials/levelinfo.conf", "start": 727724, "end": 727962}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/003.level", "start": 727962, "end": 728716}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/004.level", "start": 728716, "end": 729912}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/unused.level", "start": 729912, "end": 731299}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/002.level", "start": 731299, "end": 734767}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/000.level", "start": 734767, "end": 737049}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/007.level", "start": 737049, "end": 738762}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/001.level", "start": 738762, "end": 740393}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/005.level", "start": 740393, "end": 741752}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/levelinfo.conf", "start": 741752, "end": 742136}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/006.level", "start": 742136, "end": 743334}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/README.txt", "start": 743334, "end": 744172}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/tapes/004.tape", "start": 744172, "end": 744432}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/tapes/006.tape", "start": 744432, "end": 744695}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/tapes/007.tape", "start": 744695, "end": 745180}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/tapes/002.tape", "start": 745180, "end": 745991}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/tapes/003.tape", "start": 745991, "end": 746245}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/tapes/000.tape", "start": 746245, "end": 746611}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/tapes/000_TAS.tape", "start": 746611, "end": 748062}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/tapes/000.tape.BROKEN", "start": 748062, "end": 748903}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/tapes/001.tape", "start": 748903, "end": 749799}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/tapes/005.tape", "start": 749799, "end": 749969}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/graphics/ncrtorial_title_screen.png", "start": 749969, "end": 755529}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/graphics/RocksTooMuchBars.png", "start": 755529, "end": 757272}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/graphics/graphicsinfo.conf", "start": 757272, "end": 762631}, {"filename": "/levels/Tutorials/rnd_tutorial_ncrecc/graphics/RocksTooMuchPanel.png", "start": 762631, "end": 766780}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/023.level", "start": 766780, "end": 767544}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/015.level", "start": 767544, "end": 768336}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/038.level", "start": 768336, "end": 769129}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/030.level", "start": 769129, "end": 769550}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/031.level", "start": 769550, "end": 769971}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/040.level", "start": 769971, "end": 770617}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/008.level", "start": 770617, "end": 771448}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/019.level", "start": 771448, "end": 772331}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/010.level", "start": 772331, "end": 773111}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/012.level.orig", "start": 773111, "end": 773871}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/003.level", "start": 773871, "end": 774765}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/024.level", "start": 774765, "end": 775526}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/021.level", "start": 775526, "end": 776267}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/025.level", "start": 776267, "end": 777315}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/012.level", "start": 777315, "end": 778278}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/014.level", "start": 778278, "end": 779052}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/035.level", "start": 779052, "end": 779827}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/004.level.orig", "start": 779827, "end": 780587}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/004.level", "start": 780587, "end": 781493}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/027.level", "start": 781493, "end": 781914}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/034.level", "start": 781914, "end": 782560}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/README", "start": 782560, "end": 783471}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/013.level", "start": 783471, "end": 784467}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/002.level", "start": 784467, "end": 785292}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/README.orig", "start": 785292, "end": 786090}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/029.level", "start": 786090, "end": 786930}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/036.level", "start": 786930, "end": 787576}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/033.level", "start": 787576, "end": 788270}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/018.level", "start": 788270, "end": 788979}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/028.level", "start": 788979, "end": 789788}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/032.level", "start": 789788, "end": 790209}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/039.level", "start": 790209, "end": 790914}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/020.level", "start": 790914, "end": 791731}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/037.level", "start": 791731, "end": 792677}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/007.level", "start": 792677, "end": 793495}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/001.level", "start": 793495, "end": 794568}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/005.level", "start": 794568, "end": 795359}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/022.level", "start": 795359, "end": 796079}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/levelinfo.conf", "start": 796079, "end": 796390}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/016.level", "start": 796390, "end": 797264}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/042.level", "start": 797264, "end": 803686}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/006.level", "start": 803686, "end": 804607}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/009.level", "start": 804607, "end": 805365}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/026.level", "start": 805365, "end": 806112}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/017.level", "start": 806112, "end": 806898}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/011.level", "start": 806898, "end": 807646}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/README.txt", "start": 807646, "end": 808424}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/004.tape", "start": 808424, "end": 808789}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/013.tape", "start": 808789, "end": 809100}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/016.tape", "start": 809100, "end": 809381}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/027.tape", "start": 809381, "end": 809868}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/040.tape", "start": 809868, "end": 810297}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/014.tape", "start": 810297, "end": 810496}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/006.tape", "start": 810496, "end": 810685}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/007.tape", "start": 810685, "end": 810994}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/002.tape", "start": 810994, "end": 811197}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/011.tape", "start": 811197, "end": 811480}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/038.tape", "start": 811480, "end": 811875}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/020.tape", "start": 811875, "end": 812146}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/021.tape", "start": 812146, "end": 812627}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/024.tape", "start": 812627, "end": 812974}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/009.tape", "start": 812974, "end": 813099}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/003.tape", "start": 813099, "end": 813264}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/031.tape", "start": 813264, "end": 813815}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/018.tape", "start": 813815, "end": 814162}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/023.tape", "start": 814162, "end": 814297}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/015.tape", "start": 814297, "end": 814584}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/032.tape", "start": 814584, "end": 815387}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/030.tape", "start": 815387, "end": 815818}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/010.tape", "start": 815818, "end": 816095}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/026.tape", "start": 816095, "end": 816284}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/025.tape", "start": 816284, "end": 816825}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/028.tape", "start": 816825, "end": 818538}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/036.tape", "start": 818538, "end": 818803}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/012.tape", "start": 818803, "end": 819170}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/029.tape", "start": 819170, "end": 819721}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/019.tape", "start": 819721, "end": 820126}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/008.tape", "start": 820126, "end": 820501}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/001.tape", "start": 820501, "end": 820650}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/005.tape", "start": 820650, "end": 820931}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/022.tape", "start": 820931, "end": 821388}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/039.tape", "start": 821388, "end": 822047}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/017.tape", "start": 822047, "end": 822580}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/035.tape", "start": 822580, "end": 823077}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/034.tape", "start": 823077, "end": 823640}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/037.tape", "start": 823640, "end": 823975}, {"filename": "/levels/Tutorials/rnd_tutorial_niko_boehm/tapes/033.tape", "start": 823975, "end": 824308}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/023.level", "start": 824308, "end": 826286}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/015.level", "start": 826286, "end": 827346}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/008.level", "start": 827346, "end": 829510}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/019.level", "start": 829510, "end": 831353}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/010.level", "start": 831353, "end": 832329}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/003.level", "start": 832329, "end": 832772}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/024.level", "start": 832772, "end": 835464}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/021.level", "start": 835464, "end": 838626}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/025.level", "start": 838626, "end": 839791}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/012.level", "start": 839791, "end": 842821}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/014.level", "start": 842821, "end": 845536}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/004.level.orig", "start": 845536, "end": 846504}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/004.level", "start": 846504, "end": 847472}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/013.level", "start": 847472, "end": 849521}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/002.level", "start": 849521, "end": 850092}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/001.level.orig", "start": 850092, "end": 852154}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/016.level.orig", "start": 852154, "end": 856614}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/018.level", "start": 856614, "end": 857490}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/020.level", "start": 857490, "end": 859833}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/007.level", "start": 859833, "end": 861692}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/001.level", "start": 861692, "end": 863761}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/005.level", "start": 863761, "end": 864917}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/022.level", "start": 864917, "end": 867608}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/levelinfo.conf", "start": 867608, "end": 867903}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/005.level.orig", "start": 867903, "end": 869059}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/016.level", "start": 869059, "end": 873519}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/006.level", "start": 873519, "end": 874907}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/009.level", "start": 874907, "end": 875303}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/026.level", "start": 875303, "end": 878605}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/017.level", "start": 878605, "end": 880657}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/011.level", "start": 880657, "end": 881191}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/004.tape", "start": 881191, "end": 881538}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/013.tape", "start": 881538, "end": 882223}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/016.tape", "start": 882223, "end": 883258}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/014.tape", "start": 883258, "end": 883525}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/006.tape", "start": 883525, "end": 884060}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/007.tape", "start": 884060, "end": 884547}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/002.tape", "start": 884547, "end": 884832}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/011.tape", "start": 884832, "end": 885119}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/020.tape", "start": 885119, "end": 886308}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/021.tape", "start": 886308, "end": 886841}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/024.tape", "start": 886841, "end": 887300}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/009.tape", "start": 887300, "end": 887455}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/003.tape", "start": 887455, "end": 887962}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/018.tape", "start": 887962, "end": 888173}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/023.tape", "start": 888173, "end": 888892}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/015.tape", "start": 888892, "end": 889343}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/016.tape.orig", "start": 889343, "end": 890312}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/010.tape", "start": 890312, "end": 890689}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/026.tape", "start": 890689, "end": 891088}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/025.tape", "start": 891088, "end": 891447}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/012.tape", "start": 891447, "end": 892720}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/019.tape", "start": 892720, "end": 893129}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/008.tape", "start": 893129, "end": 893506}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/001.tape", "start": 893506, "end": 894145}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/005.tape", "start": 894145, "end": 894432}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/022.tape", "start": 894432, "end": 895005}, {"filename": "/levels/Tutorials/rnd_tutorial_aaron_davidson/tapes/017.tape", "start": 895005, "end": 895782}, {"filename": "/graphics/Makefile", "start": 895782, "end": 896825}, {"filename": "/graphics/gfx_classic/RocksDoor2.png", "start": 896825, "end": 899077}, {"filename": "/graphics/gfx_classic/RocksFontSmall.png", "start": 899077, "end": 905728}, {"filename": "/graphics/gfx_classic/RocksBD.png", "start": 905728, "end": 927734}, {"filename": "/graphics/gfx_classic/RocksCollect.png", "start": 927734, "end": 1038683}, {"filename": "/graphics/gfx_classic/RocksDF.png", "start": 1038683, "end": 1057836}, {"filename": "/graphics/gfx_classic/RocksFontDC.png", "start": 1057836, "end": 1065886}, {"filename": "/graphics/gfx_classic/RocksFontEM.png", "start": 1065886, "end": 1076321}, {"filename": "/graphics/gfx_classic/RocksDC2.png", "start": 1076321, "end": 1086178}, {"filename": "/graphics/gfx_classic/RocksFontBig.png", "start": 1086178, "end": 1112273}, {"filename": "/graphics/gfx_classic/RocksDoorMM.png", "start": 1112273, "end": 1113218}, {"filename": "/graphics/gfx_classic/RocksBD2.png", "start": 1113218, "end": 1122306}, {"filename": "/graphics/gfx_classic/RocksElements.png", "start": 1122306, "end": 1160301}, {"filename": "/graphics/gfx_classic/RocksMM.png", "start": 1160301, "end": 1181236}, {"filename": "/graphics/gfx_classic/RocksCE.png", "start": 1181236, "end": 1197990}, {"filename": "/graphics/gfx_classic/RocksScreen.png", "start": 1197990, "end": 1203374}, {"filename": "/graphics/gfx_classic/RocksToons.png", "start": 1203374, "end": 1212997}, {"filename": "/graphics/gfx_classic/graphicsinfo.conf", "start": 1212997, "end": 1213099}, {"filename": "/graphics/gfx_classic/Makefile", "start": 1213099, "end": 1215015}, {"filename": "/graphics/gfx_classic/RocksBusy.png", "start": 1215015, "end": 1217119}, {"filename": "/graphics/gfx_classic/RocksTouch.png", "start": 1217119, "end": 1221335}, {"filename": "/graphics/gfx_classic/RocksHeroes.png", "start": 1221335, "end": 1248682}, {"filename": "/graphics/gfx_classic/RocksDoor.png", "start": 1248682, "end": 1268504}, {"filename": "/graphics/gfx_classic/RocksMore.png", "start": 1268504, "end": 1281809}, {"filename": "/graphics/gfx_classic/RocksDC.png", "start": 1281809, "end": 1316903}, {"filename": "/graphics/gfx_classic/RocksSP.png", "start": 1316903, "end": 1352423}, {"filename": "/graphics/gfx_classic/RocksFontMedium.png", "start": 1352423, "end": 1372432}, {"filename": "/graphics/gfx_classic/RocksEMC.png", "start": 1372432, "end": 1392287}, {"filename": "/graphics/gfx_classic/joystick/controller.png", "start": 1392287, "end": 1451258}, {"filename": "/graphics/gfx_classic/joystick/button.png", "start": 1451258, "end": 1453655}, {"filename": "/graphics/gfx_classic/joystick/axis_x.png", "start": 1453655, "end": 1455882}, {"filename": "/graphics/gfx_classic/joystick/axis_y.png", "start": 1455882, "end": 1458151}, {"filename": "/graphics/gfx_classic/icons/icon.png", "start": 1458151, "end": 1464889}, {"filename": "/sounds/snd_classic/base.wav", "start": 1464889, "end": 1465000, "audio": 1}, {"filename": "/sounds/snd_classic/warnton.wav", "start": 1465000, "end": 1467458, "audio": 1}, {"filename": "/sounds/snd_classic/kabumm.wav", "start": 1467458, "end": 1472838, "audio": 1}, {"filename": "/sounds/snd_classic/gong.wav", "start": 1472838, "end": 1481134, "audio": 1}, {"filename": "/sounds/snd_classic/roehr.wav", "start": 1481134, "end": 1492028, "audio": 1}, {"filename": "/sounds/snd_classic/lachen.wav", "start": 1492028, "end": 1546850, "audio": 1}, {"filename": "/sounds/snd_classic/holz.wav", "start": 1546850, "end": 1548156, "audio": 1}, {"filename": "/sounds/snd_classic/knurk.wav", "start": 1548156, "end": 1549912, "audio": 1}, {"filename": "/sounds/snd_classic/zonkdown.wav", "start": 1549912, "end": 1555063, "audio": 1}, {"filename": "/sounds/snd_classic/oeffnen.wav", "start": 1555063, "end": 1594713, "audio": 1}, {"filename": "/sounds/snd_classic/klumpf.wav", "start": 1594713, "end": 1599177, "audio": 1}, {"filename": "/sounds/snd_classic/miep.wav", "start": 1599177, "end": 1600933, "audio": 1}, {"filename": "/sounds/snd_classic/amoebe.wav", "start": 1600933, "end": 1602657, "audio": 1}, {"filename": "/sounds/snd_classic/laser.wav", "start": 1602657, "end": 1606391, "audio": 1}, {"filename": "/sounds/snd_classic/zisch.wav", "start": 1606391, "end": 1622931, "audio": 1}, {"filename": "/sounds/snd_classic/pusch.wav", "start": 1622931, "end": 1631699, "audio": 1}, {"filename": "/sounds/snd_classic/blurb.wav", "start": 1631699, "end": 1634003, "audio": 1}, {"filename": "/sounds/snd_classic/schlurf.wav", "start": 1634003, "end": 1635759, "audio": 1}, {"filename": "/sounds/snd_classic/halloffame.wav", "start": 1635759, "end": 1854547, "audio": 1}, {"filename": "/sounds/snd_classic/klapper.wav", "start": 1854547, "end": 1859367, "audio": 1}, {"filename": "/sounds/snd_classic/crash.wav", "start": 1859367, "end": 1887761, "audio": 1}, {"filename": "/sounds/snd_classic/hui.wav", "start": 1887761, "end": 1890531, "audio": 1}, {"filename": "/sounds/snd_classic/autsch.wav", "start": 1890531, "end": 1903167, "audio": 1}, {"filename": "/sounds/snd_classic/whoosh.wav", "start": 1903167, "end": 1910235, "audio": 1}, {"filename": "/sounds/snd_classic/jingle.wav", "start": 1910235, "end": 2022725, "audio": 1}, {"filename": "/sounds/snd_classic/kling.wav", "start": 2022725, "end": 2026977, "audio": 1}, {"filename": "/sounds/snd_classic/quiek.wav", "start": 2026977, "end": 2030755, "audio": 1}, {"filename": "/sounds/snd_classic/buing.wav", "start": 2030755, "end": 2039245, "audio": 1}, {"filename": "/sounds/snd_classic/sirr.wav", "start": 2039245, "end": 2040467, "audio": 1}, {"filename": "/sounds/snd_classic/bug.wav", "start": 2040467, "end": 2045137, "audio": 1}, {"filename": "/sounds/snd_classic/roaaar.wav", "start": 2045137, "end": 2060307, "audio": 1}, {"filename": "/sounds/snd_classic/njam.wav", "start": 2060307, "end": 2063989, "audio": 1}, {"filename": "/sounds/snd_classic/empty.wav", "start": 2063989, "end": 2064848, "audio": 1}, {"filename": "/sounds/snd_classic/quirk.wav", "start": 2064848, "end": 2070072, "audio": 1}, {"filename": "/sounds/snd_classic/exit.wav", "start": 2070072, "end": 2108395, "audio": 1}, {"filename": "/sounds/snd_classic/zonkpush.wav", "start": 2108395, "end": 2112729, "audio": 1}, {"filename": "/sounds/snd_classic/soundsinfo.conf", "start": 2112729, "end": 2112829}, {"filename": "/sounds/snd_classic/kink.wav", "start": 2112829, "end": 2114981, "audio": 1}, {"filename": "/sounds/snd_classic/slurp.wav", "start": 2114981, "end": 2130763, "audio": 1}, {"filename": "/sounds/snd_classic/hammer.wav", "start": 2130763, "end": 2173301, "audio": 1}, {"filename": "/sounds/snd_classic/gate.wav", "start": 2173301, "end": 2187835, "audio": 1}, {"filename": "/sounds/snd_classic/deng.wav", "start": 2187835, "end": 2193091, "audio": 1}, {"filename": "/sounds/snd_classic/booom.wav", "start": 2193091, "end": 2221296, "audio": 1}, {"filename": "/sounds/snd_classic/infotron.wav", "start": 2221296, "end": 2231002, "audio": 1}, {"filename": "/sounds/snd_classic/fuel.wav", "start": 2231002, "end": 2236310, "audio": 1}, {"filename": "/sounds/snd_classic/knack.wav", "start": 2236310, "end": 2238126, "audio": 1}, {"filename": "/sounds/snd_classic/bong.wav", "start": 2238126, "end": 2244982, "audio": 1}, {"filename": "/sounds/snd_classic/pling.wav", "start": 2244982, "end": 2249626, "audio": 1}, {"filename": "/sounds/snd_classic/pong.wav", "start": 2249626, "end": 2253914, "audio": 1}, {"filename": "/sounds/snd_classic/door.wav", "start": 2253914, "end": 2265652, "audio": 1}, {"filename": "/sounds/snd_classic/klopf.wav", "start": 2265652, "end": 2267572, "audio": 1}, {"filename": "/music/mus_classic/mod.apoplexy", "start": 2267572, "end": 2368358}, {"filename": "/music/mus_classic/musicinfo.conf", "start": 2368358, "end": 2368457}, {"filename": "/music/mus_classic/mod.chiptune", "start": 2368457, "end": 2396055}, {"filename": "/music/mus_classic/rhythmloop.wav", "start": 2396055, "end": 2478051, "audio": 1}, {"filename": "/music/mus_classic/mod.chiptune.txt", "start": 2478051, "end": 2478107}, {"filename": "/music/mus_classic/mod.cream_of_the_earth", "start": 2478107, "end": 2608489}, {"filename": "/music/mus_classic/mod.cream_of_the_earth.txt", "start": 2608489, "end": 2608565}, {"filename": "/music/mus_classic/mod.apoplexy.txt", "start": 2608565, "end": 2608623}], "remote_package_size": 2608623, "package_uuid": "29348fd6-961d-492c-b8be-c6533c8038e6"});

  })();
